/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.modeshape.common.util.CheckArg;

@Entity
@Table(name="DNA_WORKSPACES")
@org.hibernate.annotations.Table(appliesTo="DNA_WORKSPACES", indexes={@Index(name="WS_NAME_INX", columnNames={"NAME"})})
@NamedQueries(value={@NamedQuery(name="WorkspaceEntity.findAll", query="select ws from WorkspaceEntity as ws"), @NamedQuery(name="WorkspaceEntity.findByName", query="select ws from WorkspaceEntity as ws where ws.name = :name"), @NamedQuery(name="WorkspaceEntity.findAllNames", query="select ws.name from WorkspaceEntity as ws")})
public class WorkspaceEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(name="NAME", nullable=false, unique=false, length=128, updatable=false)
    private String name;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WorkspaceEntity) {
            WorkspaceEntity that = (WorkspaceEntity)obj;
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public static WorkspaceEntity findByName(EntityManager manager, String name) {
        return WorkspaceEntity.findByName(manager, name, true);
    }

    public static WorkspaceEntity findByName(EntityManager manager, String name, boolean createIfRequired) {
        CheckArg.isNotNull((Object)manager, (String)"manager");
        CheckArg.isNotNull((Object)name, (String)"name");
        Query query = manager.createNamedQuery("WorkspaceEntity.findByName");
        query.setParameter("name", (Object)name);
        query.setHint("org.hibernate.cacheable", (Object)true);
        try {
            return (WorkspaceEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            if (!createIfRequired) {
                return null;
            }
            WorkspaceEntity workspace = new WorkspaceEntity();
            workspace.setName(name);
            manager.persist((Object)workspace);
            return workspace;
        }
    }

    public static Set<String> findAllNames(EntityManager manager) {
        CheckArg.isNotNull((Object)manager, (String)"manager");
        Query query = manager.createNamedQuery("WorkspaceEntity.findAllNames");
        List names = query.getResultList();
        return new HashSet<String>(names);
    }
}

