/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNProperties
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map myProperties;

    public static SVNProperties wrap(Map map) {
        if (map == null) {
            return new SVNProperties();
        }
        SVNHashMap propertiesMap = new SVNHashMap();
        Iterator names = map.keySet().iterator();
        while (names.hasNext()) {
            Object n = names.next();
            if (!(n instanceof String)) continue;
            Object value = map.get(n);
            SVNPropertyValue v = null;
            if (value instanceof String) {
                v = SVNPropertyValue.create((String)value);
            } else if (value instanceof byte[]) {
                v = SVNPropertyValue.create(n.toString(), (byte[])value);
            } else if (value instanceof SVNPropertyValue) {
                v = (SVNPropertyValue)value;
            }
            if (v == null) continue;
            propertiesMap.put(n, v);
        }
        return new SVNProperties(propertiesMap);
    }

    public static SVNProperties unmodifiableProperties(SVNProperties properties) {
        Map propertiesMap = properties.myProperties;
        propertiesMap = Collections.unmodifiableMap(propertiesMap);
        return new SVNProperties(propertiesMap);
    }

    public SVNProperties() {
        this.myProperties = new SVNHashMap();
    }

    public SVNProperties(SVNProperties properties) {
        this.myProperties = new SVNHashMap(properties.myProperties);
    }

    private SVNProperties(Map properties) {
        this.myProperties = properties;
    }

    public Map asMap() {
        if (this.myProperties == null) {
            return Collections.unmodifiableMap(Collections.EMPTY_MAP);
        }
        return Collections.unmodifiableMap(this.myProperties);
    }

    public void put(String propertyName, SVNPropertyValue propertyValue) {
        this.myProperties.put(propertyName, propertyValue);
    }

    public void put(String propertyName, String propertyValue) {
        this.myProperties.put(propertyName, SVNPropertyValue.create(propertyValue));
    }

    public void put(String propertyName, byte[] propertyValue) {
        this.myProperties.put(propertyName, SVNPropertyValue.create(propertyName, propertyValue));
    }

    public String getStringValue(String propertyName) {
        SVNPropertyValue value = (SVNPropertyValue)this.myProperties.get(propertyName);
        return value == null ? null : value.getString();
    }

    public byte[] getBinaryValue(String propertyName) {
        SVNPropertyValue value = (SVNPropertyValue)this.myProperties.get(propertyName);
        return value == null ? null : value.getBytes();
    }

    public SVNPropertyValue getSVNPropertyValue(String propertyName) {
        return (SVNPropertyValue)this.myProperties.get(propertyName);
    }

    public SVNPropertyValue remove(String propertyName) {
        return (SVNPropertyValue)this.myProperties.remove(propertyName);
    }

    public void putAll(SVNProperties properties) {
        this.myProperties.putAll(properties.myProperties);
    }

    public boolean isEmpty() {
        return this.myProperties.isEmpty();
    }

    public void clear() {
        this.myProperties.clear();
    }

    public void removeNullValues() {
        Iterator iterator = this.myProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (this.myProperties.get(name) != null) continue;
            iterator.remove();
        }
    }

    public int size() {
        return this.myProperties.size();
    }

    public boolean containsName(String propertyName) {
        return this.myProperties.containsKey(propertyName);
    }

    public Set nameSet() {
        return this.myProperties.keySet();
    }

    public boolean containsValue(SVNPropertyValue value) {
        return this.myProperties.containsValue(value);
    }

    public Collection values() {
        return this.myProperties.values();
    }

    public SVNProperties getRegularProperties() {
        SVNProperties result = new SVNProperties();
        Iterator propNamesIter = this.nameSet().iterator();
        while (propNamesIter.hasNext()) {
            String propName = (String)propNamesIter.next();
            if (!SVNProperty.isRegularProperty(propName)) continue;
            result.put(propName, this.getSVNPropertyValue(propName));
        }
        return result;
    }

    public SVNProperties compareTo(SVNProperties properties) {
        SVNProperties result = new SVNProperties();
        if (this.isEmpty()) {
            result.putAll(properties);
            return result;
        }
        Set props1 = this.nameSet();
        Set props2 = properties.nameSet();
        TreeSet tmp = new TreeSet(props1);
        tmp.removeAll(props2);
        Iterator props = tmp.iterator();
        while (props.hasNext()) {
            String missing = (String)props.next();
            result.put(missing, (byte[])null);
        }
        tmp = new TreeSet(props2);
        tmp.removeAll(props1);
        props = tmp.iterator();
        while (props.hasNext()) {
            String added = (String)props.next();
            result.put(added, properties.getSVNPropertyValue(added));
        }
        tmp = new TreeSet(props2);
        tmp.retainAll(props1);
        props = tmp.iterator();
        while (props.hasNext()) {
            SVNPropertyValue value2;
            String changed = (String)props.next();
            SVNPropertyValue value1 = this.getSVNPropertyValue(changed);
            if (value1.equals(value2 = properties.getSVNPropertyValue(changed))) continue;
            result.put(changed, value2);
        }
        return result;
    }

    public int hashCode() {
        return 31 + (this.myProperties == null ? 0 : ((Object)this.myProperties).hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SVNProperties other = (SVNProperties)obj;
        return !(this.myProperties == null ? other.myProperties != null : !((Object)this.myProperties).equals(other.myProperties));
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        SVNProperties result = new SVNProperties();
        result.putAll(this);
        return result;
    }
}

