/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class SVNSynchronizeEditor
implements ISVNEditor {
    private ISVNEditor myWrappedEditor;
    private boolean myIsRootOpened;
    private long myBaseRevision;
    private SVNCommitInfo myCommitInfo;
    private ISVNLogEntryHandler myHandler;
    private SVNRepository myTargetRepository;

    public SVNSynchronizeEditor(SVNRepository toRepository, ISVNLogEntryHandler handler, long baseRevision) {
        this.myTargetRepository = toRepository;
        this.myIsRootOpened = false;
        this.myBaseRevision = baseRevision;
        this.myHandler = handler;
    }

    public void reset(long baseRevision) {
        this.myWrappedEditor = null;
        this.myCommitInfo = null;
        this.myIsRootOpened = false;
        this.myBaseRevision = baseRevision;
    }

    public void abortEdit() throws SVNException {
        this.getWrappedEditor().abortEdit();
    }

    private ISVNEditor getWrappedEditor() throws SVNException {
        if (this.myWrappedEditor == null) {
            this.myWrappedEditor = this.myTargetRepository.getCommitEditor("", null, false, null);
        }
        return this.myWrappedEditor;
    }

    public void absentDir(String path) throws SVNException {
        this.getWrappedEditor().absentDir(path);
    }

    public void absentFile(String path) throws SVNException {
        this.getWrappedEditor().absentFile(path);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.getWrappedEditor().addDir(path, copyFromPath, copyFromRevision);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.getWrappedEditor().addFile(path, copyFromPath, copyFromRevision);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isRegularProperty(name)) {
            this.getWrappedEditor().changeDirProperty(name, value);
        }
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isRegularProperty(name)) {
            this.getWrappedEditor().changeFileProperty(path, name, value);
        }
    }

    public void closeDir() throws SVNException {
        this.getWrappedEditor().closeDir();
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        ISVNEditor wrappedEditor = this.getWrappedEditor();
        if (!this.myIsRootOpened) {
            wrappedEditor.openRoot(this.myBaseRevision);
        }
        this.myCommitInfo = wrappedEditor.closeEdit();
        if (this.myHandler != null) {
            SVNLogEntry logEntry = new SVNLogEntry(null, this.myCommitInfo.getNewRevision(), this.myCommitInfo.getAuthor(), this.myCommitInfo.getDate(), null);
            this.myHandler.handleLogEntry(logEntry);
        }
        return this.myCommitInfo;
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.getWrappedEditor().closeFile(path, textChecksum);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.getWrappedEditor().deleteEntry(path, revision);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.getWrappedEditor().openDir(path, revision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.getWrappedEditor().openFile(path, revision);
    }

    public void openRoot(long revision) throws SVNException {
        this.getWrappedEditor().openRoot(revision);
        this.myIsRootOpened = true;
    }

    public void targetRevision(long revision) throws SVNException {
        this.getWrappedEditor().targetRevision(revision);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.getWrappedEditor().applyTextDelta(path, baseChecksum);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.getWrappedEditor().textDeltaChunk(path, diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.getWrappedEditor().textDeltaEnd(path);
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }
}

