/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.connector.svn.SvnConnectorTestUtil;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.ReadableConnectorTest;

public class SvnRespositoryConnectorReadableTest
extends ReadableConnectorTest {
    private static String url;

    @BeforeClass
    public static void beforeAny() throws Exception {
        url = SvnConnectorTestUtil.createTestRepoURL();
    }

    protected RepositorySource setUpSource() throws Exception {
        String[] predefinedWorkspaceNames = new String[]{"trunk", "tags"};
        SvnRepositorySource source = new SvnRepositorySource();
        source.setName("Test Repository");
        source.setUsername("sp");
        source.setPassword("");
        source.setRepositoryRootUrl(url);
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(false);
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    @Test
    public void shouldFindFolderSpecifiedInPathsAsNodesBelowRoot() {
        Node root = this.graph.getNodeAt("/root");
        this.assertThatNodeIsFolder(root);
        Node dnaSubmission = this.graph.getNodeAt("/root/c/h/JBoss DNA Submission Receipt for JBoss World 2009.pdf");
        this.assertThatNodeIsFile(dnaSubmission, "application/octet-stream", null);
    }

    public void assertThatNodeIsFolder(Node node) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), (Matcher)Is.is((Object)JcrNtLexicon.FOLDER));
    }

    public void assertThatNodeIsFile(Node node, String mimeType, String contents) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), (Matcher)Is.is((Object)JcrNtLexicon.FILE));
        List children = node.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)1));
        Location jcrContentLocation = (Location)children.get(0);
        Assert.assertThat((Object)jcrContentLocation.getPath().getLastSegment().getName(), (Matcher)Is.is((Object)JcrLexicon.CONTENT));
        Node jcrContent = this.graph.getNodeAt(jcrContentLocation);
        Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.MIMETYPE).getFirstValue()), (Matcher)Is.is((Object)mimeType));
        if (contents != null) {
            Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.DATA).getFirstValue()), (Matcher)Is.is((Object)contents));
        }
    }
}

