/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import org.tmatesoft.svn.core.auth.SVNAuthentication;

public class SVNSSHAuthentication
extends SVNAuthentication {
    private String myPassword;
    private String myPassphrase;
    private File myPrivateKeyFile;
    private int myPortNumber;
    private char[] myPrivateKeyValue;

    public SVNSSHAuthentication(String userName, String password, int portNumber, boolean storageAllowed) {
        super("svn.ssh", userName, storageAllowed);
        this.myPassword = password;
        this.myPortNumber = portNumber;
    }

    public SVNSSHAuthentication(String userName, File keyFile, String passphrase, int portNumber, boolean storageAllowed) {
        super("svn.ssh", userName, storageAllowed);
        this.myPrivateKeyFile = keyFile;
        this.myPassphrase = passphrase;
        this.myPortNumber = portNumber;
    }

    public SVNSSHAuthentication(String userName, char[] privateKey, String passphrase, int portNumber, boolean storageAllowed) {
        super("svn.ssh", userName, storageAllowed);
        this.myPrivateKeyValue = privateKey;
        this.myPassphrase = passphrase;
        this.myPortNumber = portNumber;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public String getPassphrase() {
        return this.myPassphrase;
    }

    public File getPrivateKeyFile() {
        return this.myPrivateKeyFile;
    }

    public char[] getPrivateKey() {
        return this.myPrivateKeyValue;
    }

    public int getPortNumber() {
        return this.myPortNumber;
    }

    public boolean hasPrivateKey() {
        return this.myPrivateKeyFile != null || this.myPrivateKeyValue != null;
    }
}

