/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SeqnoTable;
import org.jgroups.util.Util;

@MBean(description="Implementation of total order protocol using a sequencer")
public class SEQUENCER
extends Protocol {
    private Address local_addr = null;
    private Address coord = null;
    private final Collection<Address> members = new ArrayList<Address>();
    private volatile boolean is_coord = false;
    private AtomicLong seqno = new AtomicLong(0L);
    private final Map<Long, byte[]> forward_table = new TreeMap<Long, byte[]>();
    private final SeqnoTable received_table = new SeqnoTable(0L);
    private long forwarded_msgs = 0L;
    private long bcast_msgs = 0L;
    private long received_forwards = 0L;
    private long received_bcasts = 0L;

    @ManagedAttribute
    public boolean isCoordinator() {
        return this.is_coord;
    }

    public Address getCoordinator() {
        return this.coord;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    @ManagedAttribute
    public long getForwarded() {
        return this.forwarded_msgs;
    }

    @ManagedAttribute
    public long getBroadcast() {
        return this.bcast_msgs;
    }

    @ManagedAttribute
    public long getReceivedForwards() {
        return this.received_forwards;
    }

    @ManagedAttribute
    public long getReceivedBroadcasts() {
        return this.received_bcasts;
    }

    @Override
    @ManagedOperation
    public void resetStats() {
        this.received_bcasts = 0L;
        this.received_forwards = 0L;
        this.bcast_msgs = 0L;
        this.forwarded_msgs = 0L;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("forwarded", new Long(this.forwarded_msgs));
        m.put("broadcast", new Long(this.bcast_msgs));
        m.put("received_forwards", new Long(this.received_forwards));
        m.put("received_bcasts", new Long(this.received_bcasts));
        return m;
    }

    @Override
    @ManagedOperation
    public String printStats() {
        return this.dumpStats().toString();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Address dest;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.NO_TOTAL_ORDER) || (dest = msg.getDest()) != null) break;
                long next_seqno = this.seqno.getAndIncrement();
                if (this.is_coord) {
                    SequencerHeader hdr = new SequencerHeader(2, this.local_addr, next_seqno);
                    msg.putHeader(this.id, hdr);
                    this.broadcast(msg, false);
                } else {
                    this.forwardToCoord(msg, next_seqno);
                }
                return null;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                SequencerHeader hdr;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.NO_TOTAL_ORDER) || (hdr = (SequencerHeader)msg.getHeader(this.id)) == null) break;
                switch (hdr.type) {
                    case 1: {
                        if (!this.is_coord) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(this.local_addr + ": non-coord; dropping FORWARD request from " + msg.getSrc());
                            }
                            return null;
                        }
                        this.broadcast(msg, true);
                        ++this.received_forwards;
                        return null;
                    }
                    case 2: {
                        this.deliver(msg, evt, hdr);
                        ++this.received_bcasts;
                        return null;
                    }
                    case 3: {
                        this.unwrapAndDeliver(msg);
                        ++this.received_bcasts;
                        return null;
                    }
                }
                break;
            }
            case 6: {
                Object retval = this.up_prot.up(evt);
                this.handleViewChange((View)evt.getArg());
                return retval;
            }
            case 9: {
                this.handleSuspect((Address)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        List<Address> mbrs = v.getMembers();
        if (mbrs.isEmpty()) {
            return;
        }
        boolean coord_changed = false;
        SEQUENCER sEQUENCER = this;
        synchronized (sEQUENCER) {
            this.members.clear();
            this.members.addAll(mbrs);
            Address prev_coord = this.coord;
            this.coord = mbrs.iterator().next();
            this.is_coord = this.local_addr != null && this.local_addr.equals(this.coord);
            coord_changed = prev_coord != null && !prev_coord.equals(this.coord);
        }
        if (coord_changed) {
            this.resendMessagesInForwardTable();
        }
        this.received_table.retainAll(mbrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSuspect(Address suspected_mbr) {
        boolean coord_changed = false;
        if (suspected_mbr == null) {
            return;
        }
        SEQUENCER sEQUENCER = this;
        synchronized (sEQUENCER) {
            ArrayList<Address> non_suspected_mbrs = new ArrayList<Address>(this.members);
            non_suspected_mbrs.remove(suspected_mbr);
            if (!non_suspected_mbrs.isEmpty()) {
                Address prev_coord = this.coord;
                this.coord = (Address)non_suspected_mbrs.get(0);
                this.is_coord = this.local_addr != null && this.local_addr.equals(this.coord);
                coord_changed = prev_coord != null && !prev_coord.equals(this.coord);
            }
        }
        if (coord_changed) {
            this.resendMessagesInForwardTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resendMessagesInForwardTable() {
        TreeMap<Long, byte[]> copy;
        Map<Long, byte[]> map = this.forward_table;
        synchronized (map) {
            copy = new TreeMap<Long, byte[]>(this.forward_table);
        }
        for (Map.Entry entry : copy.entrySet()) {
            Long key = (Long)entry.getKey();
            byte[] val = (byte[])entry.getValue();
            Message forward_msg = new Message(this.coord, null, val);
            SequencerHeader hdr = new SequencerHeader(1, this.local_addr, key);
            forward_msg.putHeader(this.id, hdr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("resending msg " + this.local_addr + "::" + key + " to coord (" + this.coord + ")");
            }
            this.down_prot.down(new Event(1, forward_msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToCoord(Message msg, long seqno) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("forwarding msg " + msg + " (seqno " + seqno + ") to coord (" + this.coord + ")");
        }
        try {
            byte[] marshalled_msg = Util.objectToByteBuffer(msg);
            Map<Long, byte[]> map = this.forward_table;
            synchronized (map) {
                this.forward_table.put(seqno, marshalled_msg);
            }
            Message forward_msg = new Message(this.coord, null, marshalled_msg);
            SequencerHeader hdr = new SequencerHeader(1, this.local_addr, seqno);
            forward_msg.putHeader(this.id, hdr);
            this.down_prot.down(new Event(1, forward_msg));
            ++this.forwarded_msgs;
        }
        catch (Exception e) {
            this.log.error("failed marshalling message", e);
        }
    }

    private void broadcast(Message msg, boolean copy) {
        Message bcast_msg = null;
        SequencerHeader hdr = (SequencerHeader)msg.getHeader(this.id);
        if (!copy) {
            bcast_msg = msg;
        } else {
            bcast_msg = new Message(null, this.local_addr, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            SequencerHeader new_hdr = new SequencerHeader(3, hdr.getOriginalSender(), hdr.getSeqno());
            bcast_msg.putHeader(this.id, new_hdr);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("broadcasting msg " + bcast_msg + " (seqno " + hdr.getSeqno() + ")");
        }
        this.down_prot.down(new Event(1, bcast_msg));
        ++this.bcast_msgs;
    }

    private void unwrapAndDeliver(Message msg) {
        try {
            SequencerHeader hdr = (SequencerHeader)msg.getHeader(this.id);
            Message msg_to_deliver = (Message)Util.objectFromByteBuffer(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            long msg_seqno = hdr.getSeqno();
            if (!this.canDeliver(msg_to_deliver.getSrc(), msg_seqno)) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("delivering msg " + msg_to_deliver + " (seqno " + msg_seqno + "), original sender " + msg_to_deliver.getSrc());
            }
            this.up_prot.up(new Event(1, msg_to_deliver));
        }
        catch (Exception e) {
            this.log.error("failure unmarshalling buffer", e);
        }
    }

    private void deliver(Message msg, Event evt, SequencerHeader hdr) {
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender is null, cannot deliver msg " + msg);
            }
            return;
        }
        long msg_seqno = hdr.getSeqno();
        if (!this.canDeliver(sender, msg_seqno)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("delivering msg " + msg + " (seqno " + msg_seqno + "), sender " + sender);
        }
        this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canDeliver(Address sender, long seqno) {
        boolean added;
        if (sender.equals(this.local_addr)) {
            Map<Long, byte[]> map = this.forward_table;
            synchronized (map) {
                this.forward_table.remove(seqno);
            }
        }
        if (!(added = this.received_table.add(sender, seqno)) && this.log.isWarnEnabled()) {
            this.log.warn("seqno (" + sender + "::" + seqno + " has already been received " + "(highest received=" + this.received_table.getHighestReceived(sender) + "); discarding duplicate message");
        }
        return added;
    }

    public static class SequencerHeader
    extends Header {
        private static final byte FORWARD = 1;
        private static final byte BCAST = 2;
        private static final byte WRAPPED_BCAST = 3;
        byte type = (byte)-1;
        ViewId tag = null;

        public SequencerHeader() {
        }

        public SequencerHeader(byte type, Address original_sender, long seqno) {
            this.type = type;
            this.tag = new ViewId(original_sender, seqno);
        }

        public Address getOriginalSender() {
            return this.tag != null ? this.tag.getCreator() : null;
        }

        public long getSeqno() {
            return this.tag != null ? this.tag.getId() : -1L;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.printType());
            if (this.tag != null) {
                sb.append(" (tag=").append(this.tag).append(")");
            }
            return sb.toString();
        }

        private final String printType() {
            switch (this.type) {
                case 1: {
                    return "FORWARD";
                }
                case 2: {
                    return "BCAST";
                }
                case 3: {
                    return "WRAPPED_BCAST";
                }
            }
            return "n/a";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeStreamable(this.tag, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.tag = (ViewId)Util.readStreamable(ViewId.class, in);
        }

        @Override
        public int size() {
            int size = 2;
            if (this.tag != null) {
                size += this.tag.serializedSize();
            }
            return size;
        }
    }
}

