/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueTask;
import org.hibernate.search.backend.impl.jgroups.JGroupsChannelProvider;
import org.hibernate.search.backend.impl.jgroups.MasterSelectorServiceProvider;
import org.hibernate.search.backend.impl.jgroups.MessageSender;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategy;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategyHolder;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;

public class JGroupsBackendQueueProcessor
implements BackendQueueProcessor {
    private static final Log log = LoggerFactory.make();
    private final NodeSelectorStrategy selectionStrategy;
    protected MessageSender messageSender;
    protected String indexName;
    protected DirectoryBasedIndexManager indexManager;
    private Address address;
    private ServiceManager serviceManager;
    private JGroupsBackendQueueTask jgroupsProcessor;
    private LuceneBackendQueueProcessor luceneBackendQueueProcessor;

    public JGroupsBackendQueueProcessor(NodeSelectorStrategy selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    @Override
    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.indexName = indexManager.getIndexName();
        JGroupsBackendQueueProcessor.assertLegacyOptionsNotUsed(props, this.indexName);
        this.indexManager = indexManager;
        this.serviceManager = context.getServiceManager();
        this.messageSender = (MessageSender)this.serviceManager.requestService(JGroupsChannelProvider.class, context);
        NodeSelectorStrategyHolder masterNodeSelector = (NodeSelectorStrategyHolder)this.serviceManager.requestService(MasterSelectorServiceProvider.class, context);
        masterNodeSelector.setNodeSelectorStrategy(this.indexName, this.selectionStrategy);
        this.selectionStrategy.viewAccepted(this.messageSender.getView());
        this.jgroupsProcessor = new JGroupsBackendQueueTask(this, indexManager, masterNodeSelector);
        this.luceneBackendQueueProcessor = new LuceneBackendQueueProcessor();
        this.luceneBackendQueueProcessor.initialize(props, context, indexManager);
    }

    @Override
    public void close() {
        this.serviceManager.releaseService(MasterSelectorServiceProvider.class);
        this.serviceManager.releaseService(JGroupsChannelProvider.class);
        this.luceneBackendQueueProcessor.close();
    }

    MessageSender getMessageSender() {
        return this.messageSender;
    }

    public Address getAddress() {
        if (this.address == null && this.messageSender != null) {
            this.address = this.messageSender.getAddress();
        }
        return this.address;
    }

    @Override
    public void indexMappingChanged() {
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.luceneBackendQueueProcessor.applyWork(workList, monitor);
        } else {
            if (workList == null) {
                throw new IllegalArgumentException("workList should not be null");
            }
            this.jgroupsProcessor.sendLuceneWorkList(workList);
        }
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.luceneBackendQueueProcessor.applyStreamWork(singleOperation, monitor);
        } else {
            this.jgroupsProcessor.sendLuceneWorkList(Collections.singletonList(singleOperation));
        }
    }

    @Override
    public Lock getExclusiveWriteLock() {
        return this.luceneBackendQueueProcessor.getExclusiveWriteLock();
    }

    private static void assertLegacyOptionsNotUsed(Properties props, String indexName) {
        MaskedProperty jgroupsCfg = new MaskedProperty(props, "worker.backend.jgroups");
        if (jgroupsCfg.containsKey("configurationFile") || jgroupsCfg.containsKey("configurationXml") || jgroupsCfg.containsKey("configurationString") || jgroupsCfg.containsKey("clusterName")) {
            throw log.legacyJGroupsConfigurationDefined(indexName);
        }
    }
}

