/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.util.SystemTimeUtils;
import org.apache.poi.util.LittleEndian;

public final class Comment2000Atom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected Comment2000Atom() {
        this._data = new byte[28];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected Comment2000Atom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public int getNumber() {
        return LittleEndian.getInt((byte[])this._data, (int)0);
    }

    public void setNumber(int number) {
        LittleEndian.putInt((byte[])this._data, (int)0, (int)number);
    }

    public Date getDate() {
        return SystemTimeUtils.getDate(this._data, 4);
    }

    public void setDate(Date date) {
        SystemTimeUtils.storeDate(date, this._data, 4);
    }

    public int getXOffset() {
        return LittleEndian.getInt((byte[])this._data, (int)20);
    }

    public void setXOffset(int xOffset) {
        LittleEndian.putInt((byte[])this._data, (int)20, (int)xOffset);
    }

    public int getYOffset() {
        return LittleEndian.getInt((byte[])this._data, (int)24);
    }

    public void setYOffset(int yOffset) {
        LittleEndian.putInt((byte[])this._data, (int)24, (int)yOffset);
    }

    public long getRecordType() {
        return RecordTypes.Comment2000Atom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }
}

