/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;

@Immutable
public class SimpleClusteredVersion
implements IncrementableEntryVersion,
Serializable {
    private final int topologyId;
    final long version;

    public SimpleClusteredVersion(int topologyId, long version) {
        this.version = version;
        this.topologyId = topologyId;
    }

    @Override
    public InequalVersionComparisonResult compareTo(EntryVersion other) {
        if (other instanceof SimpleClusteredVersion) {
            SimpleClusteredVersion otherVersion = (SimpleClusteredVersion)other;
            if (this.topologyId > otherVersion.topologyId) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.topologyId < otherVersion.topologyId) {
                return InequalVersionComparisonResult.BEFORE;
            }
            if (this.version > otherVersion.version) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.version < otherVersion.version) {
                return InequalVersionComparisonResult.BEFORE;
            }
            return InequalVersionComparisonResult.EQUAL;
        }
        throw new IllegalArgumentException("I only know how to deal with SimpleClusteredVersions, not " + other.getClass().getName());
    }

    public String toString() {
        return "SimpleClusteredVersion{topologyId=" + this.topologyId + ", version=" + this.version + '}';
    }
}

