/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.io.InputStream;
import java.io.OutputStream;
import org.jgroups.Message;
import org.jgroups.MessageListener;

class ClassloaderMessageListener
implements MessageListener {
    private final MessageListener delegate;
    private final ClassLoader cl;

    ClassloaderMessageListener(MessageListener delegate, ClassLoader cl) {
        this.delegate = delegate;
        this.cl = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message msg) {
        Thread currentThread = Thread.currentThread();
        ClassLoader previous = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.cl);
        try {
            this.delegate.receive(msg);
        }
        finally {
            currentThread.setContextClassLoader(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream output) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader previous = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.cl);
        try {
            this.delegate.getState(output);
        }
        finally {
            currentThread.setContextClassLoader(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream input) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader previous = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.cl);
        try {
            this.delegate.setState(input);
        }
        finally {
            currentThread.setContextClassLoader(previous);
        }
    }
}

