/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.CoreImmutables;
import org.infinispan.util.TimeService;

public class EntrySetCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final DataContainer container;
    private final InternalEntryFactory entryFactory;
    private final TimeService timeService;

    public EntrySetCommand(DataContainer container, InternalEntryFactory internalEntryFactory, TimeService timeService, Set<Flag> flags) {
        this.setFlags(flags);
        this.container = container;
        this.entryFactory = internalEntryFactory;
        this.timeService = timeService;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEntrySetCommand(ctx, this);
    }

    @Override
    public Set<InternalCacheEntry> perform(InvocationContext ctx) throws Throwable {
        Set<InternalCacheEntry> entries = this.container.entrySet();
        return EntrySetCommand.createFilteredEntrySet(entries, ctx, this.timeService, this.entryFactory);
    }

    public static Set<InternalCacheEntry> createFilteredEntrySet(Set<InternalCacheEntry> entries, InvocationContext ctx, TimeService timeService, InternalEntryFactory entryFactory) {
        if (ctx.getLookedUpEntries().isEmpty()) {
            return new ExpiredFilteredEntrySet(entries, timeService);
        }
        return new FilteredEntrySet(entries, ctx.getLookedUpEntries(), timeService, entryFactory);
    }

    public String toString() {
        return "EntrySetCommand{set=" + this.container.size() + " elements" + '}';
    }

    private static class ExpiredFilteredEntrySet
    extends AbstractSet<InternalCacheEntry> {
        final Set<InternalCacheEntry> entrySet;
        final TimeService timeService;

        public ExpiredFilteredEntrySet(Set<InternalCacheEntry> entrySet, TimeService timeService) {
            this.entrySet = entrySet;
            this.timeService = timeService;
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new Itr();
        }

        @Override
        public int size() {
            int s = this.entrySet.size();
            long currentTimeMillis = 0L;
            for (InternalCacheEntry e : this.entrySet) {
                if (!e.canExpire()) continue;
                if (currentTimeMillis == 0L) {
                    currentTimeMillis = this.timeService.wallClockTime();
                }
                if (!e.isExpired(currentTimeMillis)) continue;
                --s;
            }
            return s;
        }

        @Override
        public boolean add(InternalCacheEntry e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends InternalCacheEntry> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<InternalCacheEntry> {
            private final Iterator<InternalCacheEntry> it;
            private InternalCacheEntry next;

            private Itr() {
                this.it = ExpiredFilteredEntrySet.this.entrySet.iterator();
                this.fetchNext();
            }

            private void fetchNext() {
                long currentTimeMillis = -1L;
                while (this.it.hasNext()) {
                    InternalCacheEntry e = this.it.next();
                    if (e.canExpire()) {
                        if (currentTimeMillis == -1L) {
                            currentTimeMillis = ExpiredFilteredEntrySet.this.timeService.wallClockTime();
                        }
                        if (e.isExpired(currentTimeMillis)) continue;
                        this.next = e;
                        return;
                    }
                    this.next = e;
                    return;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public InternalCacheEntry next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                InternalCacheEntry ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class FilteredEntrySet
    extends AbstractSet<InternalCacheEntry> {
        final Set<InternalCacheEntry> entrySet;
        final Map<Object, CacheEntry> lookedUpEntries;
        final TimeService timeService;
        final InternalEntryFactory entryFactory;

        FilteredEntrySet(Set<InternalCacheEntry> entrySet, Map<Object, CacheEntry> lookedUpEntries, TimeService timeService, InternalEntryFactory entryFactory) {
            this.entrySet = entrySet;
            this.lookedUpEntries = lookedUpEntries;
            this.timeService = timeService;
            this.entryFactory = entryFactory;
        }

        @Override
        public int size() {
            long currentTimeMillis = 0L;
            HashSet<Object> validKeys = new HashSet<Object>();
            for (InternalCacheEntry e : this.entrySet) {
                if (e.canExpire()) {
                    if (currentTimeMillis == 0L) {
                        currentTimeMillis = this.timeService.wallClockTime();
                    }
                    if (e.isExpired(currentTimeMillis)) continue;
                    validKeys.add(e.getKey());
                    continue;
                }
                validKeys.add(e.getKey());
            }
            int size = validKeys.size();
            for (CacheEntry e : this.lookedUpEntries.values()) {
                if (validKeys.contains(e.getKey())) {
                    if (!e.isRemoved()) continue;
                    --size;
                    continue;
                }
                if (e.isRemoved()) continue;
                ++size;
            }
            return Math.max(size, 0);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            CacheEntry ce = this.lookedUpEntries.get(e.getKey());
            if (ce != null) {
                return !ce.isRemoved();
            }
            return this.entrySet.contains(o);
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(InternalCacheEntry e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends InternalCacheEntry> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<InternalCacheEntry> {
            private final Iterator<CacheEntry> it1;
            private final Iterator<InternalCacheEntry> it2;
            private boolean atIt1;
            private InternalCacheEntry next;

            Itr() {
                this.it1 = FilteredEntrySet.this.lookedUpEntries.values().iterator();
                this.it2 = FilteredEntrySet.this.entrySet.iterator();
                this.atIt1 = true;
                this.fetchNext();
            }

            private void fetchNext() {
                boolean found;
                if (this.atIt1) {
                    found = false;
                    while (this.it1.hasNext()) {
                        CacheEntry e = this.it1.next();
                        if (e.isRemoved()) continue;
                        this.next = CoreImmutables.immutableInternalCacheEntry(FilteredEntrySet.this.entryFactory.create(e.getKey(), e.getValue(), e.getMetadata()));
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.atIt1 = false;
                    }
                }
                if (!this.atIt1) {
                    found = false;
                    while (this.it2.hasNext()) {
                        InternalCacheEntry ice = this.it2.next();
                        Object key = ice.getKey();
                        if (FilteredEntrySet.this.lookedUpEntries.containsKey(key)) continue;
                        this.next = ice;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.next = null;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public InternalCacheEntry next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                InternalCacheEntry ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

