/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.jboss.marshalling.util.IdentityIntMap;

public class EmbeddedMetadata
implements Metadata {
    final EntryVersion version;

    private EmbeddedMetadata(EntryVersion version) {
        this.version = version;
    }

    @Override
    public long lifespan() {
        return -1L;
    }

    @Override
    public long maxIdle() {
        return -1L;
    }

    @Override
    public EntryVersion version() {
        return this.version;
    }

    @Override
    public Metadata.Builder builder() {
        return new Builder().version(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedMetadata that = (EmbeddedMetadata)o;
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public String toString() {
        return "EmbeddedMetadata{version=" + this.version + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<EmbeddedMetadata> {
        private static final int IMMORTAL = 0;
        private static final int EXPIRABLE = 1;
        private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

        public Externalizer() {
            this.numbers.put(EmbeddedMetadata.class, 0);
            this.numbers.put(EmbeddedExpirableMetadata.class, 1);
        }

        public Set<Class<? extends EmbeddedMetadata>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{EmbeddedMetadata.class, EmbeddedExpirableMetadata.class});
        }

        public Integer getId() {
            return 98;
        }

        public void writeObject(ObjectOutput output, EmbeddedMetadata object) throws IOException {
            int number = this.numbers.get(object.getClass(), -1);
            output.write(number);
            switch (number) {
                case 1: {
                    output.writeLong(object.lifespan());
                    output.writeLong(object.maxIdle());
                }
            }
            output.writeObject(object.version());
        }

        public EmbeddedMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            switch (number) {
                case 0: {
                    return new EmbeddedMetadata((EntryVersion)input.readObject());
                }
                case 1: {
                    long lifespan = input.readLong();
                    long maxIdle = input.readLong();
                    EntryVersion version = (EntryVersion)input.readObject();
                    return new EmbeddedExpirableMetadata(lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS, version);
                }
            }
            throw new IllegalStateException("Unknown metadata type " + number);
        }
    }

    private static class EmbeddedExpirableMetadata
    extends EmbeddedMetadata {
        private final long lifespan;
        private final long maxIdle;

        private EmbeddedExpirableMetadata(long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EntryVersion version) {
            super(version);
            this.lifespan = lifespanUnit.toMillis(lifespan);
            this.maxIdle = maxIdleUnit.toMillis(maxIdle);
        }

        @Override
        public long lifespan() {
            return this.lifespan;
        }

        @Override
        public long maxIdle() {
            return this.maxIdle;
        }

        @Override
        public Metadata.Builder builder() {
            return new Builder().lifespan(this.lifespan).maxIdle(this.lifespan).version(this.version);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedExpirableMetadata that = (EmbeddedExpirableMetadata)o;
            if (this.lifespan != that.lifespan) {
                return false;
            }
            return this.maxIdle == that.maxIdle;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
            result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
            return result;
        }

        @Override
        public String toString() {
            return "EmbeddedExpirableMetadata{lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", version=" + this.version + '}';
        }
    }

    public static class Builder
    implements Metadata.Builder {
        protected long lifespan = -1L;
        protected TimeUnit lifespanUnit = TimeUnit.MILLISECONDS;
        protected long maxIdle = -1L;
        protected TimeUnit maxIdleUnit = TimeUnit.MILLISECONDS;
        protected EntryVersion version;

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.lifespan = time;
            this.lifespanUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            return this.lifespan(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.maxIdle = time;
            this.maxIdleUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            return this.maxIdle(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.version = version;
            return this;
        }

        @Override
        public Metadata build() {
            if (this.lifespan < 0L && this.maxIdle < 0L) {
                return new EmbeddedMetadata(this.version);
            }
            return new EmbeddedExpirableMetadata(this.lifespan, this.lifespanUnit, this.maxIdle, this.maxIdleUnit, this.version);
        }
    }
}

