/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;

public class TestReadWrite
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testVORBIS.ogg");
    }

    private static long[] copy(OggFile in, OggFile out) throws IOException {
        OggPacketReader r = in.getPacketReader();
        ArrayList<Long> copyCRCs = new ArrayList<Long>();
        OggPacket p = null;
        OggPacket pp = null;
        OggPacketWriter w = null;
        while ((p = r.getNextPacket()) != null) {
            if (w == null) {
                w = out.getPacketWriter(p.getSid());
                copyCRCs.add(p._getParent().getChecksum());
            }
            if (pp != null && pp.getSequenceNumber() != p.getSequenceNumber()) {
                w.flush();
                copyCRCs.add(p._getParent().getChecksum());
            }
            long oldGranule = p.getGranulePosition();
            w.bufferPacket(p);
            w.setGranulePosition(oldGranule);
            pp = p;
        }
        w.close();
        out.close();
        long[] ret = new long[copyCRCs.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Long)copyCRCs.get(i);
        }
        return ret;
    }

    public void testReadWrite() throws IOException {
        OggFile in = new OggFile(this.getTestFile());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile out = new OggFile((OutputStream)baos);
        TestReadWrite.copy(in, out);
        out.close();
    }

    public void testReadWriteContents() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile out = new OggFile((OutputStream)baos);
        TestReadWrite.copy(new OggFile(this.getTestFile()), out);
        InputStream inp = this.getTestFile();
        byte[] original = new byte[4241];
        IOUtils.readFully((InputStream)inp, (byte[])original);
        TestReadWrite.assertEquals((int)-1, (int)inp.read());
        byte[] readwrite = baos.toByteArray();
        TestReadWrite.assertEquals((int)original.length, (int)readwrite.length);
        for (int i = 0; i < original.length; ++i) {
            TestReadWrite.assertEquals((byte)original[i], (byte)readwrite[i]);
        }
    }

    public void testReadWriteRead() throws IOException {
        OggPacket p;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile out = new OggFile((OutputStream)baos);
        long[] crcs = TestReadWrite.copy(new OggFile(this.getTestFile()), out);
        OggFile in = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OggPacketReader r = in.getPacketReader();
        while ((p = r.getNextPacket()) != null) {
            int page = p._getParent().getSequenceNumber();
            TestReadWrite.assertEquals((long)crcs[page], (long)p._getParent().getChecksum());
        }
    }

    public void testPackets() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile out = new OggFile((OutputStream)baos);
        TestReadWrite.copy(new OggFile(this.getTestFile()), out);
        OggFile ogg = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OggPacketReader r = ogg.getPacketReader();
        OggPacket p = r.getNextPacket();
        TestReadWrite.assertEquals((int)30, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)0, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)219, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)1, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)3484, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)1, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)35, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)28, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)30, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)52, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)51, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)69, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)59, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)40, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals((int)38, (int)p.getData().length);
        TestReadWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadWrite.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestReadWrite.assertEquals((int)74691676, (int)p.getSid());
        TestReadWrite.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadWrite.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadWrite.assertEquals(null, (Object)p);
    }
}

