/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumn;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumns;
import org.modeshape.jcr.index.elasticsearch.EsIndexException;
import org.modeshape.jcr.index.elasticsearch.Operations;
import org.modeshape.jcr.index.elasticsearch.SearchResults;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;

public class EsIndex
implements ProvidedIndex {
    private final String name;
    private final String workspace;
    private final EsIndexColumns columns;
    private final Operations operations;
    private final EsClient client;

    public EsIndex(EsClient client, ExecutionContext context, IndexDefinition defn, String workspace) {
        this.client = client;
        this.name = defn.getName();
        this.workspace = workspace;
        this.columns = new EsIndexColumns(context, defn);
        this.operations = new Operations(context.getValueFactories(), this.columns);
        this.createIndex();
    }

    protected EsIndex(EsClient client, EsIndexColumns columns, ExecutionContext context, String name, String workspace) {
        this.client = client;
        this.name = name;
        this.workspace = workspace;
        this.columns = columns;
        this.operations = new Operations(context.getValueFactories(), columns);
        this.createIndex();
    }

    private String name() {
        return this.name.toLowerCase() + "-" + this.workspace;
    }

    private void createIndex() {
        try {
            this.client.createIndex(this.name(), this.workspace, this.columns.mappings(this.workspace));
            this.client.flush(this.name());
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void add(String nodeKey, String propertyName, Object value) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)value, (String)"value");
        EsIndexColumn column = this.columns.column(propertyName);
        assert (column != null) : "Unexpected column for the index " + this.name();
        try {
            EsRequest doc = this.findOrCreateDoc(nodeKey);
            this.putValue(doc, column, value);
            this.client.storeDocument(this.name(), this.workspace, nodeKey, doc);
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void add(String nodeKey, String propertyName, Object[] values) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)values, (String)"values");
        EsIndexColumn column = this.columns.column(propertyName);
        assert (column != null) : "Unexpected column for the index " + this.name();
        try {
            EsRequest doc = this.findOrCreateDoc(nodeKey);
            this.putValues(doc, column, values);
            this.client.storeDocument(this.name(), this.workspace, nodeKey, doc);
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void remove(String nodeKey) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        try {
            this.client.deleteDocument(this.name(), this.workspace, nodeKey);
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void remove(String nodeKey, String propertyName, Object value) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        try {
            EsRequest doc = this.find(nodeKey);
            if (doc == null) {
                return;
            }
            doc.remove(propertyName);
            this.client.storeDocument(this.name(), this.workspace, nodeKey, doc);
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void remove(String nodeKey, String propertyName, Object[] values) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        try {
            EsRequest doc = this.find(nodeKey);
            doc.remove(propertyName);
            this.client.storeDocument(this.name(), this.workspace, nodeKey, doc);
        }
        catch (Exception e) {
            throw new EsIndexException(e);
        }
    }

    private EsRequest find(String nodeKey) throws IOException {
        return this.client.getDocument(this.name(), this.workspace, nodeKey);
    }

    private EsRequest findOrCreateDoc(String nodeKey) throws IOException {
        EsRequest doc = this.client.getDocument(this.name(), this.workspace, nodeKey);
        return doc != null ? doc : new EsRequest();
    }

    private void putValue(EsRequest doc, EsIndexColumn column, Object value) {
        Object columnValue = column.columnValue(value);
        String stringValue = column.stringValue(value);
        doc.put(column.getName(), columnValue);
        doc.put(column.getLowerCaseFieldName(), stringValue.toLowerCase());
        doc.put(column.getUpperCaseFieldName(), stringValue.toUpperCase());
        doc.put(column.getLengthFieldName(), stringValue.length());
    }

    private void putValues(EsRequest doc, EsIndexColumn column, Object[] value) {
        Object[] columnValue = column.columnValues(value);
        int[] ln = new int[columnValue.length];
        Object[] lc = new String[columnValue.length];
        Object[] uc = new String[columnValue.length];
        for (int i = 0; i < columnValue.length; ++i) {
            String stringValue = column.stringValue(columnValue[i]);
            lc[i] = stringValue.toLowerCase();
            uc[i] = stringValue.toUpperCase();
            ln[i] = stringValue.length();
        }
        doc.put(column.getName(), columnValue);
        doc.put(column.getLowerCaseFieldName(), lc);
        doc.put(column.getUpperCaseFieldName(), uc);
        doc.put(column.getLengthFieldName(), (Object)ln);
    }

    public void commit() {
        try {
            this.client.refresh(this.name());
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Filter.Results filter(IndexConstraints constraints) {
        EsRequest query = this.operations.createQuery(constraints.getConstraints(), constraints.getVariables());
        return new SearchResults(this.client, this.name(), this.workspace, query);
    }

    public long estimateCardinality(List<Constraint> constraints, Map<String, Object> variables) {
        EsRequest query = this.operations.createQuery(constraints, variables);
        return new SearchResults(this.client, this.name(), this.workspace, query).getCardinality();
    }

    public long estimateTotalCount() {
        try {
            return this.client.count(this.name(), this.workspace);
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public boolean requiresReindexing() {
        return true;
    }

    public void clearAllData() {
        try {
            this.client.deleteAll(this.name(), this.workspace);
        }
        catch (IOException e) {
            throw new EsIndexException(e);
        }
    }

    public void shutdown(boolean destroyed) {
        if (destroyed) {
            try {
                this.client.deleteIndex(this.name());
            }
            catch (Exception e) {
                throw new EsIndexException(e);
            }
        }
    }
}

