/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeBuilder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.EsValidateQuery;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.LocalIndexProviderTest;
import org.modeshape.jcr.ValidateQuery;
import org.modeshape.jcr.api.JcrTools;

public class EsIndexProviderTest
extends LocalIndexProviderTest {
    private static org.elasticsearch.node.Node esNode;

    @BeforeClass
    public static void setUpClass() {
        FileUtil.delete((String)"target/persistent_repository");
        FileUtil.delete((String)"target/data");
        Settings localSettings = Settings.settingsBuilder().put("http.enabled", true).put("number_of_shards", 1).put("number_of_replicas", 1).put("path.home", "target/data").build();
        esNode = NodeBuilder.nodeBuilder().settings(localSettings).local(false).build().start();
    }

    @AfterClass
    public static void tearDownClass() {
        esNode.close();
        FileUtil.delete((String)"target/data");
    }

    public void beforeEach() throws Exception {
        this.startRepositoryWithConfiguration(this.repositoryConfiguration());
        this.printMessage("Started repository...");
        this.tools = new JcrTools();
    }

    public void afterEach() throws Exception {
        try {
            this.stopRepository();
        }
        finally {
            FileUtil.delete((String)"target/persistent_repository");
        }
    }

    protected boolean startRepositoryAutomatically() {
        return false;
    }

    protected InputStream repositoryConfiguration() {
        return this.resource("config/repo-config1.json");
    }

    protected String providerName() {
        return "elasticsearch";
    }

    protected ValidateQuery.ValidationBuilder validateQuery() {
        return EsValidateQuery.validateQuery().printDetail(this.print);
    }

    @Test
    public void shouldSelectIndexWhenMultipleAndedConstraintsApply() throws Exception {
        this.registerValueIndex("longValues", "nt:unstructured", "Long values index", "*", "value", 3);
        JcrRootNode root = this.session().getRootNode();
        int valuesCount = 5;
        for (int i = 0; i < valuesCount; ++i) {
            String name = String.valueOf(i + 1);
            Node node = root.addNode(name);
            node.setProperty("value", (long)(i + 1));
        }
        this.session.save();
        String sql1 = "SELECT number.[jcr:name] FROM [nt:unstructured] as number WHERE (number.value > 1 AND number.value < 3) OR (number.value > 3 AND number.value < 5)";
        String sql2 = "SELECT number.[jcr:name] FROM [nt:unstructured] as number WHERE number.value <2";
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query(sql1 + " UNION " + sql2);
        this.validateQuery().rowCount(3L).useIndex("longValues").hasNodesAtPaths(new String[]{"/2", "/4", "/1"}).validate((Query)query, (QueryResult)query.execute());
    }

    @Test
    public void shouldUseIndexesAfterRestarting() throws Exception {
    }

    protected void assertStorageLocationUnchangedAfterRestart() throws Exception {
    }
}

