/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch.client;

import java.util.Arrays;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumn;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumns;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;

public class EsClientTest {
    private static final ExecutionContext context = new ExecutionContext();
    private static final EsIndexColumn def1 = new EsIndexColumn(context, "field1", 1);
    private static final EsIndexColumn def2 = new EsIndexColumn(context, "field2", 12);
    private static final EsIndexColumn def3 = new EsIndexColumn(context, "field3", 1);
    private static final EsIndexColumn def4 = new EsIndexColumn(context, "mixinTypes", 7);
    private static final EsIndexColumn def5 = new EsIndexColumn(context, "myfield", 1);
    private static final EsIndexColumns columns = new EsIndexColumns(new EsIndexColumn[]{def1, def2, def3, def4, def5});
    private static Node esNode;
    private final EsClient client = new EsClient("localhost", 9200);
    private static final String INDEX_NAME = "test-index";
    private static final String TYPE_NAME = "test-type";

    @BeforeClass
    public static void setUpClass() {
        FileUtil.delete((String)"target/data");
        try {
            esNode = NodeBuilder.nodeBuilder().local(false).settings(Settings.settingsBuilder().put("path.home", "target/data")).node();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException {
        Thread.currentThread();
        Thread.sleep(1000L);
        esNode.close();
        FileUtil.delete((String)"target/data");
    }

    @Before
    public void setUp() throws Exception {
        this.client.createIndex(INDEX_NAME, TYPE_NAME, columns.mappings(TYPE_NAME));
        this.client.flush(INDEX_NAME);
    }

    @After
    public void tearDown() throws Exception {
        this.client.deleteIndex(INDEX_NAME);
    }

    @Test
    public void testStoreAndGetDocument() throws Exception {
        EsRequest doc = new EsRequest();
        doc.put("field1", (Object)"value1");
        this.client.storeDocument(INDEX_NAME, TYPE_NAME, "1", doc);
        EsRequest doc1 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        Assert.assertEquals((Object)doc.get("field1"), (Object)doc1.get("field1"));
    }

    @Test
    public void testUpdateDocument() throws Exception {
        EsRequest doc = new EsRequest();
        doc.put("field1", (Object)"value1");
        this.client.storeDocument(INDEX_NAME, TYPE_NAME, "1", doc);
        EsRequest doc1 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        doc1.put("field1", (Object)"VALUE1");
        this.client.storeDocument(INDEX_NAME, TYPE_NAME, "1", doc1);
        EsRequest doc2 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        Assert.assertEquals((Object)"VALUE1", (Object)doc2.get("field1"));
    }

    @Test
    public void testStoreAndGetDocumentWithArrays() throws Exception {
        EsRequest doc = new EsRequest();
        doc.put("field1", (Object[])new String[]{"1", "2", "3"});
        this.client.storeDocument(INDEX_NAME, TYPE_NAME, "1", doc);
        EsRequest doc1 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        Assert.assertTrue((boolean)Arrays.equals((Object[])doc.get("field1"), (Object[])doc1.get("field1")));
    }

    @Test
    public void testUpdateDocumentWithArrays() throws Exception {
        EsRequest doc = new EsRequest();
        doc.put("field1", (Object[])new String[]{"1", "2", "3"});
        this.client.storeDocument(INDEX_NAME, TYPE_NAME, "1", doc);
        EsRequest doc1 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        doc1.put("field1", (Object[])new String[]{"1", "2", "3", "4"});
        this.client.storeDocument(INDEX_NAME, TYPE_NAME, "1", doc1);
        EsRequest doc2 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        Assert.assertEquals((long)4L, (long)((Object[])doc2.get("field1")).length);
    }

    @Test
    public void shouldReturnNull() throws Exception {
        EsRequest doc1 = this.client.getDocument(INDEX_NAME, TYPE_NAME, "1");
        Assert.assertTrue((doc1 == null ? 1 : 0) != 0);
    }

    @Test
    public void testCount() throws Exception {
        EsRequest doc = new EsRequest();
        doc.put("field1", (Object)"value1");
        Assert.assertTrue((boolean)this.client.storeDocument(INDEX_NAME, TYPE_NAME, "10", doc));
        Thread.currentThread();
        Thread.sleep(1000L);
        long count = this.client.count(INDEX_NAME, TYPE_NAME);
        Assert.assertEquals((long)1L, (long)count);
    }
}

