/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.elasticsearch.EsIndex;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.index.local.LocalIndexException;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;

public class EsManagedIndexBuilder
extends ManagedIndexBuilder {
    private final EsClient client;

    public static EsManagedIndexBuilder create(EsClient client, ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, String workspaceName, ChangeSetAdapter.NodeTypePredicate matcher) {
        SimpleProblems problems = new SimpleProblems();
        EsManagedIndexBuilder.validate(defn, (Problems)problems);
        if (problems.hasErrors()) {
            throw new LocalIndexException(problems.toString());
        }
        return new EsManagedIndexBuilder(client, context, defn, nodeTypesSupplier, workspaceName, matcher);
    }

    protected static void validate(IndexDefinition defn, Problems problems) {
    }

    protected EsManagedIndexBuilder(EsClient client, ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, String workspaceName, ChangeSetAdapter.NodeTypePredicate matcher) {
        super(context, defn, workspaceName, nodeTypesSupplier, matcher);
        this.client = client;
    }

    protected ProvidedIndex<?> buildMultiValueIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return new EsIndex(this.client, context, defn, workspaceName);
    }

    protected ProvidedIndex<?> buildUniqueValueIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return new EsIndex(this.client, context, defn, workspaceName);
    }

    protected ProvidedIndex<?> buildEnumeratedIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return new EsIndex(this.client, context, defn, workspaceName);
    }

    protected ProvidedIndex<?> buildTextIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return new EsIndex(this.client, context, defn, workspaceName);
    }

    protected ProvidedIndex<?> buildNodeTypeIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return new EsIndex(this.client, context, defn, workspaceName);
    }
}

