/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.infinispan.schematic.document.Document;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.client.EsResponse;
import org.modeshape.jcr.index.elasticsearch.query.MatchAllQuery;

public class EsClient {
    private final String host;
    private final int port;

    public EsClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexExists(String name) throws IOException {
        String url = String.format("http://%s:%d/%s", this.host, this.port, name);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("HEAD");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(String name, String type, EsRequest mappings) throws IOException {
        if (this.indexExists(name)) {
            this.deleteIndex(name);
        }
        String url = String.format("http://%s:%d/%s", this.host, this.port, name);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (mappings != null) {
                mappings.write(connection.getOutputStream());
            }
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIndex(String name) throws IOException {
        String url = String.format("http://%s:%d/%s", this.host, this.port, name);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeDocument(String name, String type, String id, EsRequest doc) throws IOException {
        String url = String.format("http://%s:%d/%s/%s/%s", this.host, this.port, name, type, id);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            doc.write(connection.getOutputStream());
            boolean bl = connection.getResponseCode() == 201;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public EsRequest getDocument(String name, String type, String id) throws IOException {
        String url = String.format("http://%s:%d/%s/%s/%s", this.host, this.port, name, type, id);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            switch (connection.getResponseCode()) {
                case 200: {
                    EsResponse doc = EsResponse.read(connection.getInputStream());
                    EsRequest esRequest = new EsRequest((Document)doc.get("_source"));
                    return esRequest;
                }
                case 404: 
                case 503: {
                    EsRequest esRequest = null;
                    return esRequest;
                }
            }
            throw new IOException(connection.getResponseMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDocument(String name, String type, String id) throws IOException {
        String url = String.format("http://%s:%d/%s/%s/%s", this.host, this.port, name, type, id);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("DELETE");
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(String name, String type) throws IOException {
        String url = String.format("http://%s:%d/%s/%s", this.host, this.port, name, type);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            EsRequest query = new EsRequest();
            query.put("query", new MatchAllQuery().build());
            query.write(connection.getOutputStream());
            if (connection.getResponseCode() != 200) {
                throw new IOException(connection.getResponseMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String name) throws IOException {
        String url = String.format("http://%s:%d/%s/_flush", this.host, this.port, name);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (connection.getResponseCode() != 200) {
                throw new IOException(connection.getResponseMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String name) throws IOException {
        String url = String.format("http://%s:%d/%s/_refresh", this.host, this.port, name);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (connection.getResponseCode() != 200) {
                throw new IOException(connection.getResponseMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsResponse search(String name, String type, EsRequest query) throws IOException {
        String url = String.format("http://%s:%d/%s/%s/_search", this.host, this.port, name, type);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            query.write(connection.getOutputStream());
            if (connection.getResponseCode() != 200) {
                throw new IOException(connection.getResponseMessage());
            }
            EsResponse esResponse = EsResponse.read(connection.getInputStream());
            return esResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(String name, String type) throws IOException {
        String url = String.format("http://%s:%d/%s/%s/_count", this.host, this.port, name, type);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            EsRequest query = new EsRequest();
            query.put("query", new MatchAllQuery().build());
            query.write(connection.getOutputStream());
            if (connection.getResponseCode() != 200) {
                throw new IOException(connection.getResponseMessage());
            }
            long l = ((Integer)EsResponse.read(connection.getInputStream()).get("count")).intValue();
            return l;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

