/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch.query;

import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.query.Query;

public class RangeQuery
extends Query {
    private String field;
    private Object lowBound;
    private Object upperBound;
    private boolean includeLowBound;
    private boolean includeUpperBound;

    public RangeQuery(String field) {
        this.field = field;
    }

    public RangeQuery from(Object value) {
        this.lowBound = value;
        return this;
    }

    public RangeQuery to(Object value) {
        this.upperBound = value;
        return this;
    }

    public RangeQuery gt(Object value) {
        this.lowBound = value;
        this.includeLowBound = false;
        return this;
    }

    public RangeQuery gte(Object value) {
        this.lowBound = value;
        this.includeLowBound = true;
        return this;
    }

    public RangeQuery lt(Object value) {
        this.upperBound = value;
        this.includeUpperBound = false;
        return this;
    }

    public RangeQuery lte(Object value) {
        this.upperBound = value;
        this.includeUpperBound = true;
        return this;
    }

    public RangeQuery includeLower(boolean value) {
        this.includeLowBound = value;
        return this;
    }

    public RangeQuery includeUpper(boolean value) {
        this.includeUpperBound = value;
        return this;
    }

    @Override
    public EsRequest build() {
        EsRequest doc = new EsRequest();
        EsRequest range = new EsRequest();
        EsRequest property = new EsRequest();
        if (this.lowBound != null) {
            property.put(this.includeLowBound ? "gte" : "gt", this.lowBound);
        }
        if (this.upperBound != null) {
            property.put(this.includeUpperBound ? "lte" : "lt", this.upperBound);
        }
        range.put(this.field, property);
        doc.put("range", range);
        return doc;
    }
}

