/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.elasticsearch.EsIndex;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumn;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumns;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.ResultWriter;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueFactories;

public class EsIndexTest {
    private static final ExecutionContext context = new ExecutionContext();
    private static final EsIndexColumn def1 = new EsIndexColumn(context, "field1", 1);
    private static final EsIndexColumn def2 = new EsIndexColumn(context, "field2", 12);
    private static final EsIndexColumn def3 = new EsIndexColumn(context, "field3", 1);
    private static final EsIndexColumn def4 = new EsIndexColumn(context, "mixinTypes", 7);
    private static final EsIndexColumn def5 = new EsIndexColumn(context, "myfield", 1);
    private static Node esNode;
    private static EsClient client;
    private static EsIndex index;
    private static final String NODE_KEY_PREFIX = "12345671234567-";

    @BeforeClass
    public static void setUpClass() throws Exception {
        FileUtil.delete((String)"target/data");
        EsIndexColumns cols = new EsIndexColumns(new EsIndexColumn[]{def1, def2, def3, def4, def5});
        esNode = NodeBuilder.nodeBuilder().local(false).settings(Settings.settingsBuilder().put("path.home", "target/data")).node();
        client = new EsClient("localhost", 9200);
        index = new EsIndex(client, cols, context, "test", "workspace");
        EsIndexTest.initialIndex();
        Thread.currentThread();
        Thread.sleep(1000L);
    }

    @AfterClass
    public static void tearDownClass() {
        index.shutdown(true);
        esNode.close();
        FileUtil.delete((String)"target/data");
    }

    private static void initialIndex() {
        index.add(EsIndexTest.key("key1"), def1.getName(), (Object)"node1 - value1");
        index.add(EsIndexTest.key("key1"), def2.getName(), (Object)1);
        index.add(EsIndexTest.key("key1"), def3.getName(), (Object[])new String[]{"a", "b", "c"});
        index.add(EsIndexTest.key("key2"), def1.getName(), (Object)"node2 - value2");
        index.add(EsIndexTest.key("key2"), def2.getName(), (Object)2);
        index.add(EsIndexTest.key("key2"), def3.getName(), (Object[])new String[]{"d", "e", "f"});
        index.add(EsIndexTest.key("key3"), def1.getName(), (Object)"node3 - value3");
        index.add(EsIndexTest.key("key3"), def2.getName(), (Object)3);
        index.add(EsIndexTest.key("key3"), def3.getName(), (Object[])new String[]{"h", "i", "g"});
        index.add(EsIndexTest.key("key4"), def1.getName(), (Object)"node4 - value4");
        index.add(EsIndexTest.key("key4"), def2.getName(), (Object)4);
        index.add(EsIndexTest.key("key4"), def3.getName(), (Object[])new String[]{"j", "k", "l"});
        index.add(EsIndexTest.key("key5"), def1.getName(), (Object)"node5 - value5");
        index.add(EsIndexTest.key("key5"), def2.getName(), (Object)5);
        index.add(EsIndexTest.key("key5"), def3.getName(), (Object[])new String[]{"m", "n", "o"});
        index.add(EsIndexTest.key("key6"), def1.getName(), (Object)"the quick Brown fox jumps over to the dog in at the gate");
        index.add(EsIndexTest.key("key6"), def2.getName(), (Object)55);
        index.add(EsIndexTest.key("key6"), def3.getName(), (Object[])new String[]{"m", "n", "o"});
        index.add(EsIndexTest.key("key7"), def5.getName(), (Object)"asd-sdf-dfg");
        index.commit();
    }

    @Test
    public void shouldSupportBetweenConstraint() {
        Between c1 = new Between((DynamicOperand)this.propertyValue(def2), (StaticOperand)new Literal((Object)2), (StaticOperand)new Literal((Object)4));
        this.validate((Constraint)c1, "key2", "key3", "key4");
        Between c2 = new Between((DynamicOperand)this.propertyValue(def2), (StaticOperand)new Literal((Object)2), (StaticOperand)new Literal((Object)4), false, false);
        this.validate((Constraint)c2, "key3");
    }

    @Test
    public void shouldSupportComparisonConstraint() {
        Comparison gt = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.GREATER_THAN, (StaticOperand)new Literal((Object)2));
        this.validate((Constraint)gt, "key3", "key4", "key5", "key6");
        Comparison gte = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.GREATER_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)2));
        this.validate((Constraint)gte, "key2", "key3", "key4", "key5", "key6");
        Comparison eq = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)3));
        this.validate((Constraint)eq, "key3");
        Comparison lt = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.LESS_THAN, (StaticOperand)new Literal((Object)2));
        this.validate((Constraint)lt, "key1");
        Comparison lte = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.LESS_THAN_OR_EQUAL_TO, (StaticOperand)new Literal((Object)2));
        this.validate((Constraint)lte, "key1", "key2");
        Comparison ne = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.NOT_EQUAL_TO, (StaticOperand)new Literal((Object)2));
        this.validate((Constraint)ne, "key1", "key3", "key4", "key5", "key6", "key7");
        Comparison like = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.LIKE, (StaticOperand)new Literal((Object)"value3"));
        this.validate((Constraint)like, "key3");
    }

    @Test
    public void shouldSupportSetConstraint() {
        SetCriteria sc = new SetCriteria((DynamicOperand)this.propertyValue(def3), new StaticOperand[]{new Literal((Object)"a")});
        this.validate((Constraint)sc, "key1");
        SetCriteria sc1 = new SetCriteria((DynamicOperand)this.propertyValue(def2), new StaticOperand[]{new Literal((Object)3), new Literal((Object)4)});
        this.validate((Constraint)sc1, "key3", "key4");
    }

    @Test
    public void shouldSupportFullTextSearchConstraint() {
        this.validate((Constraint)this.fullTextSearch("node1 - value1"), "key1");
        this.validate((Constraint)this.fullTextSearch("the quick Brown fox jumps over to the dog in at the gate"), "key6");
        this.validate((Constraint)this.fullTextSearch("the quick Dog"), "key6");
    }

    @Test
    public void shouldSupportPropertyExistanceConstraint() {
        PropertyExistence pe = new PropertyExistence(new SelectorName("test"), def2.getName());
        this.validate((Constraint)pe, "key1", "key2", "key3", "key4", "key5", "key6");
    }

    @Test
    public void testOrConstraint() {
        Comparison eq1 = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)3));
        Comparison eq2 = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)2));
        this.validate((Constraint)new Or((org.modeshape.jcr.query.model.Constraint)eq1, (org.modeshape.jcr.query.model.Constraint)eq2), "key2", "key3");
    }

    @Test
    public void testAndConstraint() {
        Comparison gt = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.GREATER_THAN, (StaticOperand)new Literal((Object)2));
        Comparison lt = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.LESS_THAN, (StaticOperand)new Literal((Object)4));
        this.validate((Constraint)new And((org.modeshape.jcr.query.model.Constraint)gt, (org.modeshape.jcr.query.model.Constraint)lt), "key3");
    }

    @Test
    public void testNotConstraint() {
        Comparison ne = new Comparison((DynamicOperand)this.propertyValue(def2), Operator.NOT_EQUAL_TO, (StaticOperand)new Literal((Object)3));
        this.validate((Constraint)new Not((org.modeshape.jcr.query.model.Constraint)ne), "key3");
    }

    @Test
    public void shouldSupportMultipleValues() {
        SetCriteria sc = new SetCriteria((DynamicOperand)this.propertyValue(def3), (StaticOperand[])new Literal[]{new Literal((Object)"a"), new Literal((Object)"e")});
        this.validate((Constraint)sc, "key1", "key2");
    }

    @Test
    public void shouldSupportLowerCase() {
        LowerCase lowerCase = new LowerCase((DynamicOperand)this.propertyValue(def1));
        Comparison eq = new Comparison((DynamicOperand)lowerCase, Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"value3"));
        this.validate((Constraint)eq, "key3");
    }

    @Test
    public void shouldSupportUpperCase() {
        UpperCase upperCase = new UpperCase((DynamicOperand)this.propertyValue(def1));
        Comparison eq = new Comparison((DynamicOperand)upperCase, Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"VALUE3"));
        this.validate((Constraint)eq, "key3");
    }

    @Test
    public void shouldSupportLength() {
        Length len = new Length(this.propertyValue(def2));
        Comparison eq = new Comparison((DynamicOperand)len, Operator.EQUAL_TO, (StaticOperand)new Literal((Object)1));
        this.validate((Constraint)eq, "key1", "key2", "key3", "key4", "key5");
    }

    @Test
    public void shouldNotTokenizeOnIntrawordDelimeter() {
        SetCriteria sc = new SetCriteria((DynamicOperand)this.propertyValue(def5), new StaticOperand[]{new Literal((Object)"asd-sdf-dfg")});
        this.validate((Constraint)sc, "key7");
    }

    @Test
    public void shouldConvertValuesToCoreTypes() {
        ExecutionContext ctx = new ExecutionContext();
        Name n1 = (Name)ctx.getValueFactories().getNameFactory().create("mix:title");
        Name n2 = (Name)ctx.getValueFactories().getNameFactory().create("mix:titl");
        index.add(EsIndexTest.key("key8"), "mixinTypes", new Object[]{n1});
        index.commit();
        SetCriteria sc = new SetCriteria((DynamicOperand)this.propertyValue(def4), new StaticOperand[]{new Literal((Object)n1), new Literal((Object)n2)});
        this.validate((Constraint)sc, "key8");
    }

    private void validate(Constraint constraint, String ... keys) {
        ResultWriterImpl rw = new ResultWriterImpl();
        Filter.Results results = index.filter(this.constraints(constraint));
        results.getNextBatch((ResultWriter)rw, 100);
        Assert.assertTrue((boolean)this.checkResults(rw.results(), keys));
    }

    private PropertyValue propertyValue(EsIndexColumn column) {
        return new PropertyValue(new SelectorName("test"), column.getName());
    }

    private FullTextSearch fullTextSearch(String query) {
        return new FullTextSearch(new SelectorName("test"), query);
    }

    protected IndexConstraints constraints(final Constraint constraint) {
        return new IndexConstraints(){

            public Collection<Constraint> getConstraints() {
                return Collections.singletonList(constraint);
            }

            public Map<String, Object> getParameters() {
                return Collections.emptyMap();
            }

            public ValueFactories getValueFactories() {
                return context.getValueFactories();
            }

            public Map<String, Object> getVariables() {
                return Collections.emptyMap();
            }

            public boolean hasConstraints() {
                return true;
            }

            public Collection<JoinCondition> getJoinConditions() {
                return Collections.emptyList();
            }
        };
    }

    private boolean checkResults(Collection<NodeKey> res, String ... expected) {
        Assert.assertEquals((long)expected.length, (long)res.size());
        for (NodeKey k : res) {
            for (int i = 0; i < expected.length; ++i) {
                String s = EsIndexTest.key(expected[i]);
                if (!s.equals(k.toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected static String key(String value) {
        return NODE_KEY_PREFIX + value;
    }

    private class ResultWriterImpl
    implements ResultWriter {
        private ArrayList<NodeKey> keys = new ArrayList();

        private ResultWriterImpl() {
        }

        public void add(NodeKey nodeKey, float score) {
            this.keys.add(nodeKey);
        }

        public void add(Iterable<NodeKey> nodeKeys, float score) {
            for (NodeKey k : nodeKeys) {
                this.keys.add(k);
            }
        }

        public void add(Iterator<NodeKey> nodeKeys, float score) {
            while (nodeKeys.hasNext()) {
                this.keys.add(nodeKeys.next());
            }
        }

        public Collection<NodeKey> results() {
            return this.keys;
        }
    }
}

