/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.util.Collection;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactories;

public class EsIndexColumn {
    public static final String LENGTH_PREFIX = "length_";
    public static final String LOWERCASE_PREFIX = "lowercase_";
    public static final String UPPERCASE_PREFIX = "uppercase_";
    private final String name;
    private final PropertyType type;
    private final ValueFactories valueFactories;

    public EsIndexColumn(ExecutionContext context, String name, int type) {
        this.valueFactories = context.getValueFactories();
        this.name = name;
        this.type = PropertyType.valueFor((int)type);
    }

    public String getName() {
        return this.name;
    }

    public String getLengthFieldName() {
        return LENGTH_PREFIX + this.name;
    }

    public String getLowerCaseFieldName() {
        return LOWERCASE_PREFIX + this.name;
    }

    public String getUpperCaseFieldName() {
        return UPPERCASE_PREFIX + this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    protected Object columnValue(Object value) {
        switch (this.type) {
            case PATH: 
            case NAME: 
            case STRING: 
            case REFERENCE: 
            case SIMPLEREFERENCE: 
            case WEAKREFERENCE: 
            case URI: {
                return this.valueFactories.getStringFactory().create(value);
            }
            case DATE: {
                return ((DateTime)value).getMilliseconds();
            }
        }
        return value;
    }

    protected String stringValue(Object value) {
        return (String)this.valueFactories.getStringFactory().create(value);
    }

    protected Object[] columnValues(Object[] value) {
        Object[] res = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            res[i] = this.columnValue(value[i]);
        }
        return res;
    }

    protected Object cast(Object value) {
        switch (this.type) {
            case STRING: {
                return this.valueFactories.getStringFactory().create(value);
            }
            case LONG: {
                return this.valueFactories.getLongFactory().create(value);
            }
            case NAME: {
                return this.valueFactories.getNameFactory().create(value);
            }
            case PATH: {
                return this.valueFactories.getPathFactory().create(value);
            }
            case DATE: {
                return this.valueFactories.getDateFactory().create(value);
            }
            case BOOLEAN: {
                return this.valueFactories.getBooleanFactory().create(value);
            }
            case URI: {
                return this.valueFactories.getUriFactory().create(value);
            }
            case REFERENCE: {
                return this.valueFactories.getReferenceFactory().create(value);
            }
            case SIMPLEREFERENCE: {
                return this.valueFactories.getSimpleReferenceFactory().create(value);
            }
            case WEAKREFERENCE: {
                return this.valueFactories.getWeakReferenceFactory().create(value);
            }
        }
        return value;
    }

    protected Object[] cast(Object[] values) {
        Object[] res = new Object[values.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.cast(values[i]);
        }
        return res;
    }

    protected Object[] cast(Collection values) {
        Object[] res = new Object[values.size()];
        int i = 0;
        for (Object value : values) {
            res[i++] = this.cast(value);
        }
        return res;
    }
}

