/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.client.EsResponse;
import org.modeshape.jcr.index.elasticsearch.query.MatchAllQuery;
import org.modeshape.schematic.document.Document;

public class EsClient {
    private final String host;
    private final int port;

    public EsClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexExists(String name) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpHead head = new HttpHead(String.format("http://%s:%d/%s", this.host, this.port, name));
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)head);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            head.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(String name, String type, EsRequest mappings) throws IOException {
        if (this.indexExists(name)) {
            return true;
        }
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s", this.host, this.port, name));
        try {
            StringEntity requestEntity = new StringEntity(mappings.toString(), ContentType.APPLICATION_JSON);
            method.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            boolean bl = resp.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIndex(String name) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpDelete delete = new HttpDelete(String.format("http://%s:%d/%s", this.host, this.port, name));
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)delete);
            boolean bl = resp.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            delete.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeDocument(String name, String type, String id, EsRequest doc) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s/%s/%s", this.host, this.port, name, type, id));
        try {
            StringEntity requestEntity = new StringEntity(doc.toString(), ContentType.APPLICATION_JSON);
            method.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int statusCode = resp.getStatusLine().getStatusCode();
            boolean bl = statusCode == 201 || statusCode == 200;
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    public EsRequest getDocument(String name, String type, String id) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet method = new HttpGet(String.format("http://%s:%d/%s/%s/%s", this.host, this.port, name, type, id));
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            switch (status) {
                case 200: {
                    EsResponse doc = EsResponse.read(resp.getEntity().getContent());
                    EsRequest esRequest = new EsRequest((Document)doc.get("_source"));
                    return esRequest;
                }
                case 404: 
                case 406: {
                    EsRequest esRequest = null;
                    return esRequest;
                }
            }
            throw new IOException(resp.getStatusLine().getReasonPhrase());
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDocument(String name, String type, String id) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpDelete delete = new HttpDelete(String.format("http://%s:%d/%s/%s/%s", this.host, this.port, name, type, id));
        try {
            boolean bl = client.execute((HttpUriRequest)delete).getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            delete.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(String name, String type) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s/%s", this.host, this.port, name, type));
        try {
            EsRequest query = new EsRequest();
            query.put("query", new MatchAllQuery().build());
            StringEntity requestEntity = new StringEntity(query.toString(), ContentType.APPLICATION_JSON);
            method.setEntity((HttpEntity)requestEntity);
            method.setHeader(" X-HTTP-Method-Override", "DELETE");
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException(resp.getStatusLine().getReasonPhrase());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String name) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s/_flush", this.host, this.port, name));
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException(resp.getStatusLine().getReasonPhrase());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String name) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s/_refresh", this.host, this.port, name));
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException(resp.getStatusLine().getReasonPhrase());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsResponse search(String name, String type, EsRequest query) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s/%s/_search", this.host, this.port, name, type));
        try {
            StringEntity requestEntity = new StringEntity(query.toString(), ContentType.APPLICATION_JSON);
            method.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException(resp.getStatusLine().getReasonPhrase());
            }
            EsResponse esResponse = EsResponse.read(resp.getEntity().getContent());
            return esResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(String name, String type) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(String.format("http://%s:%d/%s/%s/_count", this.host, this.port, name, type));
        try {
            EsRequest query = new EsRequest();
            query.put("query", new MatchAllQuery().build());
            StringEntity requestEntity = new StringEntity(query.toString(), ContentType.APPLICATION_JSON);
            method.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            int status = resp.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException(resp.getStatusLine().getReasonPhrase());
            }
            long l = ((Integer)EsResponse.read(resp.getEntity().getContent()).get("count")).intValue();
            return l;
        }
        finally {
            method.releaseConnection();
        }
    }
}

