/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumn;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.value.PropertyType;

public class EsIndexColumns {
    private final Map<String, EsIndexColumn> columns = new HashMap<String, EsIndexColumn>();

    public EsIndexColumns(EsIndexColumn ... cols) {
        for (int i = 0; i < cols.length; ++i) {
            this.columns.put(cols[i].getName(), cols[i]);
        }
    }

    public EsIndexColumns(ExecutionContext context, IndexDefinition defn) {
        EsIndexColumn[] cols = new EsIndexColumn[defn.size()];
        for (int i = 0; i < cols.length; ++i) {
            IndexColumnDefinition idef = defn.getColumnDefinition(i);
            this.columns.put(idef.getPropertyName(), new EsIndexColumn(context, idef.getPropertyName(), idef.getColumnType()));
        }
    }

    public EsIndexColumn column(String name) {
        return this.columns.get(this.noprefix(name, "length_", "lowercase_", "uppercase_"));
    }

    private String noprefix(String name, String ... prefix) {
        for (int i = 0; i < prefix.length; ++i) {
            if (!name.startsWith(prefix[i])) continue;
            name = name.replaceAll(prefix[i], "");
        }
        return name;
    }

    public Collection<EsIndexColumn> columns() {
        return this.columns.values();
    }

    public EsRequest mappings(String type) {
        EsRequest mappings = new EsRequest();
        EsRequest mappingsValue = new EsRequest();
        EsRequest mtype = new EsRequest();
        EsRequest properties = new EsRequest();
        for (EsIndexColumn col : this.columns()) {
            properties.put(col.getName(), this.fieldMapping(col.getType()));
            properties.put(col.getLowerCaseFieldName(), this.fieldMapping(PropertyType.STRING));
            properties.put(col.getUpperCaseFieldName(), this.fieldMapping(PropertyType.STRING));
            properties.put(col.getLengthFieldName(), this.fieldMapping(PropertyType.LONG));
        }
        mtype.put("properties", properties);
        mappingsValue.put(type, mtype);
        mappings.put("mappings", mappingsValue);
        return mappings;
    }

    private EsRequest fieldMapping(PropertyType type) {
        EsRequest mappings = new EsRequest();
        switch (type) {
            case BINARY: {
                mappings.put("type", "binary");
                break;
            }
            case BOOLEAN: {
                mappings.put("type", "boolean");
                break;
            }
            case DATE: {
                mappings.put("type", "long");
                break;
            }
            case LONG: 
            case DECIMAL: {
                mappings.put("type", "long");
                break;
            }
            case DOUBLE: {
                mappings.put("type", "double");
                break;
            }
            default: {
                mappings.put("type", "string");
                mappings.put("analyzer", "whitespace");
            }
        }
        return mappings;
    }
}

