/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.DnaExecutionContext;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicNamespace;

public class DnaExecutionContextTest {
    private static final NamespaceRegistry.Namespace DNA = new BasicNamespace("dna", "http://www.jboss.org/dna/1.0");
    private static final NamespaceRegistry.Namespace DNAINT = new BasicNamespace("dnaint", "http://www.jboss.org/dna/int/1.0");
    private static final NamespaceRegistry.Namespace MODE = new BasicNamespace("mode", "http://www.modeshape.org/1.0");
    private static final NamespaceRegistry.Namespace MODEINT = new BasicNamespace("modeint", "http://www.modeshape.org/internal/1.0");
    private ExecutionContext context;
    private DnaExecutionContext dnaContext;
    private NamespaceRegistry registry;
    private NamespaceRegistry dnaRegistry;
    private ValueFactory<String> stringFactory;
    private NameFactory nameFactory;
    private PathFactory pathFactory;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.dnaContext = new DnaExecutionContext(this.context);
        this.registry = this.context.getNamespaceRegistry();
        this.dnaRegistry = this.dnaContext.getNamespaceRegistry();
        this.stringFactory = this.dnaContext.getValueFactories().getStringFactory();
        this.nameFactory = this.dnaContext.getValueFactories().getNameFactory();
        this.pathFactory = this.dnaContext.getValueFactories().getPathFactory();
    }

    protected Name name(String name) {
        return (Name)this.nameFactory.create(name);
    }

    protected Path path(String path) {
        return (Path)this.pathFactory.create(path);
    }

    @Test
    public void shouldNotFindDnaNamespacesInOriginalExecutionContext() {
        Assert.assertThat((Object)this.registry.isRegisteredNamespaceUri(DNA.getNamespaceUri()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.registry.getPrefixForNamespaceUri(DNA.getPrefix(), false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.registry.isRegisteredNamespaceUri(DNAINT.getNamespaceUri()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.registry.getPrefixForNamespaceUri(DNAINT.getPrefix(), false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindDnaNamespacesInDnaExecutionContext() {
        Assert.assertThat((Object)this.dnaRegistry.isRegisteredNamespaceUri(DNA.getNamespaceUri()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.dnaRegistry.isRegisteredNamespaceUri(DNAINT.getNamespaceUri()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.dnaRegistry.getNamespaces().contains(DNA), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.dnaRegistry.getNamespaces().contains(DNAINT), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAliasDnaNamespaceToModeShapeNamespace() {
        Assert.assertThat((Object)this.dnaRegistry.getPrefixForNamespaceUri(DNA.getNamespaceUri(), false), (Matcher)Is.is((Object)MODE.getPrefix()));
        Assert.assertThat((Object)this.dnaRegistry.getNamespaceForPrefix(DNA.getPrefix()), (Matcher)Is.is((Object)MODE.getNamespaceUri()));
        Assert.assertThat((Object)this.dnaRegistry.getPrefixForNamespaceUri(DNAINT.getNamespaceUri(), false), (Matcher)Is.is((Object)"modeint"));
        Assert.assertThat((Object)this.dnaRegistry.getNamespaceForPrefix(DNAINT.getPrefix()), (Matcher)Is.is((Object)MODEINT.getNamespaceUri()));
    }

    @Test
    public void shouldConstructNameWithModeShapeNamespaceFromStringContainingDnaPrefix() {
        Name name = this.name("dna:something");
        Assert.assertThat((Object)name.getNamespaceUri(), (Matcher)Is.is((Object)MODE.getNamespaceUri()));
        Assert.assertThat((Object)this.stringFactory.create(name), (Matcher)Is.is((Object)"mode:something"));
    }

    @Test
    public void shouldConstructNameWithModeShapeNamespaceFromStringContainingModeShapePrefix() {
        Name name = this.name("mode:something");
        Assert.assertThat((Object)name.getNamespaceUri(), (Matcher)Is.is((Object)MODE.getNamespaceUri()));
        Assert.assertThat((Object)this.stringFactory.create(name), (Matcher)Is.is((Object)"mode:something"));
    }

    @Test
    public void shouldConstructNameWithModeShapeNamespaceFromStringContainingDnaUri() {
        Name name = this.name("{" + DNA.getNamespaceUri() + "}something");
        Assert.assertThat((Object)name.getNamespaceUri(), (Matcher)Is.is((Object)MODE.getNamespaceUri()));
        Assert.assertThat((Object)this.stringFactory.create(name), (Matcher)Is.is((Object)"mode:something"));
    }

    @Test
    public void shouldConstructNameWithModeShapeNamespaceFromStringContainingModeShapeUri() {
        Name name = this.name("{" + MODE.getNamespaceUri() + "}something");
        Assert.assertThat((Object)name.getNamespaceUri(), (Matcher)Is.is((Object)MODE.getNamespaceUri()));
        Assert.assertThat((Object)this.stringFactory.create(name), (Matcher)Is.is((Object)"mode:something"));
    }

    @Test
    public void shouldConstructRelativePathWithModeShapeNamespaceFromStringContainingDnaPrefix() {
        Path path = this.path("dna:something/dna:else");
        Assert.assertThat((Object)this.stringFactory.create(path), (Matcher)Is.is((Object)"mode:something/mode:else"));
    }

    @Test
    public void shouldConstructRelativePathWithModeShapeNamespaceFromStringContainingModeShapePrefix() {
        Path path = this.path("mode:something/mode:else");
        Assert.assertThat((Object)this.stringFactory.create(path), (Matcher)Is.is((Object)"mode:something/mode:else"));
    }

    @Test
    public void shouldConstructAbsolutePathWithModeShapeNamespaceFromStringContainingDnaPrefix() {
        Path path = this.path("/dna:something/dna:else");
        Assert.assertThat((Object)this.stringFactory.create(path), (Matcher)Is.is((Object)"/mode:something/mode:else"));
    }

    @Test
    public void shouldConstructAbsolutePathWithModeShapeNamespaceFromStringContainingModeShapePrefix() {
        Path path = this.path("/mode:something/mode:else");
        Assert.assertThat((Object)this.stringFactory.create(path), (Matcher)Is.is((Object)"/mode:something/mode:else"));
    }
}

