/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Results;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.federation.FederatedRepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;

public abstract class AbstractFederatedRepositorySourceIntegrationTest {
    private static final Stopwatch FEDERATED_TIMER = new Stopwatch();
    private static final Stopwatch SOURCE_TIMER = new Stopwatch();
    protected FederatedRepositorySource source;
    private String sourceName;
    private String repositoryName;
    private String configurationSourceName;
    private String configurationWorkspaceName;
    private InMemoryRepositorySource configRepositorySource;
    private RepositoryConnection configRepositoryConnection;
    protected ExecutionContext context;
    private Map<String, InMemoryRepositorySource> sources;
    protected Graph federated;
    private RepositoryContext repositoryContext;
    @MockitoAnnotations.Mock
    private RepositoryConnectionFactory connectionFactory;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.configurationSourceName = "configuration";
        this.configurationWorkspaceName = "configSpace";
        this.repositoryName = "Test Repository";
        this.configRepositorySource = new InMemoryRepositorySource();
        this.configRepositorySource.setName("Configuration Repository");
        this.configRepositorySource.setDefaultWorkspaceName(this.configurationWorkspaceName);
        this.repositoryContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return AbstractFederatedRepositorySourceIntegrationTest.this.context;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return AbstractFederatedRepositorySourceIntegrationTest.this.connectionFactory;
            }

            public Subgraph getConfiguration(int depth) {
                Graph result = Graph.create((RepositorySource)AbstractFederatedRepositorySourceIntegrationTest.this.configRepositorySource, (ExecutionContext)AbstractFederatedRepositorySourceIntegrationTest.this.context);
                result.useWorkspace(AbstractFederatedRepositorySourceIntegrationTest.this.configurationWorkspaceName);
                return (Subgraph)result.getSubgraphOfDepth(depth).at("/a/b/Test Repository");
            }
        };
        this.configRepositorySource.initialize(this.repositoryContext);
        Graph config = Graph.create((RepositorySource)this.configRepositorySource, (ExecutionContext)this.context);
        config.create("/a").and();
        config.create("/a/b").and();
        config.create("/a/b/Test Repository").and();
        config.create("/a/b/Test Repository/mode:workspaces").and();
        this.source = new FederatedRepositorySource();
        this.source.setName(this.repositoryName);
        this.sourceName = "federated source";
        this.source.setName(this.sourceName);
        this.source.initialize(this.repositoryContext);
        this.sources = new HashMap<String, InMemoryRepositorySource>();
        this.configRepositoryConnection = this.configRepositorySource.getConnection();
        Mockito.stub((Object)this.connectionFactory.createConnection(this.configurationSourceName)).toReturn((Object)this.configRepositoryConnection);
        Mockito.stub((Object)this.connectionFactory.createConnection(this.sourceName)).toAnswer((Answer)new Answer<RepositoryConnection>(){

            public RepositoryConnection answer(InvocationOnMock invocation) throws Throwable {
                return AbstractFederatedRepositorySourceIntegrationTest.this.source.getConnection();
            }
        });
        this.federated = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context);
    }

    @AfterClass
    public static void afterAll() {
        System.out.println("Results for federated reads:  " + FEDERATED_TIMER.getSimpleStatistics());
        System.out.println("Results for source reads:     " + FEDERATED_TIMER.getSimpleStatistics());
    }

    protected void addProjection(String federatedWorkspace, String projectionName, String sourceName, String workspaceName, String ... projectionRules) {
        CheckArg.isNotNull((Object)federatedWorkspace, (String)"federatedWorkspace");
        CheckArg.isNotNull((Object)projectionName, (String)"projectionName");
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotEmpty((Object[])projectionRules, (String)"projectionRules");
        String configPath = this.repositoryContext.getConfiguration(1).getLocation().getPath().getString(this.context.getNamespaceRegistry());
        Assert.assertThat((Object)configPath.endsWith("/"), (Matcher)Is.is((Object)false));
        String wsPath = configPath + "/mode:workspaces/" + federatedWorkspace;
        String projectionPath = wsPath + "/mode:projections/" + projectionName;
        Graph config = Graph.create((RepositorySource)this.configRepositorySource, (ExecutionContext)this.context);
        config.useWorkspace(this.configurationWorkspaceName);
        config.create(wsPath).ifAbsent().and();
        config.create(wsPath + "/mode:projections").ifAbsent().and();
        config.createAt(projectionPath).with(ModeShapeLexicon.PROJECTION_RULES, (Object[])projectionRules).with(ModeShapeLexicon.SOURCE_NAME, new Object[]{sourceName}).with(ModeShapeLexicon.WORKSPACE_NAME, new Object[]{workspaceName}).and();
        this.graphFor(sourceName, workspaceName);
    }

    protected Graph graphFor(String sourceName, String workspaceName) {
        Graph sourceGraph;
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        InMemoryRepositorySource source = this.sources.get(sourceName);
        if (source == null) {
            source = new InMemoryRepositorySource();
            source.setName(sourceName);
            this.sources.put(sourceName, source);
            final InMemoryRepositorySource newSource = source;
            Mockito.stub((Object)this.connectionFactory.createConnection(sourceName)).toAnswer((Answer)new Answer<RepositoryConnection>(){

                public RepositoryConnection answer(InvocationOnMock invocation) throws Throwable {
                    return newSource.getConnection();
                }
            });
            source.initialize(this.repositoryContext);
        }
        if ((sourceGraph = Graph.create((String)sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context)).getWorkspaces().contains(workspaceName)) {
            sourceGraph.useWorkspace(workspaceName);
        } else {
            sourceGraph.createWorkspace().named(workspaceName);
        }
        return sourceGraph;
    }

    protected void assertNoNode(String pathInFederated, String pathInSource, String sourceName, String workspaceName) {
        try {
            FEDERATED_TIMER.start();
            this.federated.getNodeAt(pathInFederated);
            FEDERATED_TIMER.stop();
            Assert.fail((String)("Did not expect to find federated node \"" + pathInFederated + "\""));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            SOURCE_TIMER.start();
            this.graphFor(sourceName, workspaceName).getNodeAt(pathInSource);
            SOURCE_TIMER.stop();
            Assert.fail((String)("Did not expect to find source node \"" + pathInSource + "\" in workspace \"" + workspaceName + "\" of source \"" + sourceName + "\""));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    protected void assertSameNode(String pathInFederated, String pathInSource, String sourceName, String workspaceName, String ... extraChildren) {
        FEDERATED_TIMER.start();
        Node fedNode = this.federated.getNodeAt(pathInFederated);
        FEDERATED_TIMER.stop();
        SOURCE_TIMER.start();
        Node sourceNode = this.graphFor(sourceName, workspaceName).getNodeAt(pathInSource);
        SOURCE_TIMER.stop();
        Path fedPath = fedNode.getLocation().getPath();
        Path sourcePath = sourceNode.getLocation().getPath();
        if (!fedPath.isRoot() && !sourcePath.isRoot()) {
            Assert.assertThat((Object)fedNode.getLocation().getPath().getLastSegment().getName(), (Matcher)Is.is((Object)sourceNode.getLocation().getPath().getLastSegment().getName()));
        }
        UUID fedUuid = fedNode.getLocation().getUuid();
        UUID sourceUuid = sourceNode.getLocation().getUuid();
        Assert.assertThat((Object)fedUuid, (Matcher)Is.is((Object)sourceUuid));
        ArrayList<Path.Segment> fedChildren = new ArrayList<Path.Segment>();
        ArrayList<Path.Segment> sourceChildren = new ArrayList<Path.Segment>();
        for (Location child : fedNode.getChildren()) {
            fedChildren.add(child.getPath().getLastSegment());
        }
        for (Location child : sourceNode.getChildren()) {
            sourceChildren.add(child.getPath().getLastSegment());
        }
        for (String extraChild : extraChildren) {
            sourceChildren.add(this.context.getValueFactories().getPathFactory().createSegment(extraChild));
        }
        Assert.assertThat(fedChildren, (Matcher)Is.is(sourceChildren));
        Map fedProps = fedNode.getPropertiesByName();
        Map sourceProps = sourceNode.getPropertiesByName();
        Assert.assertThat((Object)fedProps, (Matcher)Is.is((Object)sourceProps));
        FEDERATED_TIMER.start();
        List children = (List)this.federated.getChildren().of(pathInFederated);
        FEDERATED_TIMER.stop();
        fedChildren.clear();
        for (Location child : children) {
            fedChildren.add(child.getPath().getLastSegment());
        }
        Assert.assertThat(fedChildren, (Matcher)Is.is(sourceChildren));
        FEDERATED_TIMER.start();
        fedProps = (Map)this.federated.getPropertiesByName().on(pathInFederated);
        FEDERATED_TIMER.stop();
        Assert.assertThat((Object)fedProps, (Matcher)Is.is((Object)sourceProps));
        for (Property sourceProp : sourceProps.values()) {
            FEDERATED_TIMER.start();
            Property fedProp = (Property)this.federated.getProperty(sourceProp.getName()).on(pathInFederated);
            FEDERATED_TIMER.stop();
            Assert.assertThat((Object)fedProp, (Matcher)Is.is((Object)sourceProp));
        }
        FEDERATED_TIMER.start();
        Subgraph fedSubgraph = (Subgraph)this.federated.getSubgraphOfDepth(2).at(pathInFederated);
        FEDERATED_TIMER.stop();
        SOURCE_TIMER.start();
        Subgraph sourceSubgraph = (Subgraph)this.graphFor(sourceName, workspaceName).getSubgraphOfDepth(2).at(pathInSource);
        SOURCE_TIMER.stop();
        if (extraChildren.length == 0) {
            AbstractConnectorTest.assertEquivalentSubgraphs(fedSubgraph, sourceSubgraph, true, false);
        }
    }

    protected void assertReadUsingBatch(String ... pathsInFederated) {
        Graph.Batch batch = this.federated.batch();
        for (String pathInFederated : pathsInFederated) {
            batch.read(pathInFederated).and();
        }
        Results results = batch.execute();
        for (String pathInFederated : pathsInFederated) {
            Assert.assertThat((Object)results.getNode(pathInFederated), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }
}

