/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.progress.VerificationMode;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRepositoryConnection;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.Request;

public class FederatedRepositoryConnectionTest {
    private FederatedRepositoryConnection connection;
    @MockitoAnnotations.Mock
    private FederatedRepository repository;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.connection = new FederatedRepositoryConnection(this.repository, null);
    }

    @Test
    public void shouldHaveRepository() {
        Assert.assertThat((Object)this.connection.getRepository(), (Matcher)Is.is((Object)this.repository));
    }

    @Test
    public void shouldHaveNoXaResource() {
        Assert.assertThat((Object)this.connection.getXAResource(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldGetDefaultCachePolicyFromRepository() {
        CachePolicy cachePolicy = (CachePolicy)Mockito.mock(CachePolicy.class);
        Mockito.stub((Object)this.repository.getDefaultCachePolicy()).toReturn((Object)cachePolicy);
        Assert.assertThat((Object)this.connection.getDefaultCachePolicy(), (Matcher)Is.is((Object)cachePolicy));
        ((FederatedRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).getDefaultCachePolicy();
    }

    @Test
    public void shouldGetSourceNameFromRepository() {
        String name = "Something";
        Mockito.stub((Object)this.repository.getSourceName()).toReturn((Object)name);
        Assert.assertThat((Object)this.connection.getSourceName(), (Matcher)Is.is((Object)name));
        ((FederatedRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).getSourceName();
    }

    @Test
    public void shouldProcessNonCompositeRequestSynchronously() {
        Request request = (Request)Mockito.mock(Request.class);
        Assert.assertThat((Object)this.connection.shouldProcessSynchronously(request), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProcessCompositeRequestWithOneRequestSynchronously() {
        CompositeRequest request = (CompositeRequest)Mockito.mock(CompositeRequest.class);
        Mockito.stub((Object)request.size()).toReturn((Object)1);
        Assert.assertThat((Object)this.connection.shouldProcessSynchronously((Request)request), (Matcher)Is.is((Object)true));
    }

    @Ignore
    @Test
    public void shouldProcessCompositeRequestWithMultipleRequestsAsynchronously() {
        CompositeRequest request = (CompositeRequest)Mockito.mock(CompositeRequest.class);
        Mockito.stub((Object)request.size()).toReturn((Object)2);
        Assert.assertThat((Object)this.connection.shouldProcessSynchronously((Request)request), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowCloseToBeCalledRepeatedly() {
        for (int i = 0; i != 10; ++i) {
            this.connection.close();
        }
    }
}

