/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedWorkspace;
import org.modeshape.graph.request.InvalidWorkspaceException;

public class FederatedRepositoryTest {
    private String name;
    private FederatedRepository repository;
    private CachePolicy defaultCachePolicy;
    private ExecutorService executor;
    @MockitoAnnotations.Mock
    private FederatedWorkspace workspace1;
    @MockitoAnnotations.Mock
    private FederatedWorkspace workspace2;
    @MockitoAnnotations.Mock
    private RepositoryConnectionFactory connectionFactory;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.name = "Repository";
        this.executor = Executors.newSingleThreadExecutor();
        Mockito.stub((Object)this.workspace1.getName()).toReturn((Object)"workspace1");
        Mockito.stub((Object)this.workspace2.getName()).toReturn((Object)"workspace2");
        ArrayList<FederatedWorkspace> configs = new ArrayList<FederatedWorkspace>();
        configs.add(this.workspace1);
        configs.add(this.workspace2);
        this.repository = new FederatedRepository(this.name, this.connectionFactory, configs, this.defaultCachePolicy, this.executor);
    }

    @Test
    public void shouldHaveNameUponCreation() {
        Assert.assertThat((Object)this.repository.getSourceName(), (Matcher)Is.is((Object)this.name));
    }

    @Test
    public void shouldFindExistingWorkspaces() {
        Assert.assertThat((Object)this.repository.getWorkspace("workspace1"), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.repository.getWorkspace("workspace2"), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace2)));
    }

    @Test
    public void shouldFindDefaultWorkspaceIfThereIsOne() {
        Assert.assertThat((Object)this.repository.getWorkspace(null), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
    }

    @Test(expected=InvalidWorkspaceException.class)
    public void shouldNotFindWorkspaceThatDoesNotExist() {
        this.repository.getWorkspace("non-existant");
    }
}

