/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.federation.FederatedWorkspace;
import org.modeshape.graph.connector.federation.Projection;

public class FederatedWorkspaceTest {
    private FederatedWorkspace workspace;
    private ExecutionContext context;
    private CachePolicy cachePolicy;
    private String sourceName;
    private String workspaceName;
    private List<Projection> projections;
    @MockitoAnnotations.Mock
    private RepositoryContext repositoryContext;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.sourceName = "federated";
        this.workspaceName = "my workspace";
        this.context = new ExecutionContext();
        Mockito.stub((Object)this.repositoryContext.getExecutionContext()).toReturn((Object)this.context);
        this.projections = new ArrayList<Projection>();
        this.projections.add(new Projection("source1", "workspace1", false, this.rule("/a => /a1")));
        this.projections.add(new Projection("source2", "workspace2", false, this.rule("/a => /a2", "/b => /b")));
        this.projections.add(new Projection("source2", "workspace4", false, this.rule("/x => /y")));
        this.projections.add(new Projection("source3", "workspace3", false, this.rule("/c/d/e => /c1")));
        this.workspace = new FederatedWorkspace(this.repositoryContext, this.sourceName, this.workspaceName, this.projections, this.cachePolicy);
    }

    protected Projection.Rule[] rule(String ... rule) {
        Projection.Rule[] rules = new Projection.Rule[rule.length];
        for (int i = 0; i != rule.length; ++i) {
            rules[i] = Projection.fromString((String)rule[i], (ExecutionContext)this.context);
        }
        return rules;
    }

    @Test
    public void shouldHaveSameRepositoryContextPassedIntoConstructor() {
        Assert.assertThat((Object)this.workspace.getRepositoryContext(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.repositoryContext)));
    }

    @Test
    public void shouldHaveSameSourceNamePassedIntoConstructor() {
        Assert.assertThat((Object)this.workspace.getSourceName(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.sourceName)));
    }

    @Test
    public void shouldHaveSameWorkspaceNamePassedIntoConstructor() {
        Assert.assertThat((Object)this.workspace.getName(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspaceName)));
    }

    @Test
    public void shouldHaveSameCachePolicyPassedIntoContructor() {
        Assert.assertThat((Object)this.workspace.getCachePolicy(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.cachePolicy)));
    }

    @Test
    public void shouldHaveSameProjectionsPassedIntoConstructor() {
        Assert.assertThat((Object)this.workspace.getProjections(), (Matcher)Is.is(this.projections));
    }

    @Test
    public void shouldHaveCorrectMappingOfProjectionsBySource() {
        Assert.assertThat(this.workspace.getProjectionsBySourceName().get("source1"), (Matcher)Is.is(this.projections.subList(0, 1)));
        Assert.assertThat(this.workspace.getProjectionsBySourceName().get("source2"), (Matcher)Is.is(this.projections.subList(1, 3)));
        Assert.assertThat(this.workspace.getProjectionsBySourceName().get("source3"), (Matcher)Is.is(this.projections.subList(3, 4)));
    }

    @Test
    public void shouldHaveProblemsContainer() {
        Assert.assertThat((Object)this.workspace.getProblems(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCorrectlyDetermineContainmentBySourceAndWorkspaceName() {
        Assert.assertThat((Object)this.workspace.contains("source1", "workspace1"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.workspace.contains("source2", "workspace2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.workspace.contains("source2", "workspace4"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.workspace.contains("source3", "workspace3"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCorrectlyDetermineNonContainmentOfCaseSensitiveSourceNotInProjections() {
        Assert.assertThat((Object)this.workspace.contains("source x", "workspace3"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.workspace.contains("Source1", "workspace3"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.workspace.contains("", "workspace3"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCorrectlyDetermineNonContainmentOfCaseSensitiveWorkspaceNotInProjections() {
        Assert.assertThat((Object)this.workspace.contains("source1", "Workspace1"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.workspace.contains("source1", "workspace 1"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.workspace.contains("source1", "no workspace"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderWorkspacesEqualIfSameSourceNameAndSameWorkspaceNameAndSameProjections() {
        RepositoryContext otherReposContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.stub((Object)otherReposContext.getExecutionContext()).toReturn((Object)this.context);
        CachePolicy otherPolicy = (CachePolicy)Mockito.mock(CachePolicy.class);
        FederatedWorkspace other = new FederatedWorkspace(otherReposContext, this.sourceName, this.workspaceName, this.projections, otherPolicy);
        Assert.assertThat((Object)this.workspace.equals((Object)other), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderWorkspacesNotEqualIfDifferentSourceName() {
        RepositoryContext otherReposContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.stub((Object)otherReposContext.getExecutionContext()).toReturn((Object)this.context);
        CachePolicy otherPolicy = (CachePolicy)Mockito.mock(CachePolicy.class);
        FederatedWorkspace other = new FederatedWorkspace(otherReposContext, "diff", this.workspaceName, this.projections, otherPolicy);
        Assert.assertThat((Object)this.workspace.equals((Object)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderWorkspacesNotEqualIfDifferentWorkspaceName() {
        RepositoryContext otherReposContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.stub((Object)otherReposContext.getExecutionContext()).toReturn((Object)this.context);
        CachePolicy otherPolicy = (CachePolicy)Mockito.mock(CachePolicy.class);
        FederatedWorkspace other = new FederatedWorkspace(otherReposContext, this.sourceName, "diff", this.projections, otherPolicy);
        Assert.assertThat((Object)this.workspace.equals((Object)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderWorkspacesNotEqualIfDifferentProjections() {
        RepositoryContext otherReposContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.stub((Object)otherReposContext.getExecutionContext()).toReturn((Object)this.context);
        CachePolicy otherPolicy = (CachePolicy)Mockito.mock(CachePolicy.class);
        FederatedWorkspace other = new FederatedWorkspace(otherReposContext, this.sourceName, this.workspaceName, this.projections.subList(0, 3), otherPolicy);
        Assert.assertThat((Object)this.workspace.equals((Object)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldDetermineProjection() {
    }
}

