/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.MockRepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRequest;
import org.modeshape.graph.connector.federation.FederatedWorkspace;
import org.modeshape.graph.connector.federation.ForkRequestProcessor;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProxyNode;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;

public class ForkRequestProcessorTest {
    private ForkRequestProcessor processor;
    private ExecutionContext context;
    private DateTime now;
    private String sourceName;
    private String workspaceName;
    private String sourceNameA;
    private String sourceNameB;
    private String sourceNameC;
    private String workspaceNameA;
    private String workspaceNameB;
    private String workspaceNameC;
    private String nonExistantWorkspaceName;
    private LinkedList<FederatedRequest> federatedRequests;
    private ExecutorService executor;
    @MockitoAnnotations.Mock
    private FederatedWorkspace workspace;
    @MockitoAnnotations.Mock
    private FederatedRepository repository;
    @MockitoAnnotations.Mock
    private RepositoryConnectionFactory connectionFactory;
    private Projection projectionA;
    private Projection projectionB;
    private MockRepositoryConnection connectionForSourceA;
    private MockRepositoryConnection connectionForSourceB;
    private MockRepositoryConnection connectionForSourceC;
    private Map<Name, Property> properties;
    private List<ProjectedNode> children;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.executor = Executors.newSingleThreadExecutor();
        this.sourceName = "MySource";
        this.workspaceName = "MyWorkspace";
        this.sourceNameA = "SourceA";
        this.sourceNameB = "SourceB";
        this.sourceNameC = "SourceC";
        this.workspaceNameA = "WorkspaceA";
        this.workspaceNameB = "WorkspaceB";
        this.workspaceNameC = "WorkspaceC";
        this.nonExistantWorkspaceName = "Non-Existant Workspace";
        this.context = new ExecutionContext();
        this.now = this.context.getValueFactories().getDateFactory().create();
        this.federatedRequests = new LinkedList();
        this.children = new ArrayList<ProjectedNode>();
        this.properties = new HashMap<Name, Property>();
        this.connectionForSourceA = new MockRepositoryConnection(this.sourceNameA);
        this.connectionForSourceB = new MockRepositoryConnection(this.sourceNameB);
        this.connectionForSourceC = new MockRepositoryConnection(this.sourceNameC);
        Mockito.stub((Object)this.connectionFactory.createConnection(this.sourceNameA)).toReturn((Object)this.connectionForSourceA);
        Mockito.stub((Object)this.connectionFactory.createConnection(this.sourceNameB)).toReturn((Object)this.connectionForSourceB);
        Mockito.stub((Object)this.connectionFactory.createConnection(this.sourceNameC)).toReturn((Object)this.connectionForSourceC);
        Mockito.stub((Object)this.repository.getSourceName()).toReturn((Object)this.sourceName);
        Mockito.stub((Object)this.repository.getWorkspace(this.workspaceName)).toReturn((Object)this.workspace);
        Mockito.stub((Object)this.repository.getExecutor()).toReturn((Object)this.executor);
        Mockito.stub((Object)this.repository.getConnectionFactory()).toReturn((Object)this.connectionFactory);
        Mockito.stub((Object)this.repository.getWorkspace(this.nonExistantWorkspaceName)).toThrow((Throwable)new InvalidWorkspaceException());
        Mockito.stub((Object)this.workspace.getName()).toReturn((Object)this.workspaceName);
        this.projectionA = new Projection(this.sourceNameA, this.workspaceNameA, false, this.rules("/a => /"));
        this.projectionB = new Projection(this.sourceNameB, this.workspaceNameB, false, this.rules("/b => /"));
        this.processor = new ForkRequestProcessor(this.repository, this.context, this.now, this.federatedRequests);
    }

    protected Projection.Rule[] rules(String ... rule) {
        Projection.Rule[] rules = new Projection.Rule[rule.length];
        for (int i = 0; i != rule.length; ++i) {
            rules[i] = Projection.fromString((String)rule[i], (ExecutionContext)this.context);
        }
        return rules;
    }

    public Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    public Path.Segment segment(String segment) {
        return this.context.getValueFactories().getPathFactory().createSegment(segment);
    }

    public Location location(String path) {
        return Location.create((Path)this.path(path));
    }

    public void addProperty(String name, Object ... values) {
        Property property = this.context.getPropertyFactory().create(this.name(name), values);
        this.properties.put(property.getName(), property);
    }

    public void addChild(Location parent, String childName) {
        Path path = this.context.getValueFactories().getPathFactory().create(parent.getPath(), new Path.Segment[]{this.segment(childName)});
        Map properties = Collections.emptyMap();
        List grandChildren = Collections.emptyList();
        PlaceholderNode child = new PlaceholderNode(Location.create((Path)path), properties, grandChildren);
        this.children.add((ProjectedNode)child);
    }

    @Test
    public void shouldReturnImmediatelyFromAwaitIfNoChannelsAreMade() throws Exception {
        this.processor.await();
    }

    @Test
    public void shouldReturnFromAwaitAfterChannelsAreCompleted() throws Exception {
        ReadNodeRequest requestA = new ReadNodeRequest(this.location("/a/some"), this.workspaceNameA);
        ReadNodeRequest requestB = new ReadNodeRequest(this.location("/b/some"), this.workspaceNameB);
        ReadNodeRequest requestC = new ReadNodeRequest(this.location("/c/some"), this.workspaceNameC);
        this.processor.submit((Request)requestA, this.sourceNameA);
        this.processor.submit((Request)requestB, this.sourceNameB);
        this.processor.submit((Request)requestC, this.sourceNameC);
        this.processor.close();
        this.processor.await();
    }

    @Test
    public void shouldReturnReadableLocation() {
        Location location = this.location("/mode:something/jcr:else");
        String result = this.processor.readable(this.location("/mode:something/jcr:else"));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)location.getString(this.context.getNamespaceRegistry())));
    }

    @Test
    public void shouldFindFederatedWorkspaceByName() {
        ReadNodeRequest request = new ReadNodeRequest(this.location("/some"), this.workspace.getName());
        FederatedWorkspace workspace = this.processor.getWorkspace((Request)request, request.inWorkspace());
        Assert.assertThat((Object)workspace, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace)));
    }

    @Test
    public void shouldRecordErrorOnRequestIfFederatedWorkspaceCouldNotBeFoundByName() {
        ReadNodeRequest request = new ReadNodeRequest(this.location("/some"), this.nonExistantWorkspaceName);
        FederatedWorkspace workspace = this.processor.getWorkspace((Request)request, request.inWorkspace());
        Assert.assertThat((Object)workspace, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)request.hasError(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)request.getError(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InvalidWorkspaceException.class)));
    }

    @Test
    public void shouldSubmitFederatedRequestToQueueIfFederatedRequestHasNoIncompleteRequests() {
        FederatedRequest request = (FederatedRequest)Mockito.mock(FederatedRequest.class);
        Mockito.stub((Object)request.hasIncompleteRequests()).toReturn((Object)false);
        this.processor.submit(request);
        Assert.assertThat((Object)this.federatedRequests.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.federatedRequests.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)request)));
    }

    @Test
    public void shouldSubmitToSourcesTheSingleRequestInFederatedRequestAndAddFederatedRequestToQueue() throws Exception {
        ReadNodeRequest original = new ReadNodeRequest(this.location("/a/some"), this.workspace.getName());
        FederatedRequest request = new FederatedRequest((Request)original);
        ReadNodeRequest sourceRequest = new ReadNodeRequest(this.location("/some"), this.workspaceNameA);
        request.add((Request)sourceRequest, false, false, this.projectionA);
        Assert.assertThat((Object)request.getFirstProjectedRequest().getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectionA)));
        Assert.assertThat((Object)request.getFirstProjectedRequest().hasNext(), (Matcher)Is.is((Object)false));
        this.processor.submit(request);
        Assert.assertThat((Object)this.federatedRequests.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.federatedRequests.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)request)));
        this.processor.close();
        this.processor.await();
        Assert.assertThat((Object)this.connectionForSourceA.getProcessedRequests().contains(sourceRequest), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSubmitToSourcesTheMultipleRequestsInFederatedRequestAndAddFederatedRequestToQueue() throws Exception {
        ReadNodeRequest original = new ReadNodeRequest(this.location("/some"), this.workspace.getName());
        FederatedRequest request = new FederatedRequest((Request)original);
        ReadNodeRequest sourceRequestA = new ReadNodeRequest(this.location("/a/some/other"), this.workspaceNameA);
        request.add((Request)sourceRequestA, false, false, this.projectionA);
        Assert.assertThat((Object)request.getFirstProjectedRequest().getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectionA)));
        ReadNodeRequest sourceRequestB = new ReadNodeRequest(this.location("/b/some/other"), this.workspaceNameB);
        request.add((Request)sourceRequestB, false, false, this.projectionB);
        Assert.assertThat((Object)request.getFirstProjectedRequest().next().getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectionB)));
        Assert.assertThat((Object)request.getFirstProjectedRequest().next().hasNext(), (Matcher)Is.is((Object)false));
        this.processor.submit(request);
        Assert.assertThat((Object)this.federatedRequests.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.federatedRequests.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)request)));
        this.processor.close();
        this.processor.await();
        Assert.assertThat((Object)this.connectionForSourceA.getProcessedRequests().contains(sourceRequestA), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.connectionForSourceB.getProcessedRequests().contains(sourceRequestB), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.connectionForSourceC.getProcessedRequests().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotForkReadNodeRequestIfWorkspaceNameIsInvalid() {
        Location locationInFed = this.location("/a/b");
        Mockito.stub((Object)this.workspace.project(this.context, locationInFed, false)).toReturn(null);
        ReadNodeRequest request = new ReadNodeRequest(locationInFed, this.nonExistantWorkspaceName);
        this.processor.process(request);
        Assert.assertThat((Object)request.hasError(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)request.getError(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InvalidWorkspaceException.class)));
    }

    @Test
    public void shouldNotForkReadNodeRequestIfThereIsNoProjection() {
        Location locationInFed = this.location("/a/b");
        Mockito.stub((Object)this.workspace.project(this.context, locationInFed, false)).toReturn(null);
        ReadNodeRequest request = new ReadNodeRequest(locationInFed, this.workspaceName);
        this.processor.process(request);
        Assert.assertThat((Object)request.hasError(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)request.getError(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(PathNotFoundException.class)));
    }

    @Test
    public void shouldSubmitSingleSourceRequestWhenProcessingSingleReadNodeRequest() throws Exception {
        Location locationInFed = this.location("/a/x/y");
        Location locationInSource = this.location("/x/y");
        ProxyNode projectedNode = new ProxyNode(this.projectionA, locationInSource, locationInFed, false);
        Mockito.stub((Object)this.workspace.project(this.context, locationInFed, false)).toReturn((Object)projectedNode);
        ReadNodeRequest request = new ReadNodeRequest(locationInFed, this.workspaceName);
        this.processor.process(request);
        Assert.assertThat((Object)request.hasError(), (Matcher)Is.is((Object)false));
        FederatedRequest fedRequest = this.federatedRequests.poll();
        ReadNodeRequest projectedRequest = (ReadNodeRequest)fedRequest.getFirstProjectedRequest().getRequest();
        Assert.assertThat((Object)projectedRequest.at(), (Matcher)Is.is((Object)locationInSource));
        Assert.assertThat((Object)fedRequest.getFirstProjectedRequest().hasNext(), (Matcher)Is.is((Object)false));
        this.processor.close();
        this.processor.await();
        ReadNodeRequest sourceRequest = (ReadNodeRequest)this.connectionForSourceA.getProcessedRequests().poll();
        Assert.assertThat((Object)sourceRequest.at().getPath(), (Matcher)Is.is((Object)locationInSource.getPath()));
        Assert.assertThat((Object)this.connectionForSourceB.getProcessedRequests().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.connectionForSourceC.getProcessedRequests().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotSubmitPlaceholderNodesWhenProcessingReadNodeRequest() throws Exception {
        Location locationInFed = this.location("/a/x/y");
        Location locationInSource = this.location("/a/x/y");
        this.addProperty("propA", "valueA");
        this.addProperty("propB", "valueB");
        this.addChild(locationInSource, "child1");
        this.addChild(locationInSource, "child2");
        PlaceholderNode projectedNode = new PlaceholderNode(locationInSource, this.properties, this.children);
        Mockito.stub((Object)this.workspace.project(this.context, locationInFed, false)).toReturn((Object)projectedNode);
        ReadNodeRequest request = new ReadNodeRequest(locationInFed, this.workspaceName);
        this.processor.process(request);
        Assert.assertThat((Object)request.hasError(), (Matcher)Is.is((Object)false));
        FederatedRequest fedRequest = this.federatedRequests.poll();
        ReadNodeRequest projectedRequest = (ReadNodeRequest)fedRequest.getFirstProjectedRequest().getRequest();
        Assert.assertThat((Object)projectedRequest.at(), (Matcher)Is.is((Object)locationInFed));
        ArrayList<Location> expectedChildren = new ArrayList<Location>();
        for (ProjectedNode child : this.children) {
            expectedChildren.add(child.location());
        }
        Assert.assertThat((Object)projectedRequest.getChildren(), (Matcher)Is.is(expectedChildren));
        Assert.assertThat((Object)projectedRequest.getPropertiesByName(), (Matcher)Is.is(this.properties));
        Assert.assertThat((Object)fedRequest.getFirstProjectedRequest().hasNext(), (Matcher)Is.is((Object)false));
        this.processor.close();
        this.processor.await();
        Assert.assertThat((Object)this.connectionForSourceA.getProcessedRequests().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.connectionForSourceB.getProcessedRequests().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.connectionForSourceC.getProcessedRequests().isEmpty(), (Matcher)Is.is((Object)true));
    }
}

