/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

public class ProjectionTest {
    private ExecutionContext context;
    private String sourceName;
    private String workspaceName;
    private Projection.Rule[] rules;
    private Projection projection;
    private PathFactory pathFactory;
    private boolean readOnly;
    @MockitoAnnotations.Mock
    private Projection.Rule mockRule1;
    @MockitoAnnotations.Mock
    private Projection.Rule mockRule2;
    @MockitoAnnotations.Mock
    private Projection.Rule mockRule3;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.sourceName = "Valid name";
        this.workspaceName = "Valid workspace";
        this.readOnly = false;
        this.rules = new Projection.Rule[]{this.mockRule1, this.mockRule2, this.mockRule3};
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test
    public void shouldCreateInstanceWithValidNameAndValidRules() {
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
        Assert.assertThat((Object)this.projection.getSourceName(), (Matcher)Is.is((Object)this.sourceName));
        Assert.assertThat((Object)this.projection.getWorkspaceName(), (Matcher)Is.is((Object)this.workspaceName));
        Assert.assertThat((Object)this.projection.getRules().size(), (Matcher)Is.is((Object)this.rules.length));
        Assert.assertThat((Object)this.projection.getRules(), (Matcher)JUnitMatchers.hasItems((Object[])new Projection.Rule[]{this.mockRule1, this.mockRule2, this.mockRule3}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithNullNameAndValidRules() {
        this.sourceName = null;
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithNullWorkspaceNameAndValidSourceNameAndRules() {
        this.sourceName = null;
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithEmptyNameAndValidRules() {
        this.sourceName = "";
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithBlankNameAndValidRules() {
        this.sourceName = "   \t ";
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidNameAndNullRules() {
        this.rules = null;
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidNameAndEmptyRules() {
        this.rules = new Projection.Rule[0];
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, this.rules);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidNameAndRulesArrayContainingAllNulls() {
        this.projection = new Projection(this.sourceName, null, this.readOnly, new Projection.Rule[]{null, null});
    }

    @Test
    public void shouldCreateInstanceWithValidNameAndRulesAndShouldPruneNullRuleReferences() {
        this.projection = new Projection(this.sourceName, this.workspaceName, this.readOnly, new Projection.Rule[]{this.mockRule1, null, this.mockRule3});
        Assert.assertThat((Object)this.projection.getRules().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.projection.getRules(), (Matcher)JUnitMatchers.hasItems((Object[])new Projection.Rule[]{this.mockRule1, this.mockRule3}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToGetPathsInSourceGivenValidPathAndNullPathFactory() {
        Path pathInRepository = (Path)this.pathFactory.create("/a/b/c");
        this.projection.getPathsInSource(pathInRepository, null);
    }

    @Test
    public void shouldGetNoPathsInSourceGivenNullPathInRepository() {
        Set pathsInSource = this.projection.getPathsInSource(null, this.pathFactory);
        Assert.assertThat((Object)pathsInSource.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetNoPathsInSourceGivenPathInRepositoryAndNoApplicableRules() {
        Path pathInRepository = (Path)this.pathFactory.create("/a/b/c");
        Mockito.stub((Object)this.mockRule1.getPathInSource(pathInRepository, this.pathFactory)).toReturn(null);
        Mockito.stub((Object)this.mockRule2.getPathInSource(pathInRepository, this.pathFactory)).toReturn(null);
        Mockito.stub((Object)this.mockRule3.getPathInSource(pathInRepository, this.pathFactory)).toReturn(null);
        Set pathsInSource = this.projection.getPathsInSource(pathInRepository, this.pathFactory);
        Assert.assertThat((Object)pathsInSource.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetPathInSourceGivenPathInRepositoryAndOneApplicableRules() {
        Path pathInRepository = (Path)this.pathFactory.create("/a/b/c");
        Path pathInSource = (Path)this.pathFactory.create("/d/e/f");
        Mockito.stub((Object)this.mockRule1.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource);
        Mockito.stub((Object)this.mockRule2.getPathInSource(pathInRepository, this.pathFactory)).toReturn(null);
        Mockito.stub((Object)this.mockRule3.getPathInSource(pathInRepository, this.pathFactory)).toReturn(null);
        Set pathsInSource = this.projection.getPathsInSource(pathInRepository, this.pathFactory);
        Assert.assertThat((Object)pathsInSource, (Matcher)JUnitMatchers.hasItems((Object[])new Path[]{pathInSource}));
    }

    @Test
    public void shouldGetPathsInSourceGivenPathInRepositoryAndMultipleApplicableRules() {
        Path pathInRepository = (Path)this.pathFactory.create("/a/b/c");
        Path pathInSource1 = (Path)this.pathFactory.create("/d/e/f");
        Path pathInSource2 = (Path)this.pathFactory.create("/d/e/g");
        Path pathInSource3 = (Path)this.pathFactory.create("/d/e/h");
        Mockito.stub((Object)this.mockRule1.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource1);
        Mockito.stub((Object)this.mockRule2.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource2);
        Mockito.stub((Object)this.mockRule3.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource3);
        Set pathsInSource = this.projection.getPathsInSource(pathInRepository, this.pathFactory);
        Assert.assertThat((Object)pathsInSource, (Matcher)JUnitMatchers.hasItems((Object[])new Path[]{pathInSource1, pathInSource2, pathInSource3}));
    }

    @Test
    public void shouldGetPathsInSourceGivenPathInRepositoryAndMultipleApplicableRulesReturningDuplicatePathsInSource() {
        Path pathInRepository = (Path)this.pathFactory.create("/a/b/c");
        Path pathInSource1 = (Path)this.pathFactory.create("/d/e/f");
        Path pathInSource23 = (Path)this.pathFactory.create("/d/e/g");
        Mockito.stub((Object)this.mockRule1.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource1);
        Mockito.stub((Object)this.mockRule2.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource23);
        Mockito.stub((Object)this.mockRule3.getPathInSource(pathInRepository, this.pathFactory)).toReturn((Object)pathInSource23);
        Set pathsInSource = this.projection.getPathsInSource(pathInRepository, this.pathFactory);
        Assert.assertThat((Object)pathsInSource, (Matcher)JUnitMatchers.hasItems((Object[])new Path[]{pathInSource1, pathInSource23}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToGetPathsInRepositoryGivenValidPathAndNullPathFactory() {
        Path pathInSource = (Path)this.pathFactory.create("/a/b/c");
        this.projection.getPathsInRepository(pathInSource, null);
    }

    @Test
    public void shouldGetNoPathsInRepositoryGivenNullPathInSource() {
        Set pathsInRepository = this.projection.getPathsInRepository(null, this.pathFactory);
        Assert.assertThat((Object)pathsInRepository.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetNoPathsInRepositoryGivenPathInSourceAndNoApplicableRules() {
        Path pathInSource = (Path)this.pathFactory.create("/d/e/f");
        Mockito.stub((Object)this.mockRule1.getPathInRepository(pathInSource, this.pathFactory)).toReturn(null);
        Mockito.stub((Object)this.mockRule2.getPathInRepository(pathInSource, this.pathFactory)).toReturn(null);
        Mockito.stub((Object)this.mockRule3.getPathInRepository(pathInSource, this.pathFactory)).toReturn(null);
        Set pathsInRepository = this.projection.getPathsInRepository(pathInSource, this.pathFactory);
        Assert.assertThat((Object)pathsInRepository.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetPathInRepositoryGivenPathInSourceAndOneApplicableRules() {
        Path pathInRepository = (Path)this.pathFactory.create("/a/b/c");
        Path pathInSource = (Path)this.pathFactory.create("/d/e/f");
        Mockito.stub((Object)this.mockRule1.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository);
        Mockito.stub((Object)this.mockRule2.getPathInRepository(pathInSource, this.pathFactory)).toReturn(null);
        Mockito.stub((Object)this.mockRule3.getPathInRepository(pathInSource, this.pathFactory)).toReturn(null);
        Set pathsInRepository = this.projection.getPathsInRepository(pathInSource, this.pathFactory);
        Assert.assertThat((Object)pathsInRepository, (Matcher)JUnitMatchers.hasItems((Object[])new Path[]{pathInRepository}));
    }

    @Test
    public void shouldGetPathsInRepositoryGivenPathInSourceAndMultipleApplicableRules() {
        Path pathInSource = (Path)this.pathFactory.create("/a/b/c");
        Path pathInRepository1 = (Path)this.pathFactory.create("/d/e/f");
        Path pathInRepository2 = (Path)this.pathFactory.create("/d/e/g");
        Path pathInRepository3 = (Path)this.pathFactory.create("/d/e/h");
        Mockito.stub((Object)this.mockRule1.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository1);
        Mockito.stub((Object)this.mockRule2.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository2);
        Mockito.stub((Object)this.mockRule3.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository3);
        Set pathsInRepository = this.projection.getPathsInRepository(pathInSource, this.pathFactory);
        Assert.assertThat((Object)pathsInRepository, (Matcher)JUnitMatchers.hasItems((Object[])new Path[]{pathInRepository1, pathInRepository2, pathInRepository3}));
    }

    @Test
    public void shouldGetPathsInRepositoryGivenPathInSourceAndMultipleApplicableRulesReturningDuplicatePathsInRepository() {
        Path pathInSource = (Path)this.pathFactory.create("/a/b/c");
        Path pathInRepository1 = (Path)this.pathFactory.create("/d/e/f");
        Path pathInRepository23 = (Path)this.pathFactory.create("/d/e/g");
        Mockito.stub((Object)this.mockRule1.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository1);
        Mockito.stub((Object)this.mockRule2.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository23);
        Mockito.stub((Object)this.mockRule3.getPathInRepository(pathInSource, this.pathFactory)).toReturn((Object)pathInRepository23);
        Set pathsInRepository = this.projection.getPathsInRepository(pathInSource, this.pathFactory);
        Assert.assertThat((Object)pathsInRepository, (Matcher)JUnitMatchers.hasItems((Object[])new Path[]{pathInRepository1, pathInRepository23}));
    }

    @Test
    public void shouldParsePathRuleFromDefinitionWithNonRootRepositoryPathAndNonRootSourcePath() {
        Projection.PathRule rule = Projection.parsePathRule((String)"/a => /b", (ExecutionContext)this.context);
        Assert.assertThat((Object)rule, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Projection.PathRule.class)));
        Projection.PathRule pathRule = rule;
        Assert.assertThat((Object)pathRule.getPathInRepository(), (Matcher)Is.is((Object)this.pathFactory.create("/a")));
        Assert.assertThat((Object)pathRule.getPathInSource(), (Matcher)Is.is((Object)this.pathFactory.create("/b")));
    }

    @Test
    public void shouldParsePathRuleFromDefinitionWithRootRepositoryPathAndNonRootSourcePath() {
        Projection.PathRule rule = Projection.parsePathRule((String)"/ => /b", (ExecutionContext)this.context);
        Assert.assertThat((Object)rule, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Projection.PathRule.class)));
        Projection.PathRule pathRule = rule;
        Assert.assertThat((Object)pathRule.getPathInRepository(), (Matcher)Is.is((Object)this.pathFactory.createRootPath()));
        Assert.assertThat((Object)pathRule.getPathInSource(), (Matcher)Is.is((Object)this.pathFactory.create("/b")));
    }

    @Test
    public void shouldParsePathRuleFromDefinitionWithNonRootRepositoryPathAndRootSourcePath() {
        Projection.PathRule rule = Projection.parsePathRule((String)"/a => /", (ExecutionContext)this.context);
        Assert.assertThat((Object)rule, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Projection.PathRule.class)));
        Projection.PathRule pathRule = rule;
        Assert.assertThat((Object)pathRule.getPathInRepository(), (Matcher)Is.is((Object)this.pathFactory.create("/a")));
        Assert.assertThat((Object)pathRule.getPathInSource(), (Matcher)Is.is((Object)this.pathFactory.createRootPath()));
    }

    @Test
    public void shouldParsePathRuleFromDefinitionWithRootRepositoryPathAndRootSourcePath() {
        Projection.PathRule rule = Projection.parsePathRule((String)"/ => /", (ExecutionContext)this.context);
        Assert.assertThat((Object)rule, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Projection.PathRule.class)));
        Projection.PathRule pathRule = rule;
        Assert.assertThat((Object)pathRule.getPathInRepository(), (Matcher)Is.is((Object)this.pathFactory.createRootPath()));
        Assert.assertThat((Object)pathRule.getPathInSource(), (Matcher)Is.is((Object)this.pathFactory.createRootPath()));
    }

    @Test
    public void shouldNotParsePathRuleFromDefinitionWithRootRepositoryPathAndNoSourcePath() {
        Assert.assertThat((Object)Projection.parsePathRule((String)"/", (ExecutionContext)this.context), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotParsePathRuleFromDefinitionWithNonRootRepositoryPathAndNoSourcePath() {
        Assert.assertThat((Object)Projection.parsePathRule((String)"a/", (ExecutionContext)this.context), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }
}

