/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.property.AbstractValueComparatorsTest;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.ValueComparators;
import org.modeshape.graph.property.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameValueComparatorTest
extends AbstractValueComparatorsTest<Name> {
    private static final ValueFactory<Name> FACTORY;
    private static final Name NAME1;
    private static final Name NAME2;
    private static final Name NAME3;
    private static final Name NAME4;
    private static final Name NAME5;
    private static final Name NAME6;

    public NameValueComparatorTest() {
        super(ValueComparators.NAME_COMPARATOR, NAME1, NAME2, NAME3, NAME4, NAME5, NAME6);
    }

    @Test
    public void shouldConsiderNamesWithSameNamespaceUriAndLocalPartToBeComparable() {
        System.out.println(NAME2);
        System.out.println(NAME4);
        Assert.assertThat((Object)this.comparator.compare(NAME2, NAME4), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldBeCaseSensitive() {
        Assert.assertThat((Object)this.comparator.compare(NAME2, NAME4), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.comparator.compare(NAME1, NAME5), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)this.comparator.compare(NAME6, NAME5), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }

    static {
        NAMESPACE_REGISTRY.register("dna", "http://www.modeshape.org/namespaces/Test");
        NAMESPACE_REGISTRY.register("acme", "http://www.acme.com/");
        NAMESPACE_REGISTRY.register("dna-b", "http://www.modeshape.org/namespaces/Test/b");
        NAMESPACE_REGISTRY.register("dna-c", "http://www.modeshape.org/namespaces/TEST");
        FACTORY = VALUE_FACTORIES.getNameFactory();
        NAME1 = (Name)FACTORY.create("dna:alpha");
        NAME2 = (Name)FACTORY.create("dna:beta");
        NAME3 = (Name)FACTORY.create("acme:beta");
        NAME4 = (Name)FACTORY.create("dna:beta");
        NAME5 = (Name)FACTORY.create("dna:ALPHA");
        NAME6 = (Name)FACTORY.create("dna-c:ALPHA");
    }
}

