/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;

public abstract class AbstractPathTest {
    protected Path path;

    @Before
    public void beforeEach() {
    }

    @Test
    public void shouldReturnNoAncestorForRoot() {
        if (this.path.isRoot()) {
            Assert.assertThat((Object)this.path.getParent(), (Matcher)IsNull.nullValue());
        }
    }

    @Test
    public void shouldReturnRootForAnyAncestorExactDegreeFromRoot() {
        Assert.assertThat((Object)this.path.getAncestor(this.path.size()).isRoot(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotAllowAncestorDegreeLargerThanSize() {
        this.path.getAncestor(this.path.size() + 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNegativeAncestorDegree() {
        this.path.getAncestor(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowGettingAncestorOfNullPath() {
        this.path.getCommonAncestor(null);
    }

    @Test
    public void shouldNotConsiderNodeToBeAncestorOfItself() {
        Assert.assertThat((Object)this.path.isAncestorOf(this.path), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotConsiderNodeToBeDecendantOfItself() {
        Assert.assertThat((Object)this.path.isDecendantOf(this.path), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderANodeToHaveSameAncestorAsItself() {
        Assert.assertThat((Object)this.path.hasSameAncestor(this.path), (Matcher)Is.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForSameAncestorOfNullPath() {
        this.path.hasSameAncestor(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForDecendantOfNullPath() {
        this.path.isDecendantOf(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForAtOrAboveNullPath() {
        this.path.isAtOrAbove(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForAtOrBelowNullPath() {
        this.path.isAtOrBelow(null);
    }

    @Test
    public void shouldConsiderNodeToBeAtOrAboveItself() {
        Assert.assertThat((Object)this.path.isAtOrAbove(this.path), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderNodeToBeAtOrBelowItself() {
        Assert.assertThat((Object)this.path.isAtOrBelow(this.path), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnNullForLastSegmentOfRoot() {
        if (this.path.isRoot()) {
            Assert.assertThat((Object)this.path.getLastSegment(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    @Test
    public void shouldNeverReturnNullForLastSegmentOfNonRoot() {
        if (!this.path.isRoot()) {
            Assert.assertThat((Object)this.path.getLastSegment(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    public void shouldReturnNonNullIteratorOverSegments() {
        Assert.assertThat((Object)this.path.iterator(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSegmentAtIndexEqualToSize() {
        this.path.getSegment(this.path.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToReturnSegmentAtNegativeIndex() {
        this.path.getSegment(-1);
    }

    @Test
    public void shouldReturnNonNullSegmentsArray() {
        Assert.assertThat((Object)this.path.getSegmentsArray(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldReturnNonNullSegmentsList() {
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableSegmentsList() {
        this.path.getSegmentsList().add(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableSegmentsIterator() {
        Iterator iter = this.path.iterator();
        if (iter.hasNext()) {
            iter.remove();
        }
    }

    @Test
    public void shouldAlwaysReturnNonNullStringForGetString() {
        Assert.assertThat((Object)this.path.getString(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNamespaceRegistry() {
        this.path.getString((NamespaceRegistry)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNamespaceRegistryWithNonNullTextEncoder() {
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        this.path.getString((NamespaceRegistry)null, encoder);
    }

    @Test
    public void shouldReturnSelfForSubpathStartingAtZero() {
        Assert.assertThat((Object)this.path.subpath(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowSubpathStartingAtNegativeNumber() {
        this.path.subpath(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathStartingAtIndexEqualToSize() {
        if (this.path.isRoot()) {
            this.path.subpath(1);
        }
        this.path.subpath(this.path.size());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathEndingAtMoreThanSize() {
        this.path.subpath(0, this.path.size() + 1);
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotFindRelativePathToAnotherRelativePath() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.stub((Object)other.isAbsolute()).toReturn((Object)false);
        this.path.relativeTo(other);
    }

    @Test
    public void shouldAlwaysConsiderPathEqualToItself() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.stub((Object)other.isRoot()).toReturn((Object)true);
        Assert.assertThat((Object)this.path.compareTo((Object)this.path), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.path.equals(this.path), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAlwaysReturnNonNullToString() {
        Assert.assertThat((Object)this.path.toString(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldGetPathsFromRoot() {
        Iterator iter = this.path.pathsFromRoot();
        List segments = this.path.getSegmentsList();
        ArrayList<Path.Segment> lastSegments = new ArrayList<Path.Segment>();
        while (iter.hasNext()) {
            Path next = (Path)iter.next();
            Assert.assertThat((Object)next, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            if (next.isRoot()) continue;
            lastSegments.add(next.getLastSegment());
        }
        Assert.assertThat((Object)lastSegments.size(), (Matcher)Is.is((Object)this.path.size()));
        Assert.assertThat(lastSegments, (Matcher)Is.is((Object)segments));
    }
}

