/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.progress.VerificationMode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.AbstractPathTest;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPath;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.ChildPath;
import org.modeshape.graph.property.basic.RootPath;

public class ChildPathTest
extends AbstractPathTest {
    protected Path parent;
    protected Path root;
    protected Path.Segment childSegment;

    @Before
    public void beforeEach() {
        super.beforeEach();
        this.parent = this.path("/a/b/c");
        this.childSegment = this.segment("d");
        this.path = new ChildPath(this.parent, this.childSegment);
        this.root = RootPath.INSTANCE;
    }

    protected Path path(String path) {
        if ("/".equals(path = path.trim())) {
            return RootPath.INSTANCE;
        }
        boolean absolute = path.startsWith("/");
        path = path.replaceAll("^/+", "").replaceAll("/+$", "");
        String[] segmentStrings = path.split("/");
        ArrayList<BasicPathSegment> segments = new ArrayList<BasicPathSegment>(segmentStrings.length);
        for (String segmentString : segmentStrings) {
            BasicName name = new BasicName("", segmentString);
            BasicPathSegment segment = new BasicPathSegment((Name)name);
            segments.add(segment);
        }
        return new BasicPath(segments, absolute);
    }

    protected Path.Segment segment(String segment) {
        BasicName name = new BasicName("", segment);
        return new BasicPathSegment((Name)name);
    }

    @Test
    public void shouldReturnParentForAncestorOfDegreeOne() {
        Assert.assertThat((Object)this.path.getAncestor(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)this.path.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
    }

    @Test
    public void shouldDelegateToParentForAncestorOfDegreeGreaterThanOne() {
        this.parent = (Path)Mockito.mock(Path.class);
        Mockito.stub((Object)this.parent.getAncestor(Matchers.anyInt())).toReturn(null);
        this.path = new ChildPath(this.parent, this.segment("d"));
        for (int i = 2; i != 10; ++i) {
            this.path.getAncestor(i);
            ((Path)Mockito.verify((Object)this.parent)).getAncestor(i - 1);
        }
    }

    @Test
    public void shouldConsiderChildPathToBeDecendantOfParent() {
        Assert.assertThat((Object)this.path.isDecendantOf(this.parent), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderChildPathToNotBeAncestorOfParent() {
        Assert.assertThat((Object)this.path.isAncestorOf(this.parent), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderParentNotBeDecendantOfChildPath() {
        Assert.assertThat((Object)this.parent.isDecendantOf(this.path), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderPathDecendantOfOtherPathIfParentIsAtOrBelowOtherPath() {
        this.parent = (Path)Mockito.mock(Path.class);
        this.path = new ChildPath(this.parent, this.segment("d"));
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.stub((Object)this.parent.isAtOrBelow(other)).toReturn((Object)true);
        Assert.assertThat((Object)this.path.isDecendantOf(other), (Matcher)Is.is((Object)true));
        ((Path)Mockito.verify((Object)this.parent)).isAtOrBelow(other);
        Mockito.stub((Object)this.parent.isAtOrBelow(other)).toReturn((Object)false);
        Assert.assertThat((Object)this.path.isDecendantOf(other), (Matcher)Is.is((Object)false));
        ((Path)Mockito.verify((Object)this.parent, (VerificationMode)Mockito.times((int)2))).isAtOrBelow(other);
    }

    @Test
    public void shouldConsiderPathDecendantOfOtherParentPath() {
        Assert.assertThat((Object)this.path.isDecendantOf(this.parent), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnChildSegmentFromGetLastSegment() {
        Assert.assertThat((Object)this.path.getLastSegment(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.childSegment)));
    }

    @Test
    public void shouldReturnChildSegmentFromGetSegmentWithIndexOfSizeMinusOne() {
        Assert.assertThat((Object)this.path.getSegment(this.path.size() - 1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.childSegment)));
    }

    @Test
    public void shouldDelegateGetSegmentToParentIfIndexNotEqualToSizeMinusOne() {
        Path.Segment segment = (Path.Segment)Mockito.mock(Path.Segment.class);
        this.parent = (Path)Mockito.mock(Path.class);
        Mockito.stub((Object)this.parent.size()).toReturn((Object)10);
        this.path = new ChildPath(this.parent, this.segment("d"));
        Mockito.stub((Object)this.parent.getSegment(Matchers.anyInt())).toReturn((Object)segment);
        for (int i = 0; i < this.path.size() - 1; ++i) {
            Assert.assertThat((Object)this.path.getSegment(i), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)segment)));
        }
        ((Path)Mockito.verify((Object)this.parent, (VerificationMode)Mockito.times((int)this.parent.size()))).getSegment(Matchers.anyInt());
    }

    @Test
    public void shouldReturnParentInstanceFromGetParent() {
        Assert.assertThat((Object)this.path.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
    }

    @Test
    public void shouldConsiderAsNotNormalizedAPathWithParentSegmentAtEnd() {
        this.path = new ChildPath(this.parent, Path.PARENT_SEGMENT);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)this.parent.isAbsolute()));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderAsNormalizedARelativePathWithParentSegmentAtFront() {
        this.parent = this.path("../../a/b/c/d");
        this.path = new ChildPath(this.parent, this.segment("e"));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderAsNormalizedAnAbsolutePathWithParentSegmentAtFront() {
        this.parent = this.path("/../a/b");
        this.path = new ChildPath(this.parent, this.segment("c"));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderAsNormalizedPathWithAllParentReferences() {
        this.parent = this.path("../../../../..");
        this.path = new ChildPath(this.parent, Path.PARENT_SEGMENT);
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderAsNotNormalizedPathWithMostParentReferencesAndOneNonParentReferenceInMiddle() {
        this.parent = this.path("../../a/b/../..");
        this.path = new ChildPath(this.parent, Path.PARENT_SEGMENT);
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
    }
}

