/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;
import org.junit.matchers.TypeSafeMatcher;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsPathContaining
extends TypeSafeMatcher<Iterable<Path.Segment>> {
    private final Matcher<? super Path.Segment> elementMatcher;

    public IsPathContaining(Matcher<? super Path.Segment> elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    public boolean matchesSafely(Iterable<Path.Segment> collection) {
        for (Path.Segment item : collection) {
            if (!this.elementMatcher.matches((Object)item)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a path containing ").appendDescriptionOf(this.elementMatcher);
    }

    @Factory
    public static Matcher<Iterable<Path.Segment>> hasSegment(Matcher<? super Path.Segment> elementMatcher) {
        return new IsPathContaining(elementMatcher);
    }

    @Factory
    public static Matcher<Iterable<Path.Segment>> hasSegment(Path.Segment element) {
        return IsPathContaining.hasSegment((Matcher<? super Path.Segment>)IsEqual.equalTo((Object)element));
    }

    @Factory
    public static Matcher<Iterable<Path.Segment>> hasSegments(Matcher<Path.Segment> ... elementMatchers) {
        ArrayList<Matcher<Iterable<Path.Segment>>> all = new ArrayList<Matcher<Iterable<Path.Segment>>>(elementMatchers.length);
        for (Matcher<Path.Segment> elementMatcher : elementMatchers) {
            Matcher<Iterable<Path.Segment>> itemMatcher = IsPathContaining.hasSegment(elementMatcher);
            all.add(itemMatcher);
        }
        return AllOf.allOf(all);
    }

    @Factory
    public static Matcher<Iterable<Path.Segment>> hasSegments(Path.Segment ... elements) {
        ArrayList<Matcher<Iterable<Path.Segment>>> all = new ArrayList<Matcher<Iterable<Path.Segment>>>(elements.length);
        for (Path.Segment element : elements) {
            all.add(IsPathContaining.hasSegment(element));
        }
        return AllOf.allOf(all);
    }

    @Factory
    public static Matcher<Iterable<Path.Segment>> hasSegment(PathFactory pathFactory, String element) {
        Path.Segment segment = pathFactory.createSegment(element);
        return IsPathContaining.hasSegment((Matcher<? super Path.Segment>)IsEqual.equalTo((Object)segment));
    }

    @Factory
    public static Matcher<Iterable<Path.Segment>> hasSegments(PathFactory pathFactory, String ... segments) {
        ArrayList<Matcher<Iterable<Path.Segment>>> all = new ArrayList<Matcher<Iterable<Path.Segment>>>(segments.length);
        for (String element : segments) {
            all.add(IsPathContaining.hasSegment(pathFactory, element));
        }
        return AllOf.allOf(all);
    }
}

