/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.IsPathContaining;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathValueFactoryTest {
    public static final TextEncoder NO_OP_ENCODER = Path.NO_OP_ENCODER;
    private SimpleNamespaceRegistry registry;
    private ValueFactory<String> stringValueFactory;
    private NameValueFactory nameFactory;
    private PathValueFactory factory;
    private Path path;
    private Path path2;

    @Before
    public void beforeEach() {
        this.registry = new SimpleNamespaceRegistry();
        this.registry.register("dna", "http://www.modeshape.org/namespace");
        this.stringValueFactory = new StringValueFactory((NamespaceRegistry)this.registry, Path.DEFAULT_DECODER, Path.DEFAULT_ENCODER);
        this.nameFactory = new NameValueFactory((NamespaceRegistry)this.registry, Path.DEFAULT_DECODER, this.stringValueFactory);
        this.factory = new PathValueFactory(Path.DEFAULT_DECODER, this.stringValueFactory, (ValueFactory)this.nameFactory);
    }

    protected List<Path.Segment> getSegments(String ... segments) {
        ArrayList<Path.Segment> result = new ArrayList<Path.Segment>();
        for (String segmentStr : segments) {
            Name name = this.nameFactory.create(segmentStr);
            BasicPathSegment segment = new BasicPathSegment(name);
            result.add((Path.Segment)segment);
        }
        return result;
    }

    @Test
    public void shouldCreateFromStringWithAbsolutePathAndNoParentOrSelfReferences() {
        this.path = this.factory.create("/a/b/c/d/dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, "a", "b", "c", "d", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateFromStringWithRelativePathAndNoParentOrSelfReferences() {
        this.path = this.factory.create("a/b/c/d/dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, "a", "b", "c", "d", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateFromStringWithAbsolutePathAndParentReference() {
        this.path = this.factory.create("/a/b/c/../dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, "a", "b", "c", "..", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateFromStringWithRelativePathAndParentReference() {
        this.path = this.factory.create("a/b/c/../dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, "a", "b", "c", "..", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateFromStringWithAbsolutePathAndSelfReference() {
        this.path = this.factory.create("/a/b/c/./dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, "a", "b", "c", ".", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateFromStringWithRelativePathAndSelfReference() {
        this.path = this.factory.create("a/b/c/./dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, "a", "b", "c", ".", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateFromStringWithRelativePathBeginningWithSelfReference() {
        this.path = this.factory.create("./a/b/c/./dna:e/dna:f");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.factory, ".", "a", "b", "c", ".", "dna:e", "dna:f"));
    }

    @Test
    public void shouldCreateEquivalentPathsWhetherOrNotThereIsATrailingDelimiter() {
        this.path = this.factory.create("/a/b/c/d/dna:e/dna:f");
        this.path2 = this.factory.create("/a/b/c/d/dna:e/dna:f/");
        Assert.assertThat((Object)this.path.equals(this.path2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.compareTo((Object)this.path2), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add("/a/b/c/d/dna:e/dna:f" + i);
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.factory.create((String)valueIter.next())));
        }
    }
}

