/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.collection.Problems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.ArithmeticOperand;
import org.modeshape.graph.query.model.ArithmeticOperator;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.optimize.RuleBasedOptimizer;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.JoinAlgorithm;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedOptimizerTest
extends AbstractQueryTest {
    private RuleBasedOptimizer optimizer;
    private List<OptimizerRule> rules;
    private List<Integer> ruleExecutionOrder;
    private QueryContext context;
    private PlanNode node;
    private boolean print;

    @Before
    public void beforeEach() {
        TypeSystem typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        ImmutableSchemata.Builder builder = ImmutableSchemata.createBuilder((TypeSystem)typeSystem);
        builder.addTable("t1", new String[]{"c11", "c12", "c13"});
        builder.addTable("t2", new String[]{"c21", "c22", "c23"});
        builder.addTable("all", new String[]{"a1", "a2", "a3", "a4", "primaryType", "mixins"});
        builder.makeSearchable("all", "a2");
        builder.makeSearchable("all", "a1");
        builder.addKey("all", new String[]{"a1"});
        builder.addKey("all", new String[]{"a3"});
        builder.addView("v1", "SELECT c11, c12 AS c2 FROM t1 WHERE c13 < CAST('3' AS LONG)");
        builder.addView("v2", "SELECT t1.c11, t1.c12, t2.c23 FROM t1 JOIN t2 ON t1.c11 = t2.c21");
        builder.addView("type1", "SELECT all.a1, all.a2 FROM all WHERE all.primaryType IN ('t1','t0') AND all.mixins IN ('t3','t4')");
        builder.addView("type2", "SELECT all.a3, all.a4 FROM all WHERE all.primaryType IN ('t2','t0') AND all.mixins IN ('t4','t5')");
        Schemata schemata = builder.build();
        this.context = new QueryContext(schemata, typeSystem);
        this.node = new PlanNode(PlanNode.Type.ACCESS);
        this.ruleExecutionOrder = new ArrayList<Integer>();
        this.rules = new ArrayList<OptimizerRule>();
        int i = 0;
        while (i != 5) {
            final int ruleNumber = i++;
            this.rules.add(new OptimizerRule(){

                public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
                    RuleBasedOptimizerTest.this.ruleExecutionOrder.add(ruleNumber);
                    return plan;
                }
            });
        }
        this.optimizer = new RuleBasedOptimizer(){

            protected void populateRuleStack(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
                ruleStack.addAll(RuleBasedOptimizerTest.this.rules);
            }
        };
        this.print = false;
    }

    @Test
    public void shouldExecuteEachRuleInSequence() {
        this.optimizer.optimize(this.context, this.node);
        for (int i = 0; i != this.rules.size(); ++i) {
            Assert.assertThat((Object)this.ruleExecutionOrder.get(i), (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldStopExecutingRulesIfThereIsAnErrorInTheProblems() {
        this.rules.set(3, new OptimizerRule(){

            public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
                context.getProblems().addError(GraphI18n.errorReadingPropertyValueBytes, new Object[0]);
                return plan;
            }
        });
        this.optimizer.optimize(this.context, this.node);
        Assert.assertThat((Object)this.ruleExecutionOrder.get(0), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.ruleExecutionOrder.get(1), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.ruleExecutionOrder.get(2), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.ruleExecutionOrder.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithSelectColumns() {
        this.node = this.optimize("SELECT c11,c12 FROM t1");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12")));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, project, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithSelectStar() {
        this.node = this.optimize("SELECT * FROM t1");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12"), this.column("t1", "c13")));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, project, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithSelectStarWithAlias() {
        this.node = this.optimize("SELECT * FROM t1 AS x1");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12"), this.column("t1", "c13")));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, project, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithSelectStarFromTableWithAliasAndValueCriteria() {
        this.node = this.optimize("SELECT * FROM t1 AS x1 WHERE c13 < CAST('3' AS LONG)");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12"), this.column("t1", "c13")));
        PlanNode select = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        select.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c13"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithSelectStarFromViewWithNoAliasAndValueCriteria() {
        this.node = this.optimize("SELECT * FROM v1 WHERE c11 = 'value'");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12", "c2")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"value")));
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c13"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select2, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithSelectStarFromViewWithAliasAndValueCriteria() {
        this.node = this.optimize("SELECT * FROM v1 AS x1 WHERE c11 = 'value'");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12", "c2")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"value")));
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c13"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select2, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForSimpleQueryWithPropertyValueCriteria() {
        this.node = this.optimize("SELECT c11, c12 FROM t1 WHERE c13 < CAST('3' AS LONG)");
        PlanNode expected = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, expected, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12")));
        PlanNode select = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        select.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c13"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(expected), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForEquiJoinQuery() {
        this.node = this.optimize("SELECT t1.c11, t1.c12, t2.c23 FROM t1 JOIN t2 ON t1.c11 = t2.c21");
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("t2"), this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12"), this.column("t2", "c23")));
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, project, new SelectorName[]{this.selector("t2"), this.selector("t1")});
        join.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("t1"), "c11", this.selector("t2"), "c21"));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftProject, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        PlanNode rightAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t2")});
        PlanNode rightProject = new PlanNode(PlanNode.Type.PROJECT, rightAccess, new SelectorName[]{this.selector("t2")});
        rightProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t2", "c23"), this.column("t2", "c21")));
        PlanNode rightSource = new PlanNode(PlanNode.Type.SOURCE, rightProject, new SelectorName[]{this.selector("t2")});
        rightSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t2"));
        rightSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t2")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(project), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingView() {
        this.node = this.optimize("SELECT v1.c11 AS c1 FROM v1 WHERE v1.c11 = 'x' AND v1.c2 = 'y'");
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("t1")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("t1")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)Character.valueOf('x'))));
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("t1")});
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)Character.valueOf('y'))));
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("t1")});
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c13"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("t1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(access), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingViewContainingJoin() {
        this.node = this.optimize("SELECT v2.c11 AS c1 FROM v2 WHERE v2.c11 = 'x' AND v2.c12 = 'y'");
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, project, new SelectorName[]{this.selector("t2"), this.selector("t1")});
        join.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("t1"), "c11", this.selector("t2"), "c21"));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)Character.valueOf('x'))));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)Character.valueOf('y'))));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        PlanNode rightAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t2")});
        PlanNode rightProject = new PlanNode(PlanNode.Type.PROJECT, rightAccess, new SelectorName[]{this.selector("t2")});
        rightProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t2", "c21")));
        PlanNode rightSelect1 = new PlanNode(PlanNode.Type.SELECT, rightProject, new SelectorName[]{this.selector("t2")});
        rightSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t2"), "c21"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)Character.valueOf('x'))));
        PlanNode rightSource = new PlanNode(PlanNode.Type.SOURCE, rightSelect1, new SelectorName[]{this.selector("t2")});
        rightSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t2"));
        rightSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t2")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(project), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingTypeView() {
        this.node = this.optimize("SELECT type1.a1 AS a, type1.a2 AS b FROM type1 WHERE CONTAINS(type1.a2,'something')");
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("all")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("all")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("all", "a1", "a"), this.column("all", "a2", "b")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("all")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new FullTextSearch(this.selector("all"), "a2", "something"));
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("all")});
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t1"), new Literal((Object)"t0")}));
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("all")});
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t3"), new Literal((Object)"t4")}));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("all")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("all"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("all")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(access), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryJoiningMultipleTypeViewsUsingIdentityEquiJoin() {
        this.node = this.optimize("SELECT type1.a1 AS a, type1.a2 AS b, type2.a3 as c, type2.a4 as d FROM type1 JOIN type2 ON type1.a1 = type2.a3 WHERE CONTAINS(type1.a2,'something')");
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("all")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("all")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("all", "a1", "a"), this.column("all", "a2", "b"), this.column("all", "a3", "c"), this.column("all", "a4", "d")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("all")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new FullTextSearch(this.selector("all"), "a2", "something"));
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("all")});
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t1"), new Literal((Object)"t0")}));
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("all")});
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t3"), new Literal((Object)"t4")}));
        PlanNode select4 = new PlanNode(PlanNode.Type.SELECT, select3, new SelectorName[]{this.selector("all")});
        select4.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t2"), new Literal((Object)"t0")}));
        PlanNode select5 = new PlanNode(PlanNode.Type.SELECT, select4, new SelectorName[]{this.selector("all")});
        select5.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t4"), new Literal((Object)"t5")}));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select5, new SelectorName[]{this.selector("all")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("all"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("all")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(access), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryJoiningMultipleTypeViewsUsingNonIdentityEquiJoin() {
        this.node = this.optimize("SELECT type1.a1 AS a, type1.a2 AS b, type2.a3 as c, type2.a4 as d FROM type1 JOIN type2 ON type1.a2 = type2.a3 WHERE CONTAINS(type1.a1,'something')");
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("all")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("all", "a1", "a"), this.column("all", "a2", "b"), this.column("all", "a3", "c"), this.column("all", "a4", "d")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("all")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new FullTextSearch(this.selector("all"), "a1", "something"));
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, select1, new SelectorName[]{this.selector("all")});
        join.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("all"), "a2", this.selector("all"), "a3"));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("all")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("all")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("all", "a1"), this.column("all", "a2"), this.column("all", "a3")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("all")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t1"), new Literal((Object)"t0")}));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("all")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t3"), new Literal((Object)"t4")}));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("all")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("all"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("all")).getColumns());
        PlanNode rightAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("all")});
        PlanNode rightProject = new PlanNode(PlanNode.Type.PROJECT, rightAccess, new SelectorName[]{this.selector("all")});
        rightProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("all", "a3"), this.column("all", "a4"), this.column("all", "a2")));
        PlanNode rightSelect1 = new PlanNode(PlanNode.Type.SELECT, rightProject, new SelectorName[]{this.selector("all")});
        rightSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t2"), new Literal((Object)"t0")}));
        PlanNode rightSelect2 = new PlanNode(PlanNode.Type.SELECT, rightSelect1, new SelectorName[]{this.selector("all")});
        rightSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t4"), new Literal((Object)"t5")}));
        PlanNode rightSource = new PlanNode(PlanNode.Type.SOURCE, rightSelect2, new SelectorName[]{this.selector("all")});
        rightSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("all"));
        rightSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("all")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(project), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryJoiningMultipleTypeViewsUsingSameNodeJoin() {
        this.node = this.optimize("SELECT type1.a1 AS a, type1.a2 AS b, type2.a3 as c, type2.a4 as d FROM type1 JOIN type2 ON ISSAMENODE(type1,type2) WHERE CONTAINS(type1.a2,'something')");
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, new SelectorName[]{this.selector("all")});
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, access, new SelectorName[]{this.selector("all")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("all", "a1", "a"), this.column("all", "a2", "b"), this.column("all", "a3", "c"), this.column("all", "a4", "d")));
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("all")});
        select1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new FullTextSearch(this.selector("all"), "a2", "something"));
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("all")});
        select2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t1"), new Literal((Object)"t0")}));
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("all")});
        select3.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t3"), new Literal((Object)"t4")}));
        PlanNode select4 = new PlanNode(PlanNode.Type.SELECT, select3, new SelectorName[]{this.selector("all")});
        select4.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "primaryType"), new StaticOperand[]{new Literal((Object)"t2"), new Literal((Object)"t0")}));
        PlanNode select5 = new PlanNode(PlanNode.Type.SELECT, select4, new SelectorName[]{this.selector("all")});
        select5.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new SetCriteria((DynamicOperand)new PropertyValue(this.selector("all"), "mixins"), new StaticOperand[]{new Literal((Object)"t4"), new Literal((Object)"t5")}));
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select5, new SelectorName[]{this.selector("all")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("all"));
        source.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("all")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(access), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingTableAndOrderByClause() {
        this.print = true;
        this.node = this.optimize("SELECT t1.c11 AS c1 FROM t1 WHERE t1.c11 = 'x' AND t1.c12 = 'y' ORDER BY t1.c11, t1.c12 DESC");
        PlanNode sort = new PlanNode(PlanNode.Type.SORT, new SelectorName[]{this.selector("t1")});
        sort.setProperty(PlanNode.Property.SORT_ORDER_BY, this.orderings(this.ascending("t1", "c11"), this.descending("t1", "c12")));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, sort, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1"), this.column("t1", "c12")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"y")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(sort), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingTableWithAliasAndOrderByClause() {
        this.print = true;
        this.node = this.optimize("SELECT X.c11 AS c1 FROM t1 AS X WHERE X.c11 = 'x' AND X.c12 = 'y' ORDER BY X.c11, X.c12 DESC");
        PlanNode sort = new PlanNode(PlanNode.Type.SORT, new SelectorName[]{this.selector("t1")});
        sort.setProperty(PlanNode.Property.SORT_ORDER_BY, this.orderings(this.ascending("t1", "c11"), this.descending("t1", "c12")));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, sort, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1"), this.column("t1", "c12")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"y")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(sort), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingTableWithAliasAndOrderByClauseUsingAliasedColumn() {
        this.print = true;
        this.node = this.optimize("SELECT X.c11 AS c1 FROM t1 AS X WHERE X.c11 = 'x' AND X.c12 = 'y' ORDER BY X.c1, X.c12 DESC");
        PlanNode sort = new PlanNode(PlanNode.Type.SORT, new SelectorName[]{this.selector("t1")});
        sort.setProperty(PlanNode.Property.SORT_ORDER_BY, this.orderings(this.ascending("t1", "c11"), this.descending("t1", "c12")));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, sort, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1"), this.column("t1", "c12")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"y")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(sort), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingViewAndOrderByClause() {
        this.print = true;
        this.node = this.optimize("SELECT v2.c11 AS c1 FROM v2 WHERE v2.c11 = 'x' AND v2.c12 = 'y' ORDER BY v2.c11, v2.c12 DESC");
        PlanNode sort = new PlanNode(PlanNode.Type.SORT, new SelectorName[]{this.selector("t1")});
        sort.setProperty(PlanNode.Property.SORT_ORDER_BY, this.orderings(this.ascending("t1", "c11"), this.descending("t1", "c12")));
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, sort, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, project, new SelectorName[]{this.selector("t2"), this.selector("t1")});
        join.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("t1"), "c11", this.selector("t2"), "c21"));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"y")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        PlanNode rightAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t2")});
        PlanNode rightProject = new PlanNode(PlanNode.Type.PROJECT, rightAccess, new SelectorName[]{this.selector("t2")});
        rightProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t2", "c21")));
        PlanNode rightSelect1 = new PlanNode(PlanNode.Type.SELECT, rightProject, new SelectorName[]{this.selector("t2")});
        rightSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t2"), "c21"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode rightSource = new PlanNode(PlanNode.Type.SOURCE, rightSelect1, new SelectorName[]{this.selector("t2")});
        rightSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t2"));
        rightSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t2")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(sort), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryUsingViewWithAliasAndOrderByClause() {
        this.print = true;
        this.node = this.optimize("SELECT Q.c11 AS c1 FROM v2 AS Q WHERE Q.c11 = 'x' AND Q.c12 = 'y' ORDER BY Q.c11, Q.c12 DESC");
        PlanNode sort = new PlanNode(PlanNode.Type.SORT, new SelectorName[]{this.selector("t1")});
        sort.setProperty(PlanNode.Property.SORT_ORDER_BY, this.orderings(this.ascending("t1", "c11"), this.descending("t1", "c12")));
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, sort, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, project, new SelectorName[]{this.selector("t2"), this.selector("t1")});
        join.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("t1"), "c11", this.selector("t2"), "c21"));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"y")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        PlanNode rightAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t2")});
        PlanNode rightProject = new PlanNode(PlanNode.Type.PROJECT, rightAccess, new SelectorName[]{this.selector("t2")});
        rightProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t2", "c21")));
        PlanNode rightSelect1 = new PlanNode(PlanNode.Type.SELECT, rightProject, new SelectorName[]{this.selector("t2")});
        rightSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t2"), "c21"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode rightSource = new PlanNode(PlanNode.Type.SOURCE, rightSelect1, new SelectorName[]{this.selector("t2")});
        rightSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t2"));
        rightSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t2")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(sort), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOptimizePlanForQueryWithOrderByClauseThatUsesScoreFunction() {
        this.node = this.optimize("SELECT v2.c11 AS c1 FROM v2 WHERE v2.c11 = 'x' AND v2.c12 = 'y' ORDER BY SCORE(v2) ASC");
        PlanNode sort = new PlanNode(PlanNode.Type.SORT, new SelectorName[]{this.selector("t1"), this.selector("t2")});
        sort.setProperty(PlanNode.Property.SORT_ORDER_BY, this.orderings(this.ascendingScore("t1", "t2")));
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, sort, new SelectorName[]{this.selector("t1")});
        project.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, project, new SelectorName[]{this.selector("t2"), this.selector("t1")});
        join.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        join.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("t1"), "c11", this.selector("t2"), "c21"));
        PlanNode leftAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t1")});
        PlanNode leftProject = new PlanNode(PlanNode.Type.PROJECT, leftAccess, new SelectorName[]{this.selector("t1")});
        leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11", "c1")));
        PlanNode leftSelect1 = new PlanNode(PlanNode.Type.SELECT, leftProject, new SelectorName[]{this.selector("t1")});
        leftSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c11"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode leftSelect2 = new PlanNode(PlanNode.Type.SELECT, leftSelect1, new SelectorName[]{this.selector("t1")});
        leftSelect2.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c12"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"y")));
        PlanNode leftSource = new PlanNode(PlanNode.Type.SOURCE, leftSelect2, new SelectorName[]{this.selector("t1")});
        leftSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        leftSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t1")).getColumns());
        PlanNode rightAccess = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("t2")});
        PlanNode rightProject = new PlanNode(PlanNode.Type.PROJECT, rightAccess, new SelectorName[]{this.selector("t2")});
        rightProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t2", "c21")));
        PlanNode rightSelect1 = new PlanNode(PlanNode.Type.SELECT, rightProject, new SelectorName[]{this.selector("t2")});
        rightSelect1.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t2"), "c21"), Operator.EQUAL_TO, (StaticOperand)new Literal((Object)"x")));
        PlanNode rightSource = new PlanNode(PlanNode.Type.SOURCE, rightSelect1, new SelectorName[]{this.selector("t2")});
        rightSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t2"));
        rightSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.context.getSchemata().getTable(this.selector("t2")).getColumns());
        Assert.assertThat((Object)this.node.isSameAs(sort), (Matcher)Is.is((Object)true));
    }

    protected List<Column> columns(Column ... columns) {
        return Arrays.asList(columns);
    }

    protected List<Ordering> orderings(Ordering ... orderings) {
        return Arrays.asList(orderings);
    }

    protected Ordering ascending(String table, String columnName) {
        return new Ordering((DynamicOperand)new PropertyValue(new SelectorName(table), columnName), Order.ASCENDING);
    }

    protected Ordering descending(String table, String columnName) {
        return new Ordering((DynamicOperand)new PropertyValue(new SelectorName(table), columnName), Order.DESCENDING);
    }

    protected Ordering ascendingScore(String ... tableNames) {
        return new Ordering(this.score(tableNames), Order.ASCENDING);
    }

    protected Ordering descendingScore(String ... tableNames) {
        return new Ordering(this.score(tableNames), Order.DESCENDING);
    }

    protected DynamicOperand score(String ... tableNames) {
        Object operand = null;
        for (String tableName : tableNames) {
            FullTextSearchScore right = new FullTextSearchScore(new SelectorName(tableName));
            operand = operand == null ? right : new ArithmeticOperand((DynamicOperand)operand, ArithmeticOperator.ADD, (DynamicOperand)right);
        }
        assert (operand != null);
        return operand;
    }

    protected Column column(String table, String columnName) {
        return new Column(new SelectorName(table), columnName, columnName);
    }

    protected Column column(String table, String columnName, String alias) {
        return new Column(new SelectorName(table), columnName, alias);
    }

    protected PlanNode optimize(String sql) {
        QueryCommand query = new SqlQueryParser().parseQuery(sql, this.context.getTypeSystem());
        Problems problems = this.context.getProblems();
        Assert.assertThat((String)("Problems parsing query: " + sql + "\n" + problems), (Object)problems.hasErrors(), (Matcher)Is.is((Object)false));
        PlanNode plan = new CanonicalPlanner().createPlan(this.context, query);
        Assert.assertThat((String)("Problems planning query: " + sql + "\n" + problems), (Object)problems.hasErrors(), (Matcher)Is.is((Object)false));
        PlanNode optimized = new RuleBasedOptimizer().optimize(this.context, plan);
        Assert.assertThat((String)("Problems optimizing query: " + sql + "\n" + problems), (Object)problems.hasErrors(), (Matcher)Is.is((Object)false));
        if (this.print) {
            System.out.println(sql);
            System.out.println(optimized);
            System.out.println();
        }
        return optimized;
    }
}

