/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.process.AbstractQueryResultsTest;
import org.modeshape.graph.query.process.QueryResultColumns;

public class QueryResultsTest
extends AbstractQueryResultsTest {
    private List<Column> columnList;
    private QueryResultColumns columnsWithoutScores;
    private QueryResultColumns columnsWithScores;

    @Before
    public void beforeEach() {
        this.columnList = new ArrayList<Column>();
        this.columnList.add(new Column(this.selector("table1"), "colA", "colA"));
        this.columnList.add(new Column(this.selector("table1"), "colB", "colB"));
        this.columnList.add(new Column(this.selector("table1"), "colC", "colC"));
        this.columnList.add(new Column(this.selector("table2"), "colA", "colA2"));
        this.columnList.add(new Column(this.selector("table2"), "colB", "colB2"));
        this.columnList.add(new Column(this.selector("table2"), "colX", "colX"));
        this.columnsWithoutScores = new QueryResultColumns(this.columnList, false);
        this.columnsWithScores = new QueryResultColumns(this.columnList, true);
    }

    @Test
    public void shouldHaveCorrectTupleSize() {
        Assert.assertThat((Object)this.columnsWithScores.getTupleSize(), (Matcher)Is.is((Object)(this.columnList.size() + 2 + 2)));
        Assert.assertThat((Object)this.columnsWithoutScores.getTupleSize(), (Matcher)Is.is((Object)(this.columnList.size() + 2 + 0)));
    }

    @Test
    public void shouldHaveCorrectTupleNames() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("colA");
        expected.add("colB");
        expected.add("colC");
        expected.add("colA2");
        expected.add("colB2");
        expected.add("colX");
        expected.add("Location(table1)");
        expected.add("Location(table2)");
        Assert.assertThat((Object)this.columnsWithoutScores.getTupleValueNames(), (Matcher)Is.is(expected));
        expected.add("Score(table1)");
        expected.add("Score(table2)");
        Assert.assertThat((Object)this.columnsWithScores.getTupleValueNames(), (Matcher)Is.is(expected));
    }

    @Test
    public void shouldHaveCorrectSelectorNames() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("table1");
        expected.add("table2");
        Assert.assertThat((Object)this.columnsWithoutScores.getSelectorNames(), (Matcher)Is.is(expected));
        Assert.assertThat((Object)this.columnsWithScores.getSelectorNames(), (Matcher)Is.is(expected));
    }

    @Test
    public void shouldHaveCorrectNumberOfColumns() {
        Assert.assertThat((Object)this.columnsWithScores.getColumnCount(), (Matcher)Is.is((Object)this.columnList.size()));
        Assert.assertThat((Object)this.columnsWithoutScores.getColumnCount(), (Matcher)Is.is((Object)this.columnList.size()));
    }

    @Test
    public void shouldReturnColumns() {
        Assert.assertThat((Object)this.columnsWithScores.getColumns(), (Matcher)Is.is(this.columnList));
        Assert.assertThat((Object)this.columnsWithoutScores.getColumns(), (Matcher)Is.is(this.columnList));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableColumns() {
        Assert.assertThat((Object)this.columnsWithoutScores.getColumns().isEmpty(), (Matcher)Is.is((Object)false));
        this.columnsWithoutScores.getColumns().clear();
    }

    @Test
    public void shouldReturnColumnNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Column column : this.columnList) {
            names.add(column.getColumnName());
        }
        Assert.assertThat((Object)this.columnsWithScores.getColumnNames(), (Matcher)Is.is(names));
        Assert.assertThat((Object)this.columnsWithoutScores.getColumnNames(), (Matcher)Is.is(names));
    }

    @Test
    public void shouldReturnCorrectIndexOfColumnGivenColumnName() {
        for (Column column : this.columnList) {
            Assert.assertThat((Object)this.columnsWithoutScores.getColumnIndexForName(column.getColumnName()), (Matcher)Is.is((Object)this.columnList.indexOf(column)));
        }
    }

    @Test
    public void shouldReturnCorrectIndexOfColumnGivenColumnSelectorAndPropertyName() {
        for (Column column : this.columnList) {
            Assert.assertThat((Object)this.columnsWithoutScores.getColumnIndexForProperty(column.getSelectorName().getName(), column.getPropertyName()), (Matcher)Is.is((Object)this.columnList.indexOf(column)));
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenColumnNameWithIncorrectCase() {
        this.columnsWithScores.getColumnIndexForName("cola");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenNonExistantColumnName() {
        this.columnsWithScores.getColumnIndexForName("non-existant");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenNullColumnName() {
        this.columnsWithScores.getColumnIndexForName(null);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenUnusedSelectorName() {
        this.columnsWithScores.getColumnIndexForProperty("non-existant", "colA");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenNullSelectorName() {
        this.columnsWithScores.getColumnIndexForProperty(null, "colA");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenEmptySelectorName() {
        this.columnsWithScores.getColumnIndexForProperty("", "colA");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenUnusedPropertyNameName() {
        this.columnsWithScores.getColumnIndexForProperty("table1", "non-existant");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfColumnGivenNullPropertyNameName() {
        this.columnsWithScores.getColumnIndexForProperty("table1", null);
    }

    @Test
    public void shouldHaveCorrectNumberOfLocations() {
        Assert.assertThat((Object)this.columnsWithScores.getLocationCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationCount(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldReturnCorrectIndexOfLocationGivenSelectorName() {
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndex("table1"), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndex("table2"), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfLocationGivenUnusedSelectorName() {
        this.columnsWithScores.getLocationIndex("non-existant");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfLocationGivenNullSelectorName() {
        this.columnsWithScores.getLocationIndex(null);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfLocationGivenEmptySelectorName() {
        this.columnsWithScores.getLocationIndex("");
    }

    @Test
    public void shouldReturnCorrectIndexOfLocationGivenColumnName() {
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn("colA"), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn("colB"), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn("colC"), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn("colA2"), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn("colB2"), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn("colX"), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfLocationGivenUnusedColumnName() {
        this.columnsWithScores.getLocationIndexForColumn("non-existant");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfLocationGivenNullColumnName() {
        this.columnsWithScores.getLocationIndexForColumn(null);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfLocationGivenEmptyColumnName() {
        this.columnsWithScores.getLocationIndexForColumn("");
    }

    @Test
    public void shouldReturnCorrectIndexOfLocationGivenColumnIndex() {
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn(0), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn(1), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn(2), (Matcher)Is.is((Object)(this.columnList.size() + 0)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn(3), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn(4), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
        Assert.assertThat((Object)this.columnsWithoutScores.getLocationIndexForColumn(5), (Matcher)Is.is((Object)(this.columnList.size() + 1)));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToFindIndexOfLocationGivenColumnIndexEqualToOrLargerThanNumberOfColumns() {
        this.columnsWithScores.getLocationIndexForColumn(this.columnList.size());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToFindIndexOfLocationGivenColumnIndexLessThanZero() {
        this.columnsWithScores.getLocationIndexForColumn(-1);
    }

    @Test
    public void shouldCorrectlyReportWhetherScoresAreIncluded() {
        Assert.assertThat((Object)this.columnsWithScores.hasFullTextSearchScores(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.columnsWithoutScores.hasFullTextSearchScores(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnCorrectIndexOfFullTextSearchScoreGivenSelectorName() {
        Assert.assertThat((Object)this.columnsWithScores.getFullTextSearchScoreIndexFor("table1"), (Matcher)Is.is((Object)(this.columnList.size() + 2 + 0)));
        Assert.assertThat((Object)this.columnsWithScores.getFullTextSearchScoreIndexFor("table2"), (Matcher)Is.is((Object)(this.columnList.size() + 2 + 1)));
    }

    @Test
    public void shouldReturnNegativeOneForIndexOfFullTextSearchScoreGivenValidSelectorNameButWhereNoScoresAreIncluded() {
        Assert.assertThat((Object)this.columnsWithoutScores.getFullTextSearchScoreIndexFor("table1"), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.columnsWithoutScores.getFullTextSearchScoreIndexFor("table2"), (Matcher)Is.is((Object)-1));
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfFullTextSearchScoreGivenUnusedSelectorName() {
        this.columnsWithScores.getFullTextSearchScoreIndexFor("non-existant");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfFullTextSearchScoreGivenNullSelectorName() {
        this.columnsWithScores.getFullTextSearchScoreIndexFor(null);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailToFindIndexOfFullTextSearchScoreGivenEmptySelectorName() {
        this.columnsWithScores.getFullTextSearchScoreIndexFor("");
    }

    @Test
    public void shouldIncludeSelf() {
        Assert.assertThat((Object)this.columnsWithScores.includes((QueryResults.Columns)this.columnsWithScores), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.columnsWithoutScores.includes((QueryResults.Columns)this.columnsWithoutScores), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldIncludeColumnsObjectWithSubsetOfColumnObjectsAndIndependentOfFullTextSearchScores() {
        ArrayList<Column> subset = new ArrayList<Column>();
        subset.add(this.columnList.get(0));
        subset.add(this.columnList.get(1));
        subset.add(this.columnList.get(4));
        QueryResultColumns other = new QueryResultColumns(subset, false);
        Assert.assertThat((Object)this.columnsWithScores.includes((QueryResults.Columns)other), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.columnsWithoutScores.includes((QueryResults.Columns)other), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.columnsWithoutScores.includes((QueryResults.Columns)this.columnsWithScores), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldEqualSelf() {
        Assert.assertThat((Object)this.columnsWithScores.equals((Object)this.columnsWithScores), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.columnsWithoutScores.equals((Object)this.columnsWithoutScores), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldEqualIndependentOfInclusionOfFullTextSearchScores() {
        Assert.assertThat((Object)this.columnsWithoutScores.equals((Object)this.columnsWithScores), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBeUnionCompatibleUnlessBothHaveFullTextSearchScores() {
        QueryResultColumns other = new QueryResultColumns(this.columnsWithoutScores.getColumns(), !this.columnsWithoutScores.hasFullTextSearchScores());
        Assert.assertThat((Object)this.columnsWithoutScores.isUnionCompatible((QueryResults.Columns)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBeUnionCompatibleUnlessBothDoNotHaveFullTextSearchScores() {
        QueryResultColumns other = new QueryResultColumns(this.columnsWithScores.getColumns(), !this.columnsWithScores.hasFullTextSearchScores());
        Assert.assertThat((Object)this.columnsWithScores.isUnionCompatible((QueryResults.Columns)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeUnionCompatibleWithEquivalentColumns() {
        ArrayList<Column> columnListCopy = new ArrayList<Column>();
        for (Column column : this.columnsWithScores.getColumns()) {
            columnListCopy.add(new Column(column.getSelectorName(), column.getPropertyName(), column.getColumnName()));
        }
        QueryResultColumns other = new QueryResultColumns(columnListCopy, this.columnsWithScores.hasFullTextSearchScores());
        Assert.assertThat((Object)this.columnsWithScores.isUnionCompatible((QueryResults.Columns)other), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBeUnionCompatibleWithSubsetOfColumns() {
        ArrayList<Column> columnListCopy = new ArrayList<Column>();
        for (Column column : this.columnsWithScores.getColumns()) {
            columnListCopy.add(new Column(column.getSelectorName(), column.getPropertyName(), column.getColumnName()));
        }
        columnListCopy.remove(3);
        QueryResultColumns other = new QueryResultColumns(columnListCopy, this.columnsWithScores.hasFullTextSearchScores());
        Assert.assertThat((Object)this.columnsWithScores.isUnionCompatible((QueryResults.Columns)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBeUnionCompatibleWithExtraColumns() {
        ArrayList<Column> columnListCopy = new ArrayList<Column>();
        for (Column column : this.columnsWithScores.getColumns()) {
            columnListCopy.add(new Column(column.getSelectorName(), column.getPropertyName(), column.getColumnName()));
        }
        columnListCopy.add(new Column(this.selector("table2"), "colZ", "colZ"));
        QueryResultColumns other = new QueryResultColumns(columnListCopy, this.columnsWithScores.hasFullTextSearchScores());
        Assert.assertThat((Object)this.columnsWithScores.isUnionCompatible((QueryResults.Columns)other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeUnionCompatibleWithSameColumns() {
        QueryResultColumns other = new QueryResultColumns(this.columnsWithScores.getColumns(), this.columnsWithScores.hasFullTextSearchScores());
        Assert.assertThat((Object)this.columnsWithScores.isUnionCompatible((QueryResults.Columns)other), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveToString() {
        this.columnsWithScores.toString();
        this.columnsWithoutScores.toString();
    }
}

