/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.search;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.progress.VerificationMode;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.search.MockSearchEngineProcessor;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.graph.search.SearchableRepositorySource;
import org.xml.sax.SAXException;

public class SearchableRepositorySourceTest {
    private ExecutionContext context;
    private SearchableRepositorySource searchable;
    private RepositorySource wrapped;
    private SearchEngineProcessor searchProcessor;
    private LinkedList<Request> searchRequests;
    private ExecutorService executor;
    private TypeSystem typeSystem;
    private Schemata schemata;
    private SqlQueryParser sql;
    @MockitoAnnotations.Mock
    private SearchEngine searchEngine;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.executor = Executors.newSingleThreadExecutor();
        this.typeSystem = this.context.getValueFactories().getTypeSystem();
        this.schemata = ImmutableSchemata.createBuilder((TypeSystem)this.typeSystem).addTable("t1", new String[]{"c1", "c2", "c3"}).build();
        this.sql = new SqlQueryParser();
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("source1");
        this.wrapped = source;
        this.searchRequests = new LinkedList();
        this.searchProcessor = new MockSearchEngineProcessor("source1", this.context, this.searchRequests);
        Mockito.stub((Object)this.searchEngine.createProcessor(this.context, null, true)).toReturn((Object)this.searchProcessor);
        Mockito.stub((Object)this.searchEngine.createProcessor(this.context, null, false)).toReturn((Object)this.searchProcessor);
    }

    @After
    public void afterEach() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    protected SearchableRepositorySource newSynchronousSearchable() {
        return new SearchableRepositorySource(this.wrapped, this.searchEngine, null, false, false);
    }

    protected SearchableRepositorySource newAsynchronousSearchable() {
        return new SearchableRepositorySource(this.wrapped, this.searchEngine, this.executor, true, true);
    }

    @Test
    public void shouldReturnNameOfWrappedSource() {
        this.wrapped = (RepositorySource)Mockito.mock(RepositorySource.class);
        Mockito.stub((Object)this.wrapped.getName()).toReturn((Object)"name");
        this.searchable = this.newSynchronousSearchable();
        Assert.assertThat((Object)this.searchable.getName(), (Matcher)Is.is((Object)this.wrapped.getName()));
        ((RepositorySource)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)2))).getName();
    }

    @Test
    public void shouldReturnRetryLimitOfWrappedSource() {
        this.wrapped = (RepositorySource)Mockito.mock(RepositorySource.class);
        Mockito.stub((Object)this.wrapped.getRetryLimit()).toReturn((Object)3);
        this.searchable = this.newSynchronousSearchable();
        Assert.assertThat((Object)this.searchable.getRetryLimit(), (Matcher)Is.is((Object)this.wrapped.getRetryLimit()));
        ((RepositorySource)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)2))).getRetryLimit();
    }

    @Test
    public void shouldCloseByClosingWrappedSource() {
        this.wrapped = (RepositorySource)Mockito.mock(RepositorySource.class);
        this.searchable = this.newSynchronousSearchable();
        this.searchable.close();
        ((RepositorySource)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldReturnCapabilitiesThatMatchSourceCapabilitiesExceptWithSearchableAndQueryable() {
        this.searchable = this.newSynchronousSearchable();
        RepositorySourceCapabilities sourceCapabilities = this.wrapped.getCapabilities();
        RepositorySourceCapabilities searchableCapabilities = this.searchable.getCapabilities();
        Assert.assertThat((Object)searchableCapabilities.supportsCreatingWorkspaces(), (Matcher)Is.is((Object)sourceCapabilities.supportsCreatingWorkspaces()));
        Assert.assertThat((Object)searchableCapabilities.supportsEvents(), (Matcher)Is.is((Object)sourceCapabilities.supportsEvents()));
        Assert.assertThat((Object)searchableCapabilities.supportsLocks(), (Matcher)Is.is((Object)sourceCapabilities.supportsLocks()));
        Assert.assertThat((Object)searchableCapabilities.supportsReferences(), (Matcher)Is.is((Object)sourceCapabilities.supportsReferences()));
        Assert.assertThat((Object)searchableCapabilities.supportsSameNameSiblings(), (Matcher)Is.is((Object)sourceCapabilities.supportsSameNameSiblings()));
        Assert.assertThat((Object)searchableCapabilities.supportsUpdates(), (Matcher)Is.is((Object)sourceCapabilities.supportsUpdates()));
        Assert.assertThat((Object)searchableCapabilities.supportsQueries(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)searchableCapabilities.supportsSearches(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnSynchronousConnectionIfSpecifiedInConstructor() {
        this.searchable = new SearchableRepositorySource(this.wrapped, this.searchEngine, this.executor, false, false);
        RepositoryConnection connection = this.searchable.getConnection();
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SearchableRepositorySource.SynchronousConnection.class)));
    }

    @Test
    public void shouldReturnSynchronousConnectionIfExecutorNotProvidedInConstructor() {
        this.searchable = new SearchableRepositorySource(this.wrapped, this.searchEngine, null, false, false);
        RepositoryConnection connection = this.searchable.getConnection();
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SearchableRepositorySource.SynchronousConnection.class)));
        this.searchable = new SearchableRepositorySource(this.wrapped, this.searchEngine, null, true, true);
        connection = this.searchable.getConnection();
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SearchableRepositorySource.SynchronousConnection.class)));
    }

    @Test
    public void shouldReturnParallelConnectionIfExecutorProvidedInConstructor() {
        this.searchable = new SearchableRepositorySource(this.wrapped, this.searchEngine, this.executor, true, false);
        RepositoryConnection connection = this.searchable.getConnection();
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SearchableRepositorySource.ParallelConnection.class)));
        this.searchable = new SearchableRepositorySource(this.wrapped, this.searchEngine, this.executor, true, true);
        connection = this.searchable.getConnection();
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SearchableRepositorySource.ParallelConnection.class)));
    }

    @Test
    public void shouldInitializeByInitializingWrappedSourceWithCustomObserverAndConnectionFactory() {
        final RepositoryConnectionFactory mockConnectionFactory = (RepositoryConnectionFactory)Mockito.mock(RepositoryConnectionFactory.class);
        RepositoryContext repoContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return SearchableRepositorySourceTest.this.context;
            }

            public Subgraph getConfiguration(int depth) {
                return null;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return mockConnectionFactory;
            }
        };
        final AtomicInteger called = new AtomicInteger(0);
        this.wrapped = new InMemoryRepositorySource(){
            private static final long serialVersionUID = 1L;

            public void initialize(RepositoryContext context) throws RepositorySourceException {
                called.incrementAndGet();
                Assert.assertThat((Object)context, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)context.getExecutionContext(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)SearchableRepositorySourceTest.this.context)));
                Assert.assertThat((Object)context.getObserver(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)context.getRepositoryConnectionFactory(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)context.getRepositoryConnectionFactory(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)mockConnectionFactory))));
            }
        };
        this.searchable = this.newSynchronousSearchable();
        this.searchable.initialize(repoContext);
        Assert.assertThat((Object)called.get(), (Matcher)Is.is((Object)1));
    }

    protected void assertThatSourceIsNotSearchable(RepositorySource source) {
        try {
            Graph graph = Graph.create((RepositorySource)this.wrapped, (ExecutionContext)this.context);
            graph.search("term", 100, 0);
            Assert.fail((String)"Wrapped repository source should not support searching");
        }
        catch (InvalidRequestException invalidRequestException) {
            // empty catch block
        }
        Assert.assertThat((Object)source.getCapabilities().supportsSearches(), (Matcher)Is.is((Object)false));
    }

    protected void loadContentInto(RepositorySource source, String resourceOnClasspath) throws SAXException, IOException, URISyntaxException {
        Graph graph = Graph.create((RepositorySource)source, (ExecutionContext)this.context);
        graph.importXmlFrom(this.getClass().getClassLoader().getResource(resourceOnClasspath).toURI()).into("/");
        Node boeing777 = graph.getNodeAt("/Aircraft/Commercial/Boeing 777");
        Assert.assertThat((Object)boeing777, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProcessSearchRequest() throws Exception {
        this.assertThatSourceIsNotSearchable(this.wrapped);
        this.loadContentInto(this.wrapped, "aircraft.xml");
    }

    @Test
    public void shouldSendSearchRequestToSearchEngine() throws Exception {
        this.assertThatSourceIsNotSearchable(this.wrapped);
        this.loadContentInto(this.wrapped, "aircraft.xml");
        this.searchable = this.newSynchronousSearchable();
        Assert.assertThat((Object)this.searchable.getCapabilities().supportsSearches(), (Matcher)Is.is((Object)true));
        QueryResults results = Graph.create((RepositorySource)this.searchable, (ExecutionContext)this.context).search("Boeing", 100, 1);
        Assert.assertThat((Object)results, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldSendQueryRequestToSearchEngine() throws Exception {
        this.assertThatSourceIsNotSearchable(this.wrapped);
        this.loadContentInto(this.wrapped, "aircraft.xml");
        this.searchable = this.newSynchronousSearchable();
        Assert.assertThat((Object)this.searchable.getCapabilities().supportsQueries(), (Matcher)Is.is((Object)true));
        QueryResults results = Graph.create((RepositorySource)this.searchable, (ExecutionContext)this.context).query(this.sql.parseQuery("SELECT * FROM t1", this.typeSystem), this.schemata).execute();
        Assert.assertThat((Object)results, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldSendAllRequestsToSynchronousWrappedSourceWhenRequestsAreNotSearchOrQueryRequests() throws Exception {
        this.assertThatSourceIsNotSearchable(this.wrapped);
        this.loadContentInto(this.wrapped, "aircraft.xml");
        this.searchable = this.newSynchronousSearchable();
        Graph graph = Graph.create((RepositorySource)this.searchable, (ExecutionContext)this.context);
        Node boeing777 = graph.getNodeAt("/Aircraft/Commercial/Boeing 777");
        Assert.assertThat((Object)boeing777, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        ((Graph.Batch)graph.batch().read("/Aircraft/Commercial/Boeing 777").and()).read("/Aircraft/Commercial/Boeing 787").execute();
    }

    @Test
    public void shouldSendAllRequestsToAsynchronousWrappedSourceWhenRequestsAreNotSearchOrQueryRequests() throws Exception {
        this.assertThatSourceIsNotSearchable(this.wrapped);
        this.loadContentInto(this.wrapped, "aircraft.xml");
        this.searchable = this.newAsynchronousSearchable();
        Graph graph = Graph.create((RepositorySource)this.searchable, (ExecutionContext)this.context);
        Node boeing777 = graph.getNodeAt("/Aircraft/Commercial/Boeing 777");
        Assert.assertThat((Object)boeing777, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        ((Graph.Batch)graph.batch().read("/Aircraft/Commercial/Boeing 777").and()).read("/Aircraft/Commercial/Boeing 787").execute();
    }
}

