/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.xml.XmlHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlHandlerTest {
    private static final String NT_NAMESPACE_URI = "http://www.jcp.org/jcr/nt/1.0";
    private XmlHandler handler;
    private ExecutionContext context;
    private Destination destination;
    private boolean skipRootElement = false;
    private Path parentPath;
    private TextDecoder decoder;
    private Name nameAttribute;
    private Name typeAttribute;
    private Name typeAttributeValue;
    private XmlHandler.AttributeScoping scoping;
    private LinkedList<CreateNodeRequest> requests;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", NT_NAMESPACE_URI);
        this.destination = new RecordingDestination();
        this.parentPath = (Path)this.context.getValueFactories().getPathFactory().create("/a/b");
        this.decoder = null;
        this.nameAttribute = JcrLexicon.NAME;
        this.typeAttribute = null;
        this.typeAttributeValue = null;
        this.scoping = XmlHandler.AttributeScoping.USE_DEFAULT_NAMESPACE;
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotConstructInstanceWhenGivenNullDestination() {
        this.destination = null;
        new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
    }

    @Test
    public void shouldUseDefaultDecoderIfNoneIsProvidedInConstructor() {
        this.decoder = null;
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        Assert.assertThat((Object)this.handler.destination, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.destination)));
        Assert.assertThat((Object)this.handler.currentPath, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parentPath)));
        Assert.assertThat((Object)this.handler.skipFirstElement, (Matcher)Is.is((Object)this.skipRootElement));
        Assert.assertThat((Object)this.handler.decoder, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)XmlHandler.DEFAULT_DECODER)));
        Assert.assertThat((Object)this.handler.nameAttribute, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.nameAttribute)));
    }

    @Test
    public void shouldUseDecoderProvidedInConstructor() {
        this.decoder = new Jsr283Encoder();
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        Assert.assertThat((Object)this.handler.destination, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.destination)));
        Assert.assertThat((Object)this.handler.currentPath, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parentPath)));
        Assert.assertThat((Object)this.handler.skipFirstElement, (Matcher)Is.is((Object)this.skipRootElement));
        Assert.assertThat((Object)this.handler.decoder, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.decoder)));
        Assert.assertThat((Object)this.handler.nameAttribute, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.nameAttribute)));
    }

    @Test
    public void shouldPlaceContentUnderRootIfNoPathIsProvidedInConstructor() {
        this.parentPath = null;
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        Assert.assertThat((Object)this.handler.destination, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.destination)));
        Assert.assertThat((Object)this.handler.currentPath.isRoot(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.handler.skipFirstElement, (Matcher)Is.is((Object)this.skipRootElement));
        Assert.assertThat((Object)this.handler.decoder, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)(this.decoder != null ? this.decoder : XmlHandler.DEFAULT_DECODER))));
        Assert.assertThat((Object)this.handler.nameAttribute, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.nameAttribute)));
    }

    @Test
    public void shouldNotLookForNameAttributeIfNoneIsProvidedInConstructor() {
        this.nameAttribute = null;
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        Assert.assertThat((Object)this.handler.destination, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.destination)));
        Assert.assertThat((Object)this.handler.currentPath, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parentPath)));
        Assert.assertThat((Object)this.handler.skipFirstElement, (Matcher)Is.is((Object)this.skipRootElement));
        Assert.assertThat((Object)this.handler.decoder, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)(this.decoder != null ? this.decoder : XmlHandler.DEFAULT_DECODER))));
        Assert.assertThat((Object)this.handler.nameAttribute, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseXmlDocumentWithoutNamespaces() throws IOException, SAXException {
        System.out.println("\n");
        System.out.flush();
        this.parse("xmlHandler/docWithoutNamespaces.xml");
        System.out.println("\n");
        System.out.flush();
        this.assertNode("Cars", new String[0]);
        this.assertNode("Cars/Hybrid", new String[0]);
        this.assertNode("Cars/Hybrid/car", "name=Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertNode("Cars/Hybrid/car", "name=Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertNode("Cars/Hybrid/car", "name=Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertNode("Cars/Sports", new String[0]);
        this.assertNode("Cars/Sports/car", "name=Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertNode("Cars/Sports/car", "name=Infiniti G37", "maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithNamespaces() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("xmlHandler/docWithNamespaces.xml");
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithNestedNamespaceDeclarations() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.context.getNamespaceRegistry().register("i", "http://attributes.com");
        this.parse("xmlHandler/docWithNestedNamespaces.xml");
        this.assertNode("Cars", new String[0]);
        this.assertNode("Cars/c:Hybrid", new String[0]);
        this.assertNode("Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("Cars/Sports", new String[0]);
        this.assertNode("Cars/Sports/Aston Martin DB9", "i:maker=Aston Martin", "model=DB9");
        this.assertNode("Cars/Sports/Infiniti G37", "i:maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithNamespacePrefixesThatDoNotMatchRegistry() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("xmlHandler/docWithNamespaces.xml");
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithNamespacesThatAreNotYetInRegistry() throws IOException, SAXException {
        NamespaceRegistry reg = this.context.getNamespaceRegistry();
        reg.unregister("http://www.jcp.org/jcr/1.0");
        reg.unregister(NT_NAMESPACE_URI);
        Assert.assertThat((Object)reg.getPrefixForNamespaceUri("http://www.jcp.org/jcr/1.0", false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)reg.getPrefixForNamespaceUri(NT_NAMESPACE_URI, false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)reg.getPrefixForNamespaceUri("http://default.namespace.com", false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.parse("xmlHandler/docWithNestedNamespaces.xml");
        String c = reg.getPrefixForNamespaceUri("http://default.namespace.com", false);
        String i = reg.getPrefixForNamespaceUri("http://attributes.com", false);
        String d = reg.getPrefixForNamespaceUri(reg.getDefaultNamespaceUri(), false);
        Assert.assertThat((String)"Namespace not properly registered in primary registry", (Object)c, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)"Namespace not properly registered in primary registry", (Object)d, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)"Namespace not properly registered in primary registry", (Object)i, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        if (c.length() != 0) {
            c = c + ":";
        }
        if (d.length() != 0) {
            d = d + ":";
        }
        if (i.length() != 0) {
            i = i + ":";
        }
        this.assertNode(d + "Cars", new String[0]);
        this.assertNode(d + "Cars/" + c + "Hybrid", new String[0]);
        this.assertNode(d + "Cars/" + c + "Hybrid/" + c + "Toyota Prius", c + "maker=Toyota", c + "model=Prius");
        this.assertNode(d + "Cars/" + c + "Hybrid/" + c + "Toyota Highlander", c + "maker=Toyota", c + "model=Highlander");
        this.assertNode(d + "Cars/" + c + "Hybrid/" + c + "Nissan Altima", c + "maker=Nissan", c + "model=Altima");
        this.assertNode(d + "Cars/" + d + "Sports", new String[0]);
        this.assertNode(d + "Cars/" + d + "Sports/Aston Martin DB9", i + "maker=Aston Martin", "model=DB9");
        this.assertNode(d + "Cars/" + d + "Sports/Infiniti G37", i + "maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldParseXmlDocumentThatUsesNameAttribute() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("xmlHandler/docWithNamespaces.xml");
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithoutDefaultNamespaceThatUsesNameAttribute() throws IOException, SAXException {
        this.parse("xmlHandler/docWithNamespacesWithoutDefault.xml");
        this.assertNode("Cars", new String[0]);
        this.assertNode("Cars/Hybrid", new String[0]);
        this.assertNode("Cars/Hybrid/Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertNode("Cars/Hybrid/Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertNode("Cars/Hybrid/Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertNode("Cars/Sports", new String[0]);
        this.assertNode("Cars/Sports/Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertNode("Cars/Sports/Infiniti G37", "maker=Infiniti", "model=G37");
    }

    @Test
    public void shouldParseXmlDocumentThatContainsNoContent() throws IOException, SAXException {
        this.parse("xmlHandler/docWithOnlyRootElement.xml");
        this.assertNode("Cars", new String[0]);
    }

    @Test
    public void shouldParseXmlDocumentAndShouldNotCreateNodeForRootElement() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parentPath = null;
        this.skipRootElement = true;
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        this.parse("xmlHandler/docWithNamespaces.xml");
        this.assertNode("c:Hybrid", new String[0]);
        this.assertNode("c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Sports", new String[0]);
        this.assertNode("c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentAndShouldPlaceContentUnderNonRootNode() throws IOException, SAXException {
        this.parentPath = (Path)this.context.getValueFactories().getPathFactory().create("/a/b");
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("xmlHandler/docWithNamespaces.xml");
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentAndShouldPlaceContentUnderRootNode() throws IOException, SAXException {
        this.parentPath = null;
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("xmlHandler/docWithNamespaces.xml");
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithXmlComments() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("xmlHandler/docWithComments.xml");
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
    }

    @Test
    public void shouldParseXmlDocumentWithoutNamespacesUsingTypeAttributeValue() throws IOException, SAXException {
        this.typeAttribute = JcrLexicon.PRIMARY_TYPE;
        this.typeAttributeValue = (Name)this.context.getValueFactories().getNameFactory().create("nt:unstructured");
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        this.parse("xmlHandler/docWithoutNamespaces.xml");
        String unstructPrimaryType = "jcr:primaryType={http://www.jcp.org/jcr/nt/1.0}unstructured";
        this.assertNode("Cars", new String[0]);
        this.assertNode("Cars/Hybrid", new String[0]);
        this.assertNode("Cars/Hybrid/car", unstructPrimaryType, "name=Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertNode("Cars/Hybrid/car", unstructPrimaryType, "name=Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertNode("Cars/Hybrid/car", unstructPrimaryType, "name=Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertProperties("Cars/Hybrid", unstructPrimaryType);
        this.assertNode("Cars/Sports", new String[0]);
        this.assertNode("Cars/Sports/car", unstructPrimaryType, "name=Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertNode("Cars/Sports/car", unstructPrimaryType, "name=Infiniti G37", "maker=Infiniti", "model=G37");
        this.assertProperties("Cars/Sports", unstructPrimaryType);
        this.assertProperties("Cars", unstructPrimaryType);
    }

    @Test
    public void shouldParseXmlDocumentWithNamespacesUsingTypeAttributeValue() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.typeAttribute = JcrLexicon.PRIMARY_TYPE;
        this.typeAttributeValue = (Name)this.context.getValueFactories().getNameFactory().create("nt:unstructured");
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        this.parse("xmlHandler/docWithNamespaces.xml");
        String unstructPrimaryType = "jcr:primaryType={http://www.jcp.org/jcr/nt/1.0}unstructured";
        String carPrimaryType = "jcr:primaryType={http://default.namespace.com}car";
        this.assertNode("c:Cars", new String[0]);
        this.assertNode("c:Cars/c:Hybrid", new String[0]);
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Prius", carPrimaryType, "c:maker=Toyota", "c:model=Prius");
        this.assertNode("c:Cars/c:Hybrid/c:Toyota Highlander", carPrimaryType, "c:maker=Toyota", "c:model=Highlander");
        this.assertNode("c:Cars/c:Hybrid/c:Nissan Altima", carPrimaryType, "c:maker=Nissan", "c:model=Altima");
        this.assertProperties("c:Cars/c:Hybrid", unstructPrimaryType);
        this.assertNode("c:Cars/c:Sports", new String[0]);
        this.assertNode("c:Cars/c:Sports/c:Aston Martin DB9", carPrimaryType, "c:maker=Aston Martin", "c:model=DB9");
        this.assertNode("c:Cars/c:Sports/c:Infiniti G37", carPrimaryType, "c:maker=Infiniti", "c:model=G37");
        this.assertProperties("c:Cars/c:Sports", unstructPrimaryType);
        this.assertProperties("c:Cars", unstructPrimaryType);
    }

    @Test
    public void shouldParseXmlDocumentWithNestedPropertiesShouldPlaceContentUnderRootNode() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.handler = new XmlHandler(this.destination, this.skipRootElement, this.parentPath, this.decoder, this.nameAttribute, this.typeAttribute, this.typeAttributeValue, this.scoping);
        this.parse("xmlHandler/docWithNestedProperties.xml");
        this.assertNode("Cars", new String[0]);
        this.assertNode("Cars/Hybrid", new String[0]);
        this.assertNode("Cars/Hybrid/car", "name=Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertNode("Cars/Hybrid/car", "name=Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertNode("Cars/Hybrid/car", new String[0]);
        this.assertProperties("Cars/Hybrid/car", "name=Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertNode("Cars/Sports", new String[0]);
        this.assertNode("Cars/Sports/car", "name=Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertNode("Cars/Sports/car", new String[0]);
        this.assertNode("Cars/Sports/car/driver", "name=Tony Stewart");
        this.assertProperties("Cars/Sports/car", "name=Infiniti G37", "maker=Infiniti", "model=G37", "category=Turbocharged=My Sedan");
        this.assertNode("Cars/Sports/car", new String[0]);
        this.assertNode("Cars/Sports/car/jcr:xmltext", "jcr:xmlcharacters=This is my text ");
        this.assertNode("Cars/Sports/car/jcr:xmltext", "jcr:xmlcharacters=that should be merged");
        this.assertProperties("Cars/Sports/car", "name=Infiniti G37", "maker=Infiniti", "model=G37");
    }

    protected void assertNode(String path, String ... properties) {
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path expectedPath = this.parentPath != null ? factory.create(this.parentPath, path) : (Path)factory.create("/" + path);
        CreateNodeRequest request = this.requests.remove();
        Path parentPath = request.under().getPath();
        Assert.assertThat((Object)parentPath, (Matcher)Is.is((Object)expectedPath.getParent()));
        Assert.assertThat((Object)request.named(), (Matcher)Is.is((Object)expectedPath.getLastSegment().getName()));
        if (properties.length != 0) {
            HashMap<Name, Property> expectedProperties = new HashMap<Name, Property>();
            for (String propertyString : properties) {
                String[] strings = propertyString.split("=");
                if (strings.length < 2) continue;
                Name name = (Name)this.context.getValueFactories().getNameFactory().create(strings[0]);
                Object[] values = new Object[strings.length - 1];
                for (int i = 1; i != strings.length; ++i) {
                    values[i - 1] = strings[i];
                }
                Property property = this.context.getPropertyFactory().create(name, values);
                expectedProperties.put(name, property);
            }
            for (Property actual : request.properties()) {
                Property expected = (Property)expectedProperties.remove(actual.getName());
                Assert.assertThat((String)("unexpected property: " + actual), (Object)expected, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
            }
            if (!expectedProperties.isEmpty()) {
                StringBuilder msg = new StringBuilder("missing actual properties: ");
                boolean isFirst = true;
                for (Property expected : expectedProperties.values()) {
                    if (!isFirst) {
                        msg.append(", ");
                    } else {
                        isFirst = false;
                    }
                    msg.append(expected.getName());
                }
                msg.append(" on node ").append(request.under());
                System.out.println("Found properties: " + request.properties());
                Assert.assertThat((String)msg.toString(), (Object)expectedProperties.isEmpty(), (Matcher)Is.is((Object)true));
            }
        }
    }

    protected void assertProperties(String path, String ... properties) {
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path expectedPath = this.parentPath != null ? factory.create(this.parentPath, path) : (Path)factory.create("/" + path);
        HashMap<Name, Property> expectedProperties = new HashMap<Name, Property>();
        for (String propertyString : properties) {
            String[] strings = propertyString.split("=");
            if (strings.length < 2) continue;
            Name name = (Name)this.context.getValueFactories().getNameFactory().create(strings[0]);
            Object[] values = new Object[strings.length - 1];
            for (int i = 1; i != strings.length; ++i) {
                values[i - 1] = strings[i];
            }
            Property property = this.context.getPropertyFactory().create(name, values);
            expectedProperties.put(name, property);
        }
        CreateNodeRequest propertyRequest = this.requests.remove();
        Path parentPath = propertyRequest.under().getPath();
        Assert.assertThat((Object)parentPath, (Matcher)Is.is((Object)expectedPath.getParent()));
        Assert.assertThat((Object)propertyRequest.named(), (Matcher)Is.is((Object)expectedPath.getLastSegment().getName()));
        for (Property actual : propertyRequest.properties()) {
            Property expected = (Property)expectedProperties.remove(actual.getName());
            Assert.assertThat((String)("unexpected property: " + actual), (Object)expected, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        }
        if (!expectedProperties.isEmpty()) {
            StringBuilder msg = new StringBuilder("missing actual properties: ");
            boolean isFirst = true;
            for (Property expected : expectedProperties.values()) {
                if (!isFirst) {
                    msg.append(", ");
                } else {
                    isFirst = false;
                }
                msg.append(expected.getName());
            }
            msg.append(" on node ").append(propertyRequest.under());
            System.out.println("Found properties: " + propertyRequest.properties());
            Assert.assertThat((String)msg.toString(), (Object)expectedProperties.isEmpty(), (Matcher)Is.is((Object)true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(String relativePathToXmlFile) throws IOException, SAXException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(relativePathToXmlFile);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler((ContentHandler)this.handler);
            reader.setErrorHandler((ErrorHandler)this.handler);
            reader.parse(new InputSource(stream));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RecordingDestination
    implements Destination {
        private final LinkedList<CreateNodeRequest> requests = new LinkedList();
        private final String workspace = "Recording Workspace";

        protected RecordingDestination() {
        }

        public void create(Path path, List<Property> properties) {
            assert (path != null);
            Path parent = path.getParent();
            Name child = path.getLastSegment().getName();
            this.requests.add(new CreateNodeRequest(Location.create((Path)parent), "Recording Workspace", child, properties));
        }

        public void create(Path path, final Property firstProperty, final Property ... additionalProperties) {
            Path parent = path.getParent();
            Name child = path.getLastSegment().getName();
            Location location = Location.create((Path)parent);
            if (firstProperty == null) {
                this.requests.add(new CreateNodeRequest(location, "Recording Workspace", child, new Property[0]));
            } else if (additionalProperties == null || additionalProperties.length == 0) {
                this.requests.add(new CreateNodeRequest(location, "Recording Workspace", child, new Property[]{firstProperty}));
            } else {
                Iterator<Property> iter = new Iterator<Property>(){
                    private int index = -1;

                    @Override
                    public boolean hasNext() {
                        return this.index < additionalProperties.length;
                    }

                    @Override
                    public Property next() {
                        if (this.index == -1) {
                            ++this.index;
                            return firstProperty;
                        }
                        return additionalProperties[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                this.requests.add(new CreateNodeRequest(location, "Recording Workspace", child, (Iterator)iter));
            }
        }

        public void setProperties(Path path, Property ... properties) {
            if (properties.length == 0) {
                return;
            }
            if (properties.length == 1) {
                this.create(path, properties[0], new Property[0]);
            } else {
                Property[] additionalProperties = new Property[properties.length - 1];
                System.arraycopy(properties, 1, additionalProperties, 0, properties.length - 1);
                this.create(path, properties[0], additionalProperties);
            }
        }

        public ExecutionContext getExecutionContext() {
            return XmlHandlerTest.this.context;
        }

        public void submit() {
            XmlHandlerTest.this.requests = this.requests;
        }
    }
}

