/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.AbstractProjectorTest;
import org.modeshape.graph.connector.federation.BranchedMirrorProjector;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.ProxyNode;

public class BranchedMirrorProjectorTest
extends AbstractProjectorTest<BranchedMirrorProjector> {
    private String mirrorSourceName;
    private String mirrorWorkspaceName;
    private String branchSourceName;
    private String branchWorkspaceName;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.mirrorSourceName = "source1";
        this.mirrorWorkspaceName = "workspace1";
        this.branchSourceName = "source2";
        this.branchWorkspaceName = "workspace2";
        this.addProjection(this.mirrorSourceName, this.mirrorWorkspaceName, "/ => /");
        this.addProjection(this.branchSourceName, this.branchWorkspaceName, "/system => /system");
        this.projector = BranchedMirrorProjector.with((ExecutionContext)this.context, (List)this.projections);
    }

    protected void assertProjectedIntoMirror(String federatedPath) {
        Location location = this.location(federatedPath);
        ProjectedNode node = ((BranchedMirrorProjector)this.projector).project(this.context, location, false);
        Assert.assertThat((Object)node.isProxy(), Is.is(true));
        ProxyNode proxy = node.asProxy();
        Assert.assertThat((Object)proxy.location(), Is.is(location));
        Assert.assertThat((Object)proxy.source(), Is.is(this.mirrorSourceName));
        Assert.assertThat((Object)proxy.workspaceName(), Is.is(this.mirrorWorkspaceName));
        Assert.assertThat((Object)proxy.hasNext(), Is.is(false));
    }

    protected void assertProjectedIntoBranch(String federatedPath) {
        this.assertProjectedIntoBranch(federatedPath, federatedPath);
    }

    protected void assertProjectedIntoBranch(String federatedPath, String expectedPathInSource) {
        Location location = this.location(federatedPath);
        ProjectedNode node = ((BranchedMirrorProjector)this.projector).project(this.context, location, false);
        Assert.assertThat((Object)node.isProxy(), Is.is(true));
        ProxyNode proxy = node.asProxy();
        Assert.assertThat((Object)proxy.source(), Is.is(this.branchSourceName));
        Assert.assertThat((Object)proxy.workspaceName(), Is.is(this.branchWorkspaceName));
        Assert.assertThat((Object)proxy.location().getPath(), Is.is(this.path(expectedPathInSource)));
        Assert.assertThat((Object)proxy.hasNext(), Is.is(false));
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationInMirrorSource() {
        this.assertProjectedIntoMirror("/a");
        this.assertProjectedIntoMirror("/a/b/c/d");
        this.assertProjectedIntoMirror("/system[2]/b/c/d");
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationInBranchOnlyOneLevelDeepWithOneForOneMapping() {
        this.assertProjectedIntoBranch("/system");
        this.assertProjectedIntoBranch("/system[1]");
        this.assertProjectedIntoBranch("/system/d");
        this.assertProjectedIntoBranch("/system[1]/d");
    }

    @Test
    public void shouldReturnForRootLocationAProxyForMirrorAndPlaceholderForBranch() {
        Location location = this.location("/");
        ProjectedNode node = ((BranchedMirrorProjector)this.projector).project(this.context, location, false);
        Assert.assertThat((Object)node.isProxy(), Is.is(true));
        ProxyNode proxy = node.asProxy();
        Assert.assertThat((Object)proxy.source(), Is.is(this.mirrorSourceName));
        Assert.assertThat((Object)proxy.workspaceName(), Is.is(this.mirrorWorkspaceName));
        Assert.assertThat((Object)proxy.location().getPath(), Is.is(this.path("/")));
        Assert.assertThat((Object)proxy.hasNext(), Is.is(true));
        ProjectedNode next = node.next();
        Assert.assertThat((Object)next.isPlaceholder(), Is.is(true));
        PlaceholderNode placeholder = next.asPlaceholder();
        Assert.assertThat((Object)placeholder.isPlaceholder(), Is.is(true));
        Assert.assertThat((Object)placeholder.location().getPath(), Is.is(this.path("/")));
        Assert.assertThat((Object)placeholder.children().size(), Is.is(1));
        Assert.assertThat((Object)((ProjectedNode)placeholder.children().get(0)).location().getPath(), Is.is(this.path("/system")));
        Assert.assertThat((Object)placeholder.hasNext(), Is.is(false));
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationInBranchMultipleLevelsDeepWithOneForOneMapping() {
        this.projections.clear();
        this.addProjection(this.mirrorSourceName, this.mirrorWorkspaceName, "/ => /");
        this.addProjection(this.branchSourceName, this.branchWorkspaceName, "/a/b/c => /a/b/c");
        this.projector = BranchedMirrorProjector.with((ExecutionContext)this.context, (List)this.projections);
        this.assertProjectedIntoBranch("/a/b/c");
        this.assertProjectedIntoBranch("/a/b/c/d");
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationInBranchMultipleLevelsDeepWithDissimilarMapping() {
        this.projections.clear();
        this.addProjection(this.mirrorSourceName, this.mirrorWorkspaceName, "/ => /");
        this.addProjection(this.branchSourceName, this.branchWorkspaceName, "/a/b/c => /d/e");
        this.projector = BranchedMirrorProjector.with((ExecutionContext)this.context, (List)this.projections);
        this.assertProjectedIntoBranch("/a/b/c", "/d/e");
        this.assertProjectedIntoBranch("/a/b/c/f", "/d/e/f");
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationInBranchMultipleLevelsDeepWithRootMapping() {
        this.projections.clear();
        this.addProjection(this.mirrorSourceName, this.mirrorWorkspaceName, "/ => /");
        this.addProjection(this.branchSourceName, this.branchWorkspaceName, "/a/b/c => /");
        this.projector = BranchedMirrorProjector.with((ExecutionContext)this.context, (List)this.projections);
        this.assertProjectedIntoBranch("/a/b/c", "/");
        this.assertProjectedIntoBranch("/a/b/c/f", "/f");
    }
}

