/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.verification.api.VerificationMode;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRepositoryConnection;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.Request;

public class FederatedRepositoryConnectionTest {
    private FederatedRepositoryConnection connection;
    @Mock
    private FederatedRepository repository;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.connection = new FederatedRepositoryConnection(this.repository, null);
    }

    @Test
    public void shouldHaveRepository() {
        Assert.assertThat((Object)this.connection.getRepository(), Is.is(this.repository));
    }

    @Test
    public void shouldHaveNoXaResource() {
        Assert.assertThat((Object)this.connection.getXAResource(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldGetDefaultCachePolicyFromRepository() {
        CachePolicy cachePolicy = (CachePolicy)Mockito.mock(CachePolicy.class);
        Mockito.when((Object)this.repository.getDefaultCachePolicy()).thenReturn((Object)cachePolicy);
        Assert.assertThat((Object)this.connection.getDefaultCachePolicy(), Is.is(cachePolicy));
        ((FederatedRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).getDefaultCachePolicy();
    }

    @Test
    public void shouldGetSourceNameFromRepository() {
        String name = "Something";
        Mockito.when((Object)this.repository.getSourceName()).thenReturn((Object)name);
        Assert.assertThat((Object)this.connection.getSourceName(), Is.is(name));
        ((FederatedRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).getSourceName();
    }

    @Test
    public void shouldProcessNonCompositeRequestSynchronously() {
        Request request = (Request)Mockito.mock(Request.class);
        Assert.assertThat((Object)this.connection.shouldProcessSynchronously(request), Is.is(true));
    }

    @Test
    public void shouldProcessCompositeRequestWithOneRequestSynchronously() {
        CompositeRequest request = (CompositeRequest)Mockito.mock(CompositeRequest.class);
        Mockito.when((Object)request.size()).thenReturn((Object)1);
        Assert.assertThat((Object)this.connection.shouldProcessSynchronously((Request)request), Is.is(true));
    }

    @Ignore
    @Test
    public void shouldProcessCompositeRequestWithMultipleRequestsAsynchronously() {
        CompositeRequest request = (CompositeRequest)Mockito.mock(CompositeRequest.class);
        Mockito.when((Object)request.size()).thenReturn((Object)2);
        Assert.assertThat((Object)this.connection.shouldProcessSynchronously((Request)request), Is.is(false));
    }

    @Test
    public void shouldAllowCloseToBeCalledRepeatedly() {
        for (int i = 0; i != 10; ++i) {
            this.connection.close();
        }
    }
}

