/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import java.util.Set;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.federation.AbstractFederatedRepositorySourceIntegrationTest;

public class FederatedRepositorySourceUsingMirrorAndBranchProjectionsTest
extends AbstractFederatedRepositorySourceIntegrationTest {
    private String mirrorSourceName;
    private String mirrorWorkspaceName;
    private String branchSourceName;
    private String branchWorkspaceName;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.mirrorSourceName = "Mirror Source";
        this.mirrorWorkspaceName = "Mirror Workspace";
        this.addProjection("fedSpace", "Mirror Projection", this.mirrorSourceName, this.mirrorWorkspaceName, "/ => /");
        this.branchSourceName = this.mirrorSourceName;
        this.branchWorkspaceName = "Branch Workspace";
        this.addProjection("fedSpace", "Branch Projection", this.branchSourceName, this.branchWorkspaceName, "/Aircraft => /Aircraft");
        Graph source = this.graphFor(this.mirrorSourceName, this.mirrorWorkspaceName);
        source.importXmlFrom(this.getClass().getClassLoader().getResource("cars.xml").toURI()).into("/");
        Graph branch = this.graphFor(this.branchSourceName, this.branchWorkspaceName);
        branch.importXmlFrom(this.getClass().getClassLoader().getResource("aircraft.xml").toURI()).into("/");
    }

    protected void assertMirrorNode(String pathToNode) {
        this.assertSameNode(pathToNode, pathToNode, this.mirrorSourceName, this.mirrorWorkspaceName, new String[0]);
    }

    protected void assertBranchNode(String pathToNode) {
        Assert.assertThat((Object)pathToNode.startsWith("/Aircraft"), Is.is(true));
        this.assertSameNode(pathToNode, pathToNode, this.branchSourceName, this.branchWorkspaceName, new String[0]);
    }

    protected void assertNoNode(String pathToNode) {
        this.assertNoNode(pathToNode, pathToNode, this.mirrorSourceName, this.mirrorWorkspaceName);
        this.assertNoNode(pathToNode, pathToNode, this.branchSourceName, this.branchWorkspaceName);
    }

    @Test
    public void shouldListAllFederatedWorkspaces() {
        Set workspaces = this.federated.getWorkspaces();
        Assert.assertThat((Object)workspaces.contains("fedSpace"), Is.is(true));
        Assert.assertThat((Object)workspaces.size(), Is.is(1));
    }

    @Test
    public void shouldReturnRootNodeInMirrorProjection() {
        Graph mirrorGraph = this.graphFor(this.mirrorSourceName, this.mirrorWorkspaceName);
        Node mirrorRoot = mirrorGraph.getNodeAt("/");
        Location mirrorRootLocation = mirrorRoot.getLocation();
        Assert.assertThat((Object)mirrorRootLocation.hasIdProperties(), Is.is(true));
        Assert.assertThat((Object)mirrorRootLocation.getUuid(), Is.is(IsNull.notNullValue()));
        Node fedRoot = this.federated.getNodeAt("/");
        Location fedRootLocation = fedRoot.getLocation();
        Assert.assertThat((Object)fedRootLocation.hasIdProperties(), Is.is(true));
        Assert.assertThat((Object)fedRootLocation.getUuid(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)fedRootLocation.getUuid(), Is.is(mirrorRootLocation.getUuid()));
    }

    @Test
    public void shouldReturnRootNodeInBranchProjection() {
        Graph branchGraph = this.graphFor(this.branchSourceName, this.branchWorkspaceName);
        Node branchNode = branchGraph.getNodeAt("/Aircraft");
        Location branchNodeLocation = branchNode.getLocation();
        Assert.assertThat((Object)branchNodeLocation.hasIdProperties(), Is.is(true));
        Assert.assertThat((Object)branchNodeLocation.getUuid(), Is.is(IsNull.notNullValue()));
        Node fedNode = this.federated.getNodeAt("/Aircraft");
        Location fedNodeLocation = fedNode.getLocation();
        Assert.assertThat((Object)fedNodeLocation.hasIdProperties(), Is.is(true));
        Assert.assertThat((Object)fedNodeLocation.getUuid(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)fedNodeLocation.getUuid(), Is.is(branchNodeLocation.getUuid()));
    }

    @Test
    public void shouldFederateRootNodeFromMirrorAndBranch() {
        this.assertSameNode("/", "/", this.mirrorSourceName, this.mirrorWorkspaceName, "Aircraft");
    }

    @Test
    public void shouldFederateNodesInMirrorSource() {
        this.assertMirrorNode("/Cars");
        this.assertMirrorNode("/Cars/Hybrid");
        this.assertMirrorNode("/Cars/Hybrid/Toyota Prius");
        this.assertMirrorNode("/Cars/Hybrid/Toyota Highlander");
        this.assertMirrorNode("/Cars/Hybrid/Nissan Altima");
        this.assertMirrorNode("/Cars/Sports/Aston Martin DB9");
        this.assertMirrorNode("/Cars/Sports/Infiniti G37");
        this.assertMirrorNode("/Cars/Luxury/Cadillac DTS");
        this.assertMirrorNode("/Cars/Luxury/Bentley Continental");
        this.assertMirrorNode("/Cars/Luxury/Lexus IS350");
        this.assertMirrorNode("/Cars/Utility/Land Rover LR2");
        this.assertMirrorNode("/Cars/Utility/Land Rover LR3");
        this.assertMirrorNode("/Cars/Utility/Hummer H3");
        this.assertMirrorNode("/Cars/Utility/Ford F-150");
    }

    @Test
    public void shouldFederateNodesInBranchSource() {
        this.assertBranchNode("/Aircraft");
        this.assertBranchNode("/Aircraft/Business");
        this.assertBranchNode("/Aircraft/Business/Gulfstream V");
        this.assertBranchNode("/Aircraft/Business/Learjet 45");
    }

    @Test
    public void shouldPerformBatchOperationsAgainstFederatedSource() {
        this.assertReadUsingBatch("/Aircraft", "/Aircraft/Business", "/Cars");
    }

    @Test
    public void shouldCreateNodeUnderRootInMirrorSource() {
        this.federated.createAt("/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertMirrorNode("/Hovercraft");
        this.assertSameNode("/", "/", this.mirrorSourceName, this.mirrorWorkspaceName, "Aircraft");
    }

    @Test
    public void shouldCreateNodeWellBelowRootInMirrorSource() {
        this.federated.createAt("/Cars/Hybrid/MyNewHybrid").with("prop1", new Object[]{"value1"}).and();
        this.assertMirrorNode("/Cars/Hybrid/MyNewHybrid");
        this.assertMirrorNode("/Cars/Hybrid");
    }

    @Test
    public void shouldCreateNodeUnderRootInBranchSource() {
        this.federated.createAt("/Aircraft/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertBranchNode("/Aircraft/Hovercraft");
        this.assertBranchNode("/Aircraft");
    }

    @Test
    public void shouldCreateNodeWellBelowRootInBranchSource() {
        this.federated.createAt("/Aircraft/Business/HondaJet").with("prop1", new Object[]{"value1"}).and();
        this.assertBranchNode("/Aircraft/Business/HondaJet");
        this.assertBranchNode("/Aircraft/Business");
    }

    @Test
    public void shouldDeleteNodeUnderRootInMirrorSource() {
        this.federated.createAt("/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertMirrorNode("/Hovercraft");
        this.assertSameNode("/", "/", this.mirrorSourceName, this.mirrorWorkspaceName, "Aircraft");
        this.federated.delete("/Hovercraft");
        this.assertNoNode("/Hovercraft");
    }

    @Test
    public void shouldDeleteNodeWellBelowRootInMirrorSource() {
        this.federated.delete("/Cars/Luxury/Cadillac DTS");
        this.assertNoNode("/Cars/Luxury/Cadillac DTS");
        this.assertMirrorNode("/Cars/Luxury/Lexus IS350");
        this.assertMirrorNode("/Cars/Luxury");
    }

    @Test
    public void shouldDeleteNodeUnderRootInBranchSource() {
        this.federated.delete("/Aircraft/Business");
        this.assertNoNode("/Aircraft/Business");
        this.assertBranchNode("/Aircraft");
        this.assertBranchNode("/Aircraft/Commercial");
    }

    @Test
    public void shouldDeleteNodeWellBelowRootInBranchSource() {
        this.federated.delete("/Aircraft/Business/Learjet 45");
        this.assertNoNode("/Aircraft/Business/Learjet 45");
        this.assertBranchNode("/Aircraft/Business/Gulfstream V");
        this.assertBranchNode("/Aircraft/Business");
        this.assertBranchNode("/Aircraft/Commercial");
    }

    @Test
    public void shouldDeleteEverythingInMirrorAndOffsetIfDeletingRoot() {
        this.federated.delete("/");
        Assert.assertThat((Object)((List)this.federated.getChildren().of("/")).size(), Is.is(1));
        this.assertBranchNode("/Aircraft");
    }
}

