/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepository;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicPropertyFactory;
import org.modeshape.graph.request.CreateWorkspaceRequest;

public class InMemoryRepositoryTest {
    private InMemoryRepository repository;
    private String repositoryName;
    private UUID rootUuid;
    private ExecutionContext context;
    private PathFactory pathFactory;
    private NameFactory nameFactory;
    private PropertyFactory propertyFactory;

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        ValueFactories valueFactories = this.context.getValueFactories();
        this.pathFactory = valueFactories.getPathFactory();
        this.nameFactory = valueFactories.getNameFactory();
        this.propertyFactory = new BasicPropertyFactory(valueFactories);
        this.repositoryName = "Test repository";
        this.rootUuid = UUID.randomUUID();
        this.repository = new InMemoryRepository(this.repositoryName, this.rootUuid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNameInConstructor() {
        new InMemoryRepository(null, this.rootUuid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankNameInConstructor() {
        new InMemoryRepository("  \t  ", this.rootUuid);
    }

    @Test
    public void shouldHaveLock() {
        Assert.assertThat((Object)this.repository.getLock(), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldNotCreateWorkspaceIfNameIsAlreadyUsedAndConflictOptionIsToNotCreate() {
        String workspaceName = "New Workspace";
        Assert.assertThat((Object)this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName}));
        Assert.assertThat((Object)this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName}));
    }

    @Test
    public void shouldCreateWorkspaceWithUniqueNameIfSpecifiedNameIsAlreadyUsedAndConflictOptionIsToCreateWithAdjustedName() {
        String workspaceName = "New Workspace";
        Assert.assertThat((Object)this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName}));
        MapWorkspace secondWorkspace = this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        Assert.assertThat((Object)secondWorkspace, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName, secondWorkspace.getName()}));
    }

    @Test
    public void shouldNotDestroyWorkspaceIfNameDoesNotMatchExistingWorkspace() {
        String workspaceName = "New Workspace";
        Assert.assertThat((Object)this.repository.getWorkspaceNames().contains(workspaceName), Is.is(false));
        Assert.assertThat((Object)this.repository.destroyWorkspace(workspaceName), Is.is(false));
    }

    @Test
    public void shouldDestroyWorkspaceIfNameMatchesExistingWorkspace() {
        String workspaceName = "New Workspace";
        Assert.assertThat((Object)this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames().contains(workspaceName), Is.is(true));
        Assert.assertThat((Object)this.repository.destroyWorkspace(workspaceName), Is.is(true));
    }

    @Test
    public void shouldCloneWorkspaceAndCopyContentsIfWorkspaceWithSpecifiedNameExists() {
        String workspaceName = "Original Workspace";
        MapWorkspace workspace = this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
        Assert.assertThat((Object)workspace, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName}));
        MapNode root = workspace.getRoot();
        Set NO_PROPS = Collections.emptySet();
        MapNode node_a = workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, NO_PROPS);
        MapNode node_b = workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, NO_PROPS);
        MapNode node_c = workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, NO_PROPS);
        MapNode node_d = workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, NO_PROPS);
        MapNode node_e = workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, NO_PROPS);
        MapNode node_b2 = workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, NO_PROPS);
        ValueFactory stringFactory = this.context.getValueFactories().getStringFactory();
        Name propertyName = (Name)this.nameFactory.create("something");
        Property property = this.propertyFactory.create(propertyName, new Object[]{stringFactory.create("Worth the wait")});
        node_b.setProperty(property);
        Assert.assertThat((Object)((InMemoryRepository.Workspace)workspace).size(), Is.is(7));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(workspace.getRoot())));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        String newWorkspaceName = "New Workspace";
        MapWorkspace new_workspace = this.repository.createWorkspace(this.context, newWorkspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, workspaceName);
        Assert.assertThat((Object)new_workspace, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName, newWorkspaceName}));
        Assert.assertThat((Object)((InMemoryRepository.Workspace)workspace).size(), Is.is(7));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(workspace.getRoot())));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        Assert.assertThat((Object)((InMemoryRepository.Workspace)new_workspace).size(), Is.is(7));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/")).getUuid()));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/a")).getUuid()));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/a/b")).getUuid()));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b/c")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/a/b/c")).getUuid()));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/d")).getUuid()));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/e")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/d/e")).getUuid()));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/b")).getUuid(), Is.is(new_workspace.getNode((Path)this.pathFactory.create("/d/b")).getUuid()));
    }

    @Test
    public void shouldCloneWorkspaceButShouldNotCopyContentsIfWorkspaceWithSpecifiedNameDoesNotExist() {
        String workspaceName = "Original Workspace";
        MapWorkspace workspace = this.repository.createWorkspace(this.context, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
        Assert.assertThat((Object)workspace, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{workspaceName}));
        MapNode root = workspace.getRoot();
        Set NO_PROPS = Collections.emptySet();
        MapNode node_a = workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, NO_PROPS);
        MapNode node_b = workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, NO_PROPS);
        MapNode node_c = workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, NO_PROPS);
        MapNode node_d = workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, NO_PROPS);
        MapNode node_e = workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, NO_PROPS);
        MapNode node_b2 = workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, NO_PROPS);
        ValueFactory stringFactory = this.context.getValueFactories().getStringFactory();
        Name propertyName = (Name)this.nameFactory.create("something");
        Property property = this.propertyFactory.create(propertyName, new Object[]{stringFactory.create("Worth the wait")});
        node_b.setProperty(property);
        Assert.assertThat((Object)((InMemoryRepository.Workspace)workspace).size(), Is.is(7));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(workspace.getRoot())));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        String newWorkspaceName = "New Workspace";
        MapWorkspace new_workspace = this.repository.createWorkspace(this.context, newWorkspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, "non-existant workspace");
        Assert.assertThat((Object)new_workspace.getRoot(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_workspace.getRoot().getUuid(), Is.is(this.rootUuid));
        Assert.assertThat((Object)new_workspace.getRoot().getChildren().isEmpty(), Is.is(true));
    }
}

