/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepository;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicPropertyFactory;
import org.modeshape.graph.request.CreateWorkspaceRequest;

public class InMemoryRepositoryWorkspaceTest {
    private InMemoryRepository repository;
    private String repositoryName;
    private UUID rootUuid;
    private String workspaceName;
    private InMemoryRepository.Workspace workspace;
    private ExecutionContext context;
    private ValueFactories valueFactories;
    private PathFactory pathFactory;
    private NameFactory nameFactory;
    private PropertyFactory propertyFactory;
    private final Collection<Property> NO_PROPS = Collections.emptySet();

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.valueFactories = this.context.getValueFactories();
        this.pathFactory = this.valueFactories.getPathFactory();
        this.nameFactory = this.valueFactories.getNameFactory();
        this.propertyFactory = new BasicPropertyFactory(this.valueFactories);
        this.repositoryName = "Test repository";
        this.rootUuid = UUID.randomUUID();
        this.repository = new InMemoryRepository(this.repositoryName, this.rootUuid);
        this.workspaceName = "My Workspace";
        this.workspace = (InMemoryRepository.Workspace)this.repository.createWorkspace(this.context, this.workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
    }

    @Test
    public void shouldHaveRootNodeAfterInstantiating() {
        Assert.assertThat((Object)this.workspace.getRoot(), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveNameAfterInstantiating() {
        Assert.assertThat((Object)this.workspace.getName(), Is.is(this.workspaceName));
    }

    @Test
    public void shouldHaveRootNodeWithRootUuid() {
        Assert.assertThat((Object)this.workspace.getRoot().getUuid(), Is.is(this.rootUuid));
    }

    @Test
    public void shouldAllowRootToBeRemoved() {
        this.workspace.removeNode(this.context, this.workspace.getRoot());
        Assert.assertThat((Object)this.workspace.getRoot().getChildren().size(), Is.is(0));
    }

    @Test
    public void shouldCreateNodesByPath() {
        Name name_a = (Name)this.nameFactory.create("a");
        MapNode node_a = this.workspace.createNode(this.context, this.workspace.getRoot(), name_a, null, this.NO_PROPS);
        Assert.assertThat((Object)node_a, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_a.getParent(), Is.is(this.workspace.getRoot()));
        Assert.assertThat((Object)node_a.getName().getName(), Is.is(name_a));
        Assert.assertThat((Object)node_a.getName().hasIndex(), Is.is(false));
        Name name_b = (Name)this.nameFactory.create("b");
        MapNode node_b = this.workspace.createNode(this.context, node_a, name_b, null, this.NO_PROPS);
        Assert.assertThat((Object)node_b, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_b.getParent(), Is.is(node_a));
        Assert.assertThat((Object)node_b.getName().getName(), Is.is(name_b));
        Assert.assertThat((Object)node_b.getName().hasIndex(), Is.is(false));
        Name name_c = (Name)this.nameFactory.create("c");
        MapNode node_c = this.workspace.createNode(this.context, node_b, name_c, null, this.NO_PROPS);
        Assert.assertThat((Object)node_c, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_c.getParent(), Is.is(node_b));
        Assert.assertThat((Object)node_c.getName().getName(), Is.is(name_c));
        Assert.assertThat((Object)node_c.getName().hasIndex(), Is.is(false));
        Assert.assertThat((Object)this.workspace.size(), Is.is(4));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
    }

    @Test
    public void shouldNotFindNodesThatDoNotExist() {
        MapNode node_a = this.workspace.createNode(this.context, this.workspace.getRoot(), (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        Assert.assertThat((Object)this.workspace.size(), Is.is(4));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(node_a));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(node_b));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a[1]")), Is.is(node_a));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b[1]")), Is.is(node_b));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a[1]/b[1]")), Is.is(node_b));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a[2]")), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/b[2]")), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldCorrectlyManageIndexesOfSiblingsWithSameNames() {
        Name name_a1 = (Name)this.nameFactory.create("a");
        MapNode node_a1 = this.workspace.createNode(this.context, this.workspace.getRoot(), name_a1, null, this.NO_PROPS);
        Assert.assertThat((Object)node_a1, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_a1.getParent(), Is.is(this.workspace.getRoot()));
        Assert.assertThat((Object)node_a1.getName().getName(), Is.is(name_a1));
        Assert.assertThat((Object)node_a1.getName().hasIndex(), Is.is(false));
        Name name_a2 = (Name)this.nameFactory.create("a");
        MapNode node_a2 = this.workspace.createNode(this.context, this.workspace.getRoot(), name_a2, null, this.NO_PROPS);
        Assert.assertThat((Object)node_a2, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_a2.getParent(), Is.is(this.workspace.getRoot()));
        Assert.assertThat((Object)node_a2.getName().getName(), Is.is(name_a2));
        Assert.assertThat((Object)node_a2.getName().hasIndex(), Is.is(true));
        Assert.assertThat((Object)node_a2.getName().getIndex(), Is.is(2));
        Assert.assertThat((Object)node_a1.getName().getIndex(), Is.is(1));
        Name name_b = (Name)this.nameFactory.create("b");
        MapNode node_b = this.workspace.createNode(this.context, this.workspace.getRoot(), name_b, null, this.NO_PROPS);
        Assert.assertThat((Object)node_b, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_b.getParent(), Is.is(this.workspace.getRoot()));
        Assert.assertThat((Object)node_b.getName().getName(), Is.is(name_b));
        Assert.assertThat((Object)node_b.getName().hasIndex(), Is.is(false));
        Name name_a3 = (Name)this.nameFactory.create("a");
        MapNode node_a3 = this.workspace.createNode(this.context, this.workspace.getRoot(), name_a3, null, this.NO_PROPS);
        Assert.assertThat((Object)node_a3, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node_a3.getParent(), Is.is(this.workspace.getRoot()));
        Assert.assertThat((Object)node_a3.getName().getName(), Is.is(name_a3));
        Assert.assertThat((Object)node_a3.getName().hasIndex(), Is.is(true));
        Assert.assertThat((Object)node_a3.getName().getIndex(), Is.is(3));
        Assert.assertThat((Object)this.workspace.getRoot().getChildren().size(), Is.is(4));
        Assert.assertThat((Object)this.workspace.getRoot().getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new MapNode[]{node_a1, node_a2, node_b, node_a3}));
        Assert.assertThat((Object)this.workspace.size(), Is.is(5));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a[1]")), Is.is(IsSame.sameInstance(node_a1)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a[2]")), Is.is(IsSame.sameInstance(node_a2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a[3]")), Is.is(IsSame.sameInstance(node_a3)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/b")), Is.is(IsSame.sameInstance(node_b)));
        this.workspace.removeNode(this.context, node_a2);
        Assert.assertThat((Object)this.workspace.getRoot().getChildren().size(), Is.is(3));
        Assert.assertThat((Object)this.workspace.getRoot().getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new MapNode[]{node_a1, node_b, node_a3}));
        Assert.assertThat((Object)node_a1.getName().getIndex(), Is.is(1));
        Assert.assertThat((Object)node_b.getName().hasIndex(), Is.is(false));
        Assert.assertThat((Object)node_a3.getName().getIndex(), Is.is(2));
        this.workspace.removeNode(this.context, node_a1);
        Assert.assertThat((Object)this.workspace.getRoot().getChildren().size(), Is.is(2));
        Assert.assertThat((Object)this.workspace.getRoot().getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new MapNode[]{node_b, node_a3}));
        Assert.assertThat((Object)node_b.getName().hasIndex(), Is.is(false));
        Assert.assertThat((Object)node_a3.getName().hasIndex(), Is.is(false));
        Assert.assertThat((Object)this.workspace.size(), Is.is(3));
    }

    @Test
    public void shouldMoveNodesWithinSameWorkspace() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        this.workspace.moveNode(this.context, node_b, null, (MapWorkspace)this.workspace, node_d, null);
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[1]")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c")), Is.is(IsSame.sameInstance(node_c)));
        this.workspace.moveNode(this.context, node_b, null, (MapWorkspace)this.workspace, node_e, null);
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
    }

    @Test
    public void shouldMoveNodeBeforeAnother() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        Name propName = (Name)this.nameFactory.create("prop");
        node_b.setProperty(this.propertyFactory.create(propName, new Object[]{"node_b"}));
        node_b2.setProperty(this.propertyFactory.create(propName, new Object[]{"node_b2"}));
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propName).getFirstValue().toString(), Is.is("node_b"));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")).getProperty(propName).getFirstValue().toString(), Is.is("node_b2"));
        this.workspace.moveNode(this.context, node_b, null, (MapWorkspace)this.workspace, node_d, node_b2);
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[1]")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[1]/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[1]")).getProperty(propName).getFirstValue().toString(), Is.is("node_b"));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]")).getProperty(propName).getFirstValue().toString(), Is.is("node_b2"));
        this.workspace.moveNode(this.context, node_b, null, (MapWorkspace)this.workspace, root, null);
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
    }

    @Test
    public void shouldMoveNodesFromOneWorkspaceToAnother() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        InMemoryRepository.Workspace new_workspace = (InMemoryRepository.Workspace)this.repository.createWorkspace(this.context, "Second Workspace", CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
        Assert.assertThat((Object)new_workspace, Is.is(IsNull.notNullValue()));
        MapNode new_root = new_workspace.getRoot();
        MapNode new_node_a = new_workspace.createNode(this.context, new_root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode new_node_b = new_workspace.createNode(this.context, new_node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode new_node_c = new_workspace.createNode(this.context, new_node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode new_node_d = new_workspace.createNode(this.context, new_root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode new_node_e = new_workspace.createNode(this.context, new_node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode new_node_b2 = new_workspace.createNode(this.context, new_node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        Assert.assertThat((Object)new_workspace.size(), Is.is(7));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(new_root)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(new_node_a)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(new_node_b)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(new_node_c)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(new_node_d)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(new_node_e)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(new_node_b2)));
        this.workspace.moveNode(this.context, node_b, null, (MapWorkspace)new_workspace, new_node_d, null);
        Assert.assertThat((Object)this.workspace.size(), Is.is(5));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)new_workspace.size(), Is.is(9));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(new_root)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(new_node_a)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(new_node_d)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(new_node_e)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[1]")), Is.is(IsSame.sameInstance(new_node_b2)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c")), Is.is(IsSame.sameInstance(node_c)));
    }

    @Test
    public void shouldCopyNodesWithinSameWorkspace() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        ValueFactory stringFactory = this.valueFactories.getStringFactory();
        Name propertyName = (Name)this.nameFactory.create("something");
        Property property = this.propertyFactory.create(propertyName, new Object[]{stringFactory.create("Worth the wait")});
        node_b.setProperty(property);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        this.workspace.copyNode(this.context, node_b, (MapWorkspace)this.workspace, node_d, null, true, new HashMap());
        Assert.assertThat((Object)this.workspace.size(), Is.is(9));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[1]")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b[2]")).getProperty(propertyName), Is.is(property));
    }

    @Test
    public void shouldCopyNodesFromOneWorkspaceToAnotherAndKeepSameUuids() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        ValueFactory stringFactory = this.valueFactories.getStringFactory();
        Name propertyName = (Name)this.nameFactory.create("something");
        Property property = this.propertyFactory.create(propertyName, new Object[]{stringFactory.create("Worth the wait")});
        node_b.setProperty(property);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        InMemoryRepository.Workspace new_workspace = (InMemoryRepository.Workspace)this.repository.createWorkspace(this.context, "Second Workspace", CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
        Assert.assertThat((Object)new_workspace, Is.is(IsNull.notNullValue()));
        MapNode new_root = new_workspace.getRoot();
        MapNode new_node_a = new_workspace.createNode(this.context, new_root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode new_node_b = new_workspace.createNode(this.context, new_node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode new_node_c = new_workspace.createNode(this.context, new_node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode new_node_d = new_workspace.createNode(this.context, new_root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode new_node_e = new_workspace.createNode(this.context, new_node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode new_node_b2 = new_workspace.createNode(this.context, new_node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        Assert.assertThat((Object)new_workspace.size(), Is.is(7));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(new_root)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(new_node_a)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(new_node_b)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(new_node_c)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(new_node_d)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(new_node_e)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(new_node_b2)));
        this.workspace.copyNode(this.context, node_b, (MapWorkspace)new_workspace, new_node_d, null, true, (Map)null);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        Assert.assertThat((Object)new_workspace.size(), Is.is(9));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(new_root)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(new_node_a)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(new_node_b)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(new_node_c)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(new_node_d)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(new_node_e)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[1]")), Is.is(IsSame.sameInstance(new_node_b2)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]")).getProperty(propertyName), Is.is(property));
        MapNode new_copy_b = new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]"));
        MapNode new_copy_c = new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c"));
        Assert.assertThat((Object)new_copy_b, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_copy_c, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_copy_b.getUuid(), Is.is(node_b.getUuid()));
        Assert.assertThat((Object)new_copy_c.getUuid(), Is.is(node_c.getUuid()));
    }

    @Test
    public void shouldCopyNodesFromOneWorkspaceToAnotherAndGenerateNewUuids() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        ValueFactory stringFactory = this.valueFactories.getStringFactory();
        Name propertyName = (Name)this.nameFactory.create("something");
        Property property = this.propertyFactory.create(propertyName, new Object[]{stringFactory.create("Worth the wait")});
        node_b.setProperty(property);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        InMemoryRepository.Workspace new_workspace = (InMemoryRepository.Workspace)this.repository.createWorkspace(this.context, "Second Workspace", CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
        Assert.assertThat((Object)new_workspace, Is.is(IsNull.notNullValue()));
        MapNode new_root = new_workspace.getRoot();
        MapNode new_node_a = new_workspace.createNode(this.context, new_root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode new_node_b = new_workspace.createNode(this.context, new_node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode new_node_c = new_workspace.createNode(this.context, new_node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode new_node_d = new_workspace.createNode(this.context, new_root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode new_node_e = new_workspace.createNode(this.context, new_node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode new_node_b2 = new_workspace.createNode(this.context, new_node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        Assert.assertThat((Object)new_workspace.size(), Is.is(7));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(new_root)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(new_node_a)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(new_node_b)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(new_node_c)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(new_node_d)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(new_node_e)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(new_node_b2)));
        HashMap oldToNewUuids = new HashMap();
        this.workspace.copyNode(this.context, node_b, (MapWorkspace)new_workspace, new_node_d, null, true, oldToNewUuids);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        Assert.assertThat((Object)new_workspace.size(), Is.is(9));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(new_root)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(new_node_a)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(new_node_b)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(new_node_c)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(new_node_d)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(new_node_e)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[1]")), Is.is(IsSame.sameInstance(new_node_b2)));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]")).getProperty(propertyName), Is.is(property));
        MapNode new_copy_b = new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]"));
        MapNode new_copy_c = new_workspace.getNode((Path)this.pathFactory.create("/d/b[2]/c"));
        Assert.assertThat((Object)new_copy_b, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_copy_c, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)new_copy_b.getUuid(), Is.is(IsNot.not(node_b.getUuid())));
        Assert.assertThat((Object)new_copy_c.getUuid(), Is.is(IsNot.not(node_c.getUuid())));
        Assert.assertThat((Object)new_copy_b.getUuid(), Is.is(oldToNewUuids.get(node_b.getUuid())));
        Assert.assertThat((Object)new_copy_c.getUuid(), Is.is(oldToNewUuids.get(node_c.getUuid())));
    }

    @Test
    public void shouldCopyNodesWhenDesiredNameIsSpecified() {
        MapNode root = this.workspace.getRoot();
        MapNode node_a = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("a"), null, this.NO_PROPS);
        MapNode node_b = this.workspace.createNode(this.context, node_a, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        MapNode node_c = this.workspace.createNode(this.context, node_b, (Name)this.nameFactory.create("c"), null, this.NO_PROPS);
        MapNode node_d = this.workspace.createNode(this.context, root, (Name)this.nameFactory.create("d"), null, this.NO_PROPS);
        MapNode node_e = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("e"), null, this.NO_PROPS);
        MapNode node_b2 = this.workspace.createNode(this.context, node_d, (Name)this.nameFactory.create("b"), null, this.NO_PROPS);
        ValueFactory stringFactory = this.valueFactories.getStringFactory();
        Name propertyName = (Name)this.nameFactory.create("something");
        Property property = this.propertyFactory.create(propertyName, new Object[]{stringFactory.create("Worth the wait")});
        node_b.setProperty(property);
        Assert.assertThat((Object)this.workspace.size(), Is.is(7));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        this.workspace.copyNode(this.context, node_b, (MapWorkspace)this.workspace, node_d, (Name)this.nameFactory.create("x"), true, new HashMap());
        Assert.assertThat((Object)this.workspace.size(), Is.is(9));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/")), Is.is(IsSame.sameInstance(this.workspace.getRoot())));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a")), Is.is(IsSame.sameInstance(node_a)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")), Is.is(IsSame.sameInstance(node_b)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b/c")), Is.is(IsSame.sameInstance(node_c)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d")), Is.is(IsSame.sameInstance(node_d)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/e")), Is.is(IsSame.sameInstance(node_e)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/b")), Is.is(IsSame.sameInstance(node_b2)));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/x")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/x/c")), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/a/b")).getProperty(propertyName), Is.is(property));
        Assert.assertThat((Object)this.workspace.getNode((Path)this.pathFactory.create("/d/x")).getProperty(propertyName), Is.is(property));
    }

    @Test
    public void shouldCreateRepositoryStructure() {
        this.workspace.createNode(this.context, "/a", this.NO_PROPS).setProperty(this.context, "name", new Object[]{"value"}).setProperty(this.context, "desc", new Object[]{"Some description"});
        this.workspace.createNode(this.context, "/a/b", this.NO_PROPS).setProperty(this.context, "name", new Object[]{"value2"}).setProperty(this.context, "desc", new Object[]{"Some description 2"});
        Assert.assertThat((Object)this.workspace.getNode(this.context, "/a").getProperty(this.context, "name").getValuesAsArray(), Is.is(new Object[]{"value"}));
        Assert.assertThat((Object)this.workspace.getNode(this.context, "/a").getProperty(this.context, "desc").getValuesAsArray(), Is.is(new Object[]{"Some description"}));
        Assert.assertThat((Object)this.workspace.getNode(this.context, "/a/b").getProperty(this.context, "name").getValuesAsArray(), Is.is(new Object[]{"value2"}));
        Assert.assertThat((Object)this.workspace.getNode(this.context, "/a/b").getProperty(this.context, "desc").getValuesAsArray(), Is.is(new Object[]{"Some description 2"}));
    }
}

