/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueComparators;
import org.modeshape.graph.property.ValueFactories;

public class ObjectValueComparatorTest {
    private ExecutionContext context;
    private ValueFactories factories;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.factories = this.context.getValueFactories();
    }

    @Test
    public void shouldCompareBinaryAndStringValues() {
        String strValue = "Jack and Jill went up the hill";
        Binary binaryValue = (Binary)this.factories.getBinaryFactory().create(strValue);
        Binary binarySpy = (Binary)Mockito.spy((Object)binaryValue);
        Assert.assertThat((Object)ValueComparators.OBJECT_COMPARATOR.compare(strValue, binarySpy), Is.is(0));
        Assert.assertThat((Object)ValueComparators.OBJECT_COMPARATOR.compare(binarySpy, strValue), Is.is(0));
        ((Binary)Mockito.verify((Object)binarySpy, (VerificationMode)Mockito.times((int)0))).getBytes();
        ((Binary)Mockito.verify((Object)binarySpy, (VerificationMode)Mockito.times((int)0))).getStream();
        ((Binary)Mockito.verify((Object)binarySpy, (VerificationMode)Mockito.atLeastOnce())).getHash();
    }

    @Test
    public void shouldCompareLongAndStringValues() {
        String strValue = "3";
        Long longValue = (Long)this.factories.getLongFactory().create(strValue);
        Assert.assertThat((Object)ValueComparators.OBJECT_COMPARATOR.compare(strValue, longValue), Is.is(0));
        Assert.assertThat((Object)ValueComparators.OBJECT_COMPARATOR.compare(longValue, strValue), Is.is(0));
    }

    public void shouldComparePathAndStringValues() {
        String strValue = "/a/b/c";
        Path pathValue = (Path)this.factories.getPathFactory().create(strValue);
        Assert.assertThat((Object)ValueComparators.OBJECT_COMPARATOR.compare(strValue, pathValue), Is.is(0));
        Assert.assertThat((Object)ValueComparators.OBJECT_COMPARATOR.compare(pathValue, strValue), Is.is(0));
    }
}

