/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.basic.BasicNamespace;

public class BasicNamespaceTest {
    private BasicNamespace ns1;
    private BasicNamespace ns2;
    private BasicNamespace ns3;
    private BasicNamespace ns4;
    private BasicNamespace ns5;
    private String validUri1;
    private String validUri2;
    private String validUri3;
    private String validPrefix1;
    private String validPrefix2;
    private String validPrefix3;

    @Before
    public void beforeEach() {
        this.validUri1 = "";
        this.validUri2 = "http://www.example.com";
        this.validUri3 = "http://www.acme.com";
        this.validPrefix1 = "";
        this.validPrefix2 = "a";
        this.validPrefix3 = "b";
        this.ns1 = new BasicNamespace(this.validPrefix1, this.validUri1);
        this.ns2 = new BasicNamespace(this.validPrefix1, this.validUri2);
        this.ns3 = new BasicNamespace(this.validPrefix2, this.validUri1);
        this.ns4 = new BasicNamespace(this.validPrefix2, this.validUri2);
        this.ns5 = new BasicNamespace(this.validPrefix3, this.validUri3);
    }

    @Test
    public void shouldHaveSamePrefixPassedIntoConstructor() {
        Assert.assertThat((Object)this.ns1.getPrefix(), Is.is(this.validPrefix1));
        Assert.assertThat((Object)this.ns2.getPrefix(), Is.is(this.validPrefix1));
        Assert.assertThat((Object)this.ns3.getPrefix(), Is.is(this.validPrefix2));
        Assert.assertThat((Object)this.ns4.getPrefix(), Is.is(this.validPrefix2));
        Assert.assertThat((Object)this.ns5.getPrefix(), Is.is(this.validPrefix3));
    }

    @Test
    public void shouldHaveSameNamespaceUriPassedIntoConstructor() {
        Assert.assertThat((Object)this.ns1.getNamespaceUri(), Is.is(this.validUri1));
        Assert.assertThat((Object)this.ns2.getNamespaceUri(), Is.is(this.validUri2));
        Assert.assertThat((Object)this.ns3.getNamespaceUri(), Is.is(this.validUri1));
        Assert.assertThat((Object)this.ns4.getNamespaceUri(), Is.is(this.validUri2));
        Assert.assertThat((Object)this.ns5.getNamespaceUri(), Is.is(this.validUri3));
    }

    @Test
    public void shouldConsiderAsEqualAnyNamespacesWithSameUri() {
        Assert.assertThat((Object)this.ns1.equals((Object)this.ns3), Is.is(true));
        Assert.assertThat((Object)this.ns3.equals((Object)this.ns1), Is.is(true));
        Assert.assertThat((Object)this.ns2.equals((Object)this.ns4), Is.is(true));
        Assert.assertThat((Object)this.ns4.equals((Object)this.ns2), Is.is(true));
        Assert.assertThat((Object)this.ns5.equals((Object)this.ns5), Is.is(true));
    }

    @Test
    public void shouldNotConsiderAsEqualAnyNamespacesWithDifferentUris() {
        Assert.assertThat((Object)this.ns1.equals((Object)this.ns2), Is.is(false));
        Assert.assertThat((Object)this.ns2.equals((Object)this.ns1), Is.is(false));
        Assert.assertThat((Object)this.ns3.equals((Object)this.ns4), Is.is(false));
        Assert.assertThat((Object)this.ns4.equals((Object)this.ns3), Is.is(false));
    }
}

