/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.DoubleValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class DoubleValueFactoryTest {
    private NamespaceRegistry registry;
    private DoubleValueFactory factory;
    private StringValueFactory stringFactory;

    @Before
    public void setUp() throws Exception {
        this.registry = new SimpleNamespaceRegistry();
        this.stringFactory = new StringValueFactory(this.registry, Path.URL_DECODER, Path.URL_ENCODER);
        this.factory = new DoubleValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromBooleanValue() {
        this.factory.create(true);
    }

    @Test
    public void shouldCreateDoubleFromString() {
        Assert.assertThat((Object)this.factory.create("1"), Is.is(1.0));
        Assert.assertThat((Object)this.factory.create("-1.0"), Is.is(-1.0));
        Assert.assertThat((Object)this.factory.create("100.000101"), Is.is(100.000101));
    }

    @Test
    public void shouldCreateDoubleFromStringRegardlessOfLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.factory.create("  1  "), Is.is(1.0));
        Assert.assertThat((Object)this.factory.create("  -1.0  "), Is.is(-1.0));
        Assert.assertThat((Object)this.factory.create("  100.000101  "), Is.is(100.000101));
    }

    @Test
    public void shouldNotCreateDoubleFromIntegerValue() {
        Assert.assertThat((Object)this.factory.create(1), Is.is(1.0));
    }

    @Test
    public void shouldNotCreateDoubleFromLongValue() {
        Assert.assertThat((Object)this.factory.create(1L), Is.is(1.0));
    }

    @Test
    public void shouldNotCreateDoubleFromFloatValue() {
        Assert.assertThat((Object)this.factory.create(1.0f), Is.is(1.0));
    }

    @Test
    public void shouldNotCreateDoubleFromDoubleValue() {
        Assert.assertThat((Object)this.factory.create(1.0), Is.is(1.0));
    }

    @Test
    public void shouldCreateDoubleFromBigDecimal() {
        BigDecimal value = new BigDecimal(100);
        Assert.assertThat((Object)this.factory.create(value), Is.is(value.doubleValue()));
    }

    @Test
    public void shouldCreateDoubleFromDate() {
        Date value = new Date();
        Assert.assertThat((Object)this.factory.create(value), Is.is(Double.valueOf(value.getTime())));
    }

    @Test
    public void shouldCreateDoubleFromCalendar() {
        Calendar value = Calendar.getInstance();
        Assert.assertThat((Object)this.factory.create(value), Is.is(Double.valueOf(value.getTimeInMillis())));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromName() {
        this.factory.create((Name)Mockito.mock(Name.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromPath() {
        this.factory.create((Path)Mockito.mock(Path.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromReference() {
        this.factory.create((Reference)Mockito.mock(Reference.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromUri() throws Exception {
        this.factory.create(new URI("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateDoubleFromByteArrayContainingUtf8EncodingOfStringWithDouble() throws Exception {
        Assert.assertThat((Object)this.factory.create("0.1".getBytes("UTF-8")), Is.is(0.1));
        Assert.assertThat((Object)this.factory.create("1".getBytes("UTF-8")), Is.is(1.0));
        Assert.assertThat((Object)this.factory.create("-1.03".getBytes("UTF-8")), Is.is(-1.03));
        Assert.assertThat((Object)this.factory.create("1003044".getBytes("UTF-8")), Is.is(1003044.0));
    }

    @Test
    public void shouldCreateDoubleFromInputStreamContainingUtf8EncodingOfStringWithDouble() throws Exception {
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("0.1".getBytes("UTF-8"))), Is.is(0.1));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("1".getBytes("UTF-8"))), Is.is(1.0));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("-1.03".getBytes("UTF-8"))), Is.is(-1.03));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("1003044".getBytes("UTF-8"))), Is.is(1003044.0));
    }

    @Test
    public void shouldCreateDoubleFromReaderContainingStringWithDouble() {
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("0.1")), Is.is(0.1));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("1")), Is.is(1.0));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("-1.03")), Is.is(-1.03));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("1003044")), Is.is(1003044.0));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromByteArrayContainingUtf8EncodingOfStringWithContentsOtherThanDouble() throws Exception {
        this.factory.create("something".getBytes("UTF-8"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromInputStreamContainingUtf8EncodingOfStringWithContentsOtherThanDouble() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromReaderContainingStringWithContentsOtherThanDouble() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add("" + i);
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), Is.is(this.factory.create((String)valueIter.next())));
        }
    }
}

