/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.JodaDateTime;
import org.modeshape.graph.property.basic.JodaDateTimeValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class JodaDateTimeValueFactoryTest {
    public static final DateTime TODAY;
    public static final DateTime LAST_YEAR;
    private JodaDateTimeValueFactory factory;
    private StringValueFactory stringFactory;

    @Before
    public void setUp() throws Exception {
        this.stringFactory = new StringValueFactory((NamespaceRegistry)new SimpleNamespaceRegistry(), Path.URL_DECODER, Path.URL_ENCODER);
        this.factory = new JodaDateTimeValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromBoolean() {
        this.factory.create(true);
    }

    @Test
    public void shouldCreateDateFromString() {
        Assert.assertThat((Object)this.factory.create(TODAY.getString()), Is.is(TODAY));
        Assert.assertThat((Object)this.factory.create(LAST_YEAR.getString()), Is.is(LAST_YEAR));
    }

    @Test
    public void shouldCreateDateFromStringRegardlessOfLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.factory.create("  " + TODAY.getString() + "  "), Is.is(TODAY));
        Assert.assertThat((Object)this.factory.create("  " + LAST_YEAR.getString() + "  "), Is.is(LAST_YEAR));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromStringThatIsNotInTheStandardFormat() {
        this.factory.create("something");
    }

    @Test
    public void shouldNotCreateDateFromIntegerValue() {
        Assert.assertThat((Object)this.factory.create(10000), Is.is(new JodaDateTime(10000L)));
    }

    @Test
    public void shouldNotCreateDateFromLongValue() {
        Assert.assertThat((Object)this.factory.create(10000L), Is.is(new JodaDateTime(10000L)));
    }

    @Test
    public void shouldNotCreateDateFromFloatValue() {
        Assert.assertThat((Object)this.factory.create(10000.123f), Is.is(new JodaDateTime(10000L)));
    }

    @Test
    public void shouldNotCreateDateFromDoubleValue() {
        Assert.assertThat((Object)this.factory.create(10000.12345), Is.is(new JodaDateTime(10000L)));
    }

    @Test
    public void shouldCreateDateFromBigDecimal() {
        Assert.assertThat((Object)this.factory.create(new BigDecimal(10000)), Is.is(new JodaDateTime(10000L)));
    }

    @Test
    public void shouldCreateDateFromDate() {
        Calendar value = Calendar.getInstance();
        Assert.assertThat((Object)this.factory.create(value.getTime()), Is.is(new JodaDateTime(value.getTime())));
    }

    @Test
    public void shouldCreateDateFromCalendar() {
        Calendar value = Calendar.getInstance();
        value.setTimeInMillis(10000L);
        Assert.assertThat((Object)this.factory.create(value), Is.is(new JodaDateTime(value)));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromName() {
        this.factory.create((Name)Mockito.mock(Name.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromPath() {
        this.factory.create((Path)Mockito.mock(Path.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromReference() {
        this.factory.create((Reference)Mockito.mock(Reference.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromUri() throws Exception {
        this.factory.create(new URI("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateDateFromByteArrayContainingUtf8EncodingOfStringWithWellFormedDate() throws Exception {
        Assert.assertThat((Object)this.factory.create(TODAY.getString().getBytes("UTF-8")), Is.is(TODAY));
        Assert.assertThat((Object)this.factory.create(LAST_YEAR.getString().getBytes("UTF-8")), Is.is(LAST_YEAR));
    }

    @Test
    public void shouldCreateDateFromInputStreamContainingUtf8EncodingOfStringWithWellFormedDate() throws Exception {
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream(TODAY.getString().getBytes("UTF-8"))), Is.is(TODAY));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream(LAST_YEAR.getString().getBytes("UTF-8"))), Is.is(LAST_YEAR));
    }

    @Test
    public void shouldCreateDateFromReaderContainingStringWithWellFormedDate() {
        Assert.assertThat((Object)this.factory.create((Object)new StringReader(TODAY.getString())), Is.is(TODAY));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader(LAST_YEAR.getString())), Is.is(LAST_YEAR));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromByteArrayContainingUtf8EncodingOfStringWithContentThatIsNotWellFormedDate() throws Exception {
        this.factory.create("something".getBytes("UTF-8"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromInputStreamContainingUtf8EncodingOfStringWithContentThatIsNotWellFormedDate() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDateFromReaderContainingStringWithContentThatIsNotWellFormedDate() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add(new JodaDateTime((long)(10000 + i)).toString());
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), Is.is(this.factory.create((String)valueIter.next())));
        }
    }

    static {
        org.joda.time.DateTime now = new org.joda.time.DateTime();
        TODAY = new JodaDateTime(now);
        LAST_YEAR = new JodaDateTime(now.minusYears(1));
    }
}

