/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Collections;
import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.query.model.AbstractQueryObjectTest;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;

public class QueryTest
extends AbstractQueryObjectTest {
    private Query query;
    private Source source;
    private Constraint constraint;
    private List<Ordering> orderings;
    private List<Column> columns;
    private Limit limits;
    private boolean distinct;

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateWithNullSource() {
        new Query(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateWithNullSourceWhenSupplyingOtherParameters() {
        this.source = null;
        this.constraint = (Constraint)Mockito.mock(Constraint.class);
        this.orderings = Collections.emptyList();
        this.columns = Collections.emptyList();
        this.limits = null;
        new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
    }

    @Test
    public void shouldAllowNullConstraint() {
        this.source = (Source)Mockito.mock(Source.class);
        this.constraint = null;
        this.orderings = Collections.emptyList();
        this.columns = Collections.emptyList();
        this.limits = null;
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)this.query.getSource(), Is.is(IsSame.sameInstance(this.source)));
        Assert.assertThat((Object)this.query.getConstraint(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.query.getOrderings(), Is.is(IsSame.sameInstance(this.orderings)));
        Assert.assertThat((Object)this.query.getColumns(), Is.is(IsSame.sameInstance(this.columns)));
    }

    @Test
    public void shouldAllowNullOrderingsList() {
        this.source = (Source)Mockito.mock(Source.class);
        this.constraint = (Constraint)Mockito.mock(Constraint.class);
        this.orderings = null;
        this.columns = Collections.emptyList();
        this.limits = null;
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)this.query.getSource(), Is.is(IsSame.sameInstance(this.source)));
        Assert.assertThat((Object)this.query.getConstraint(), Is.is(IsSame.sameInstance(this.constraint)));
        Assert.assertThat((Object)this.query.getOrderings().isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.query.getColumns(), Is.is(IsSame.sameInstance(this.columns)));
    }

    @Test
    public void shouldAllowNullColumnsList() {
        this.source = (Source)Mockito.mock(Source.class);
        this.constraint = (Constraint)Mockito.mock(Constraint.class);
        this.orderings = Collections.emptyList();
        this.columns = null;
        this.limits = null;
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)this.query.getSource(), Is.is(IsSame.sameInstance(this.source)));
        Assert.assertThat((Object)this.query.getConstraint(), Is.is(IsSame.sameInstance(this.constraint)));
        Assert.assertThat((Object)this.query.getOrderings(), Is.is(IsSame.sameInstance(this.orderings)));
        Assert.assertThat((Object)this.query.getColumns().isEmpty(), Is.is(true));
    }

    @Test
    public void shouldCreateWithNonNullParameters() {
        this.source = (Source)Mockito.mock(Source.class);
        this.constraint = (Constraint)Mockito.mock(Constraint.class);
        this.orderings = Collections.emptyList();
        this.columns = Collections.emptyList();
        this.limits = null;
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)this.query.getSource(), Is.is(IsSame.sameInstance(this.source)));
        Assert.assertThat((Object)this.query.getConstraint(), Is.is(IsSame.sameInstance(this.constraint)));
        Assert.assertThat((Object)this.query.getOrderings(), Is.is(IsSame.sameInstance(this.orderings)));
        Assert.assertThat((Object)this.query.getColumns(), Is.is(IsSame.sameInstance(this.columns)));
    }

    @Test
    public void shouldConstructReadableString() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.singletonList(new Column(this.selector("selector1")));
        this.constraint = new PropertyExistence(this.selector("selector1"), "jcr:uuid");
        this.orderings = Collections.singletonList(new Ordering((DynamicOperand)new NodeName(this.selector("selector1")), Order.ASCENDING));
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT selector1.* FROM nt:unstructured WHERE selector1.jcr:uuid IS NOT NULL ORDER BY NAME(selector1) ASC"));
    }

    @Test
    public void shouldConstructReadableStringWithLimits() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.singletonList(new Column(this.selector("selector1")));
        this.constraint = new PropertyExistence(this.selector("selector1"), "jcr:uuid");
        this.orderings = Collections.singletonList(new Ordering((DynamicOperand)new NodeName(this.selector("selector1")), Order.ASCENDING));
        this.limits = new Limit(10, 100);
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT selector1.* FROM nt:unstructured WHERE selector1.jcr:uuid IS NOT NULL ORDER BY NAME(selector1) ASC LIMIT 10 OFFSET 100"));
    }

    @Test
    public void shouldConstructReadableStringWithNoColumns() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.emptyList();
        this.constraint = new PropertyExistence(this.selector("selector1"), "jcr:uuid");
        this.orderings = Collections.singletonList(new Ordering((DynamicOperand)new NodeName(this.selector("selector1")), Order.ASCENDING));
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM nt:unstructured WHERE selector1.jcr:uuid IS NOT NULL ORDER BY NAME(selector1) ASC"));
    }

    @Test
    public void shouldConstructReadableStringWithNoOrderings() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.singletonList(new Column(this.selector("selector1")));
        this.constraint = new PropertyExistence(this.selector("selector1"), "jcr:uuid");
        this.orderings = Collections.emptyList();
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT selector1.* FROM nt:unstructured WHERE selector1.jcr:uuid IS NOT NULL"));
    }

    @Test
    public void shouldConstructReadableStringWithNoConstraint() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.singletonList(new Column(this.selector("selector1")));
        this.constraint = null;
        this.orderings = Collections.singletonList(new Ordering((DynamicOperand)new NodeName(this.selector("selector1")), Order.ASCENDING));
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT selector1.* FROM nt:unstructured ORDER BY NAME(selector1) ASC"));
    }

    @Test
    public void shouldConstructReadableStringWithDistinctAndNoConstraintOrColumnsOrOrderings() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.emptyList();
        this.constraint = null;
        this.orderings = Collections.emptyList();
        this.distinct = true;
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT DISTINCT * FROM nt:unstructured"));
        this.source = new AllNodes();
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT DISTINCT * FROM __ALLNODES__"));
    }

    @Test
    public void shouldConstructReadableStringWithNoConstraintOrColumnsOrOrderings() {
        this.source = new NamedSelector(this.selector("nt:unstructured"));
        this.columns = Collections.emptyList();
        this.constraint = null;
        this.orderings = Collections.emptyList();
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM nt:unstructured"));
        this.source = new AllNodes();
        this.query = new Query(this.source, this.constraint, this.orderings, this.columns, this.limits, this.distinct);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM __ALLNODES__"));
    }
}

