/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.query.model.AbstractQueryObjectTest;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;

public class SetQueryTest
extends AbstractQueryObjectTest {
    private SetQuery query;
    private QueryCommand left;
    private QueryCommand right;
    private SetQuery.Operation operation;
    private boolean all;

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateWithNullSource() {
        new Query(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateWithNullLeftQueryCommand() {
        this.left = null;
        this.right = (QueryCommand)Mockito.mock(QueryCommand.class);
        this.operation = SetQuery.Operation.UNION;
        new SetQuery(this.left, this.operation, this.right, this.all);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateWithNullRightQueryCommand() {
        this.left = (QueryCommand)Mockito.mock(QueryCommand.class);
        this.right = null;
        this.operation = SetQuery.Operation.UNION;
        new SetQuery(this.left, this.operation, this.right, this.all);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateWithNullOperation() {
        this.left = (QueryCommand)Mockito.mock(QueryCommand.class);
        this.right = (QueryCommand)Mockito.mock(QueryCommand.class);
        this.operation = null;
        new SetQuery(this.left, this.operation, this.right, this.all);
    }

    @Test
    public void shouldCreateWithNonNullQueryCommandsAndUnionOperation() {
        this.left = new Query((Source)new NamedSelector(this.selector("A")));
        this.right = new Query((Source)new NamedSelector(this.selector("B")));
        this.operation = SetQuery.Operation.UNION;
        this.query = new SetQuery(this.left, this.operation, this.right, this.all);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM A UNION SELECT * FROM B"));
    }

    @Test
    public void shouldCreateWithNonNullQueryCommandsAndUnionAllOperation() {
        this.left = new Query((Source)new NamedSelector(this.selector("A")));
        this.right = new Query((Source)new NamedSelector(this.selector("B")));
        this.operation = SetQuery.Operation.UNION;
        this.all = true;
        this.query = new SetQuery(this.left, this.operation, this.right, this.all);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM A UNION ALL SELECT * FROM B"));
    }

    @Test
    public void shouldCreateWithNonNullQueryCommandsAndIntersectOperation() {
        this.left = new Query((Source)new NamedSelector(this.selector("A")));
        this.right = new Query((Source)new NamedSelector(this.selector("B")));
        this.operation = SetQuery.Operation.INTERSECT;
        this.query = new SetQuery(this.left, this.operation, this.right, this.all);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM A INTERSECT SELECT * FROM B"));
    }

    @Test
    public void shouldCreateWithNonNullQueryCommandsAndIntersectAllOperation() {
        this.left = new Query((Source)new NamedSelector(this.selector("A")));
        this.right = new Query((Source)new NamedSelector(this.selector("B")));
        this.operation = SetQuery.Operation.INTERSECT;
        this.all = true;
        this.query = new SetQuery(this.left, this.operation, this.right, this.all);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM A INTERSECT ALL SELECT * FROM B"));
    }

    @Test
    public void shouldCreateWithNonNullQueryCommandsAndExceptOperation() {
        this.left = new Query((Source)new NamedSelector(this.selector("A")));
        this.right = new Query((Source)new NamedSelector(this.selector("B")));
        this.operation = SetQuery.Operation.EXCEPT;
        this.query = new SetQuery(this.left, this.operation, this.right, this.all);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM A EXCEPT SELECT * FROM B"));
    }

    @Test
    public void shouldCreateWithNonNullQueryCommandsAndExceptAllOperation() {
        this.left = new Query((Source)new NamedSelector(this.selector("A")));
        this.right = new Query((Source)new NamedSelector(this.selector("B")));
        this.operation = SetQuery.Operation.EXCEPT;
        this.all = true;
        this.query = new SetQuery(this.left, this.operation, this.right, this.all);
        Assert.assertThat((Object)Visitors.readable((Visitable)this.query), Is.is("SELECT * FROM A EXCEPT ALL SELECT * FROM B"));
    }
}

